/*
 * Decompiled with CFR 0.152.
 */
package com.daprlabs.aaron.swipedeck.Utility;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Deck<T>
implements List<T> {
    private ArrayList<T> internalList = new ArrayList();
    private ListEventListener listener;

    public Deck(ListEventListener listener) {
        this.listener = listener;
    }

    @Override
    public void add(int location, T object) {
        this.internalList.add(location, object);
        this.listener.itemAdded(object, location);
    }

    @Override
    public boolean add(T object) {
        T itemToBeAdded = object;
        boolean added = this.internalList.add(itemToBeAdded);
        this.listener.itemAdded(object, this.internalList.indexOf(itemToBeAdded));
        return added;
    }

    @Override
    public boolean addAll(int location, Collection<? extends T> collection) {
        return this.internalList.addAll(location, collection);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return this.internalList.addAll(collection);
    }

    @Override
    public void clear() {
        for (T t : this.internalList) {
            this.listener.itemRemoved(t);
        }
        this.internalList.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.internalList.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.internalList.containsAll(collection);
    }

    @Override
    public T get(int location) {
        return this.internalList.get(location);
    }

    @Override
    public int indexOf(Object object) {
        return this.internalList.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.internalList.isEmpty();
    }

    @Override
    @NonNull
    public Iterator<T> iterator() {
        return this.internalList.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.internalList.lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.internalList.listIterator();
    }

    @Override
    @NonNull
    public ListIterator<T> listIterator(int location) {
        return this.internalList.listIterator(location);
    }

    @Override
    public T remove(int location) {
        T itemToRemove = this.internalList.get(location);
        this.listener.itemRemoved(itemToRemove);
        this.internalList.remove(itemToRemove);
        for (int i = location; i < this.internalList.size(); ++i) {
            this.listener.itemPositionChanged(this.internalList.get(i), i);
        }
        return itemToRemove;
    }

    @Override
    public boolean remove(Object object) {
        Object itemToRemove = object;
        int index = this.internalList.indexOf(itemToRemove);
        boolean removed = this.internalList.remove(itemToRemove);
        if (removed) {
            for (int i = index; i < this.internalList.size(); ++i) {
                this.listener.itemPositionChanged(this.internalList.get(i), i);
            }
            this.listener.itemRemoved(object);
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        try {
            throw new UnsupportedOperationException("operation not yet supported!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.internalList.retainAll(collection);
    }

    @Override
    public T set(int location, T object) {
        return this.internalList.set(location, object);
    }

    @Override
    public int size() {
        return this.internalList.size();
    }

    @Override
    @NonNull
    public List<T> subList(int start, int end) {
        return this.subList(start, end);
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return this.internalList.toArray();
    }

    @Override
    @NonNull
    public <T1> T1[] toArray(T1[] array) {
        return this.internalList.toArray(array);
    }

    public static interface ListEventListener {
        public void itemAdded(Object var1, int var2);

        public void itemRemoved(Object var1);

        public void itemPositionChanged(Object var1, int var2);
    }
}

