/*
 * Decompiled with CFR 0.152.
 */
package com.daprlabs.aaron.swipedeck;

import android.view.View;
import com.daprlabs.aaron.swipedeck.SwipeDeck;
import com.daprlabs.aaron.swipedeck.Utility.RxBus;
import com.daprlabs.aaron.swipedeck.Utility.SwipeCallback;
import com.daprlabs.aaron.swipedeck.Utility.SwipeListener;

public class CardContainer {
    private View view;
    private RxBus bus;
    int positionWithinViewGroup = -1;
    private SwipeListener swipeListener;
    private SwipeCallback callback;
    private SwipeDeck parent;
    private long id;

    public CardContainer(View view, SwipeDeck parent, SwipeCallback callback) {
        this.view = view;
        this.parent = parent;
        this.callback = callback;
        this.setupSwipeListener();
    }

    public void setPositionWithinViewGroup(int pos) {
        this.positionWithinViewGroup = pos;
    }

    public int getPositionWithinViewGroup() {
        return this.positionWithinViewGroup;
    }

    public View getCard() {
        return this.view;
    }

    public void cleanupAndRemoveView() {
        this.view.postDelayed(new Runnable(){

            @Override
            public void run() {
                CardContainer.this.deleteViewFromSwipeDeck();
            }
        }, (long)SwipeDeck.ANIMATION_DURATION);
    }

    private void deleteViewFromSwipeDeck() {
        this.parent.removeView(this.view);
        this.parent.clearBuffer();
    }

    public void setSwipeEnabled(boolean enabled) {
        if (enabled) {
            this.view.setOnTouchListener((View.OnTouchListener)this.swipeListener);
        } else {
            this.view.setOnTouchListener(null);
        }
    }

    public SwipeListener getSwipeListener() {
        return this.swipeListener;
    }

    public void setLeftImageResource(int leftImageResource) {
        View left = this.view.findViewById(leftImageResource);
        left.setAlpha(0.0f);
        this.swipeListener.setLeftView(left);
    }

    public void setRightImageResource(int rightImageResource) {
        View right = this.view.findViewById(rightImageResource);
        right.setAlpha(0.0f);
        this.swipeListener.setRightView(right);
    }

    public void setupSwipeListener() {
        if (this.parent.SWIPE_ENABLED) {
            this.swipeListener = new SwipeListener(this.view, this.callback, this.parent.getPaddingLeft(), this.parent.getPaddingTop(), this.parent.ROTATION_DEGREES, this.parent.OPACITY_END, this.parent);
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }
}

