/*
 * Decompiled with CFR 0.152.
 */
package com.danjdt.pdfviewer.view.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.Size;
import android.view.View;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.RecyclerView;
import com.danjdt.pdfviewer.interfaces.PdfRendererInterface;
import com.danjdt.pdfviewer.interfaces.ViewHolderInterface;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u0018\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\rR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/danjdt/pdfviewer/view/adapter/PdfPageViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lcom/danjdt/pdfviewer/interfaces/ViewHolderInterface;", "view", "Landroid/view/View;", "pdfRenderer", "Lcom/danjdt/pdfviewer/interfaces/PdfRendererInterface;", "pageSize", "Landroid/util/Size;", "(Landroid/view/View;Lcom/danjdt/pdfviewer/interfaces/PdfRendererInterface;Landroid/util/Size;)V", "activity", "Landroid/app/Activity;", "mPagePosition", "", "getMPagePosition", "()I", "setMPagePosition", "(I)V", "getPageSize", "()Landroid/util/Size;", "getPdfRenderer", "()Lcom/danjdt/pdfviewer/interfaces/PdfRendererInterface;", "bind", "", "position", "onRender", "bitmap", "Landroid/graphics/Bitmap;", "shouldRender", "", "index", "pdfviewer_release"})
@RequiresApi(value=21)
public abstract class PdfPageViewHolder
extends RecyclerView.ViewHolder
implements ViewHolderInterface {
    private int mPagePosition;
    private final Activity activity;
    @NotNull
    private final PdfRendererInterface pdfRenderer;
    @Nullable
    private final Size pageSize;

    public final int getMPagePosition() {
        return this.mPagePosition;
    }

    public final void setMPagePosition(int n) {
        this.mPagePosition = n;
    }

    @Override
    public final boolean shouldRender(int index) {
        return this.mPagePosition == index;
    }

    @Override
    public final void onRender(@Nullable Bitmap bitmap, int position) {
        if (this.mPagePosition == position && bitmap != null) {
            this.pdfRenderer.put(position, bitmap);
            this.activity.runOnUiThread(new Runnable(this, bitmap, position){
                final /* synthetic */ PdfPageViewHolder this$0;
                final /* synthetic */ Bitmap $bitmap;
                final /* synthetic */ int $position;

                public final void run() {
                    this.this$0.displayPage(this.$bitmap, this.$position);
                }
                {
                    this.this$0 = pdfPageViewHolder;
                    this.$bitmap = bitmap;
                    this.$position = n;
                }
            });
        }
    }

    @Override
    public final void bind(int position) {
        this.mPagePosition = position;
        this.displayPlaceHolder();
        this.getPage(this.mPagePosition);
        this.resizePage();
    }

    @NotNull
    public final PdfRendererInterface getPdfRenderer() {
        return this.pdfRenderer;
    }

    @Nullable
    public final Size getPageSize() {
        return this.pageSize;
    }

    public PdfPageViewHolder(@NotNull View view, @NotNull PdfRendererInterface pdfRenderer, @Nullable Size pageSize) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)pdfRenderer, (String)"pdfRenderer");
        super(view);
        this.pdfRenderer = pdfRenderer;
        this.pageSize = pageSize;
        this.mPagePosition = -1;
        Context context = view.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
        }
        this.activity = (Activity)context;
    }
}

