/*
 * Decompiled with CFR 0.152.
 */
package com.danjdt.pdfviewer.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.danjdt.pdfviewer.interfaces.OnPageChangedListener;
import com.danjdt.pdfviewer.interfaces.PdfViewInterface;
import com.danjdt.pdfviewer.renderer.PdfRendererProxy;
import com.danjdt.pdfviewer.utils.Utils;
import com.danjdt.pdfviewer.view.ExtraSpaceLinearLayoutManager;
import com.danjdt.pdfviewer.view.adapter.DefaultPdfPageAdapter;
import com.danjdt.pdfviewer.view.adapter.PdfPageAdapter;
import java.io.File;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u00012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010H\u0014J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010H\u0016J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010&\u001a\u00020\u0007H\u0016J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\tH\u0016J\u0012\u0010)\u001a\u00020\u00182\b\u0010*\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0010H\u0016J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u0007H\u0016J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/danjdt/pdfviewer/view/PdfViewerRecyclerView;", "Landroidx/recyclerview/widget/RecyclerView;", "Lcom/danjdt/pdfviewer/interfaces/PdfViewInterface;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mIsZoomEnabled", "", "mLastTouchX", "", "mMaxWidth", "mMaxZoom", "mMinZoom", "mOnPageChangedListener", "Lcom/danjdt/pdfviewer/interfaces/OnPageChangedListener;", "mPosition", "", "mQuality", "mScaleFactor", "mScaleGestureDetector", "Landroid/view/ScaleGestureDetector;", "mTouchX", "mWidth", "dispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "onDraw", "onInterceptTouchEvent", "ev", "Landroid/view/MotionEvent;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onScrolled", "dx", "dy", "onTouchEvent", "performClick", "setMaxZoom", "maxZoom", "setOnPageChangedListener", "onPageChangedListener", "setQuality", "quality", "setZoomEnabled", "isZoomEnabled", "setup", "file", "Ljava/io/File;", "ScaleListener", "pdfviewer_release"})
@RequiresApi(value=21)
public final class PdfViewerRecyclerView
extends RecyclerView
implements PdfViewInterface {
    private ScaleGestureDetector mScaleGestureDetector;
    private float mScaleFactor;
    private float mMaxWidth;
    private float mLastTouchX;
    private float mTouchX;
    private float mWidth;
    private boolean mIsZoomEnabled;
    private float mMaxZoom;
    private float mMinZoom;
    private int mQuality;
    private OnPageChangedListener mOnPageChangedListener;
    private int mPosition;
    private HashMap _$_findViewCache;

    @Override
    public void setup(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.danjdt.pdfviewer.view.adapter.PdfPageAdapter<*>");
        }
        PdfPageAdapter adapter2 = (PdfPageAdapter)adapter;
        Context context = this.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
        }
        adapter2.setup(new PdfRendererProxy(file, this.mQuality), Utils.Companion.getScreenWidth((Activity)context));
        adapter2.notifyDataSetChanged();
    }

    @Override
    public void setQuality(int quality) {
        this.mQuality = quality;
    }

    @Override
    public void setZoomEnabled(boolean isZoomEnabled) {
        this.mIsZoomEnabled = isZoomEnabled;
    }

    @Override
    public void setMaxZoom(float maxZoom) {
        this.mMaxZoom = maxZoom;
    }

    @Override
    public void setOnPageChangedListener(@Nullable OnPageChangedListener onPageChangedListener) {
        this.mOnPageChangedListener = onPageChangedListener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkParameterIsNotNull((Object)ev, (String)"ev");
        try {
            return super.onInterceptTouchEvent(ev);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean performClick() {
        super.performClick();
        return true;
    }

    public boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkParameterIsNotNull((Object)ev, (String)"ev");
        super.onTouchEvent(ev);
        this.performClick();
        int action = ev.getAction();
        this.mScaleGestureDetector.onTouchEvent(ev);
        switch (action & 0xFF) {
            case 0: {
                float x;
                this.mLastTouchX = x = ev.getX();
                break;
            }
            case 2: {
                int pointerIndex = (action & 0xFF00) >> 8;
                float x = ev.getX(pointerIndex);
                float dx = x - this.mLastTouchX;
                this.mTouchX += dx;
                if (this.mTouchX > 0.0f) {
                    this.mTouchX = 0.0f;
                } else if (this.mTouchX < this.mMaxWidth) {
                    this.mTouchX = this.mMaxWidth;
                }
                this.mLastTouchX = x;
                this.invalidate();
                break;
            }
            case 6: {
                int pointerIndex = (action & 0xFF00) >> 8;
                int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                this.mLastTouchX = ev.getX(newPointerIndex);
            }
        }
        return true;
    }

    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.save();
        canvas.translate(this.mTouchX, 0.0f);
        canvas.scale(this.mScaleFactor, this.mScaleFactor);
        canvas.restore();
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        if (this.mScaleFactor == this.mMinZoom) {
            this.mTouchX = 0.0f;
        }
        canvas.translate(this.mTouchX, 0.0f);
        canvas.scale(this.mScaleFactor, this.mScaleFactor);
        super.dispatchDraw(canvas);
        canvas.restore();
        this.invalidate();
    }

    public void onScrolled(int dx, int dy) {
        block2: {
            super.onScrolled(dx, dy);
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            if (layoutManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
            }
            int position = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            if (position == this.mPosition || position == -1) break block2;
            this.mPosition = position;
            OnPageChangedListener onPageChangedListener = this.mOnPageChangedListener;
            if (onPageChangedListener != null) {
                RecyclerView.Adapter adapter = this.getAdapter();
                onPageChangedListener.onPageChanged(this.mPosition + 1, adapter != null ? adapter.getItemCount() : 0);
            }
        }
    }

    public PdfViewerRecyclerView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, null);
        this.mScaleFactor = 1.0f;
        this.mIsZoomEnabled = true;
        this.mMaxZoom = 3.0f;
        this.mMinZoom = 1.0f;
        this.mPosition = -1;
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.setAdapter(new DefaultPdfPageAdapter(context));
        this.setLayoutManager((RecyclerView.LayoutManager)new ExtraSpaceLinearLayoutManager(context));
    }

    public static final /* synthetic */ void access$setMIsZoomEnabled$p(PdfViewerRecyclerView $this, boolean bl) {
        $this.mIsZoomEnabled = bl;
    }

    public static final /* synthetic */ void access$setMMinZoom$p(PdfViewerRecyclerView $this, float f) {
        $this.mMinZoom = f;
    }

    public static final /* synthetic */ void access$setMMaxZoom$p(PdfViewerRecyclerView $this, float f) {
        $this.mMaxZoom = f;
    }

    public static final /* synthetic */ float access$getMMaxWidth$p(PdfViewerRecyclerView $this) {
        return $this.mMaxWidth;
    }

    public static final /* synthetic */ void access$setMWidth$p(PdfViewerRecyclerView $this, float f) {
        $this.mWidth = f;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/danjdt/pdfviewer/view/PdfViewerRecyclerView$ScaleListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "(Lcom/danjdt/pdfviewer/view/PdfViewerRecyclerView;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "pdfviewer_release"})
    private final class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
            if (PdfViewerRecyclerView.this.mIsZoomEnabled) {
                PdfViewerRecyclerView pdfViewerRecyclerView = PdfViewerRecyclerView.this;
                pdfViewerRecyclerView.mScaleFactor = pdfViewerRecyclerView.mScaleFactor * detector.getScaleFactor();
                PdfViewerRecyclerView.this.mScaleFactor = Math.max(PdfViewerRecyclerView.this.mMinZoom, Math.min(PdfViewerRecyclerView.this.mScaleFactor, PdfViewerRecyclerView.this.mMaxZoom));
                PdfViewerRecyclerView.this.mMaxWidth = PdfViewerRecyclerView.this.mWidth - PdfViewerRecyclerView.this.mWidth * PdfViewerRecyclerView.this.mScaleFactor;
                PdfViewerRecyclerView.this.invalidate();
            }
            return true;
        }
    }
}

