/*
 * Decompiled with CFR 0.152.
 */
package com.danjdt.pdfviewer.renderer;

import android.graphics.Bitmap;
import android.graphics.pdf.PdfRenderer;
import android.os.ParcelFileDescriptor;
import android.util.Size;
import androidx.annotation.RequiresApi;
import com.danjdt.pdfviewer.interfaces.PdfRendererInterface;
import com.danjdt.pdfviewer.interfaces.PdfRendererListener;
import com.danjdt.pdfviewer.renderer.PageRendererAsyncTask;
import com.danjdt.pdfviewer.renderer.PdfPagePool;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/danjdt/pdfviewer/renderer/PdfRendererProxy;", "Lcom/danjdt/pdfviewer/interfaces/PdfRendererInterface;", "file", "Ljava/io/File;", "quality", "", "(Ljava/io/File;I)V", "mPdfRenderer", "Landroid/graphics/pdf/PdfRenderer;", "mPool", "Lcom/danjdt/pdfviewer/renderer/PdfPagePool;", "mSize", "Landroid/util/Size;", "get", "", "listener", "Lcom/danjdt/pdfviewer/interfaces/PdfRendererListener;", "position", "getPageCount", "getPageSize", "width", "openRenderer", "put", "bitmap", "Landroid/graphics/Bitmap;", "pdfviewer_release"})
@RequiresApi(value=21)
public final class PdfRendererProxy
implements PdfRendererInterface {
    private final PdfPagePool mPool;
    private Size mSize;
    private PdfRenderer mPdfRenderer;

    @Override
    public void put(int position, @NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        this.mPool.put(position, bitmap);
    }

    @Override
    public void get(@NotNull PdfRendererListener listener, int position) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        if (this.mPool.exists(position)) {
            listener.onRender(this.mPool.get(position), position);
        } else {
            PageRendererAsyncTask pageRendererAsyncTask;
            PdfRenderer pdfRenderer = this.mPdfRenderer;
            if (pdfRenderer != null) {
                PdfRenderer pdfRenderer2;
                PdfRenderer pdfRenderer3 = pdfRenderer2 = pdfRenderer;
                pageRendererAsyncTask = new PageRendererAsyncTask(listener, pdfRenderer3, position, this.mSize);
            } else {
                pageRendererAsyncTask = null;
            }
        }
    }

    @Override
    public int getPageCount() {
        PdfRenderer pdfRenderer = this.mPdfRenderer;
        return pdfRenderer != null ? pdfRenderer.getPageCount() : 0;
    }

    @Override
    @NotNull
    public Size getPageSize(int width) {
        int height;
        block0: {
            PdfRenderer.Page page;
            PdfRenderer pdfRenderer = this.mPdfRenderer;
            PdfRenderer.Page page2 = pdfRenderer != null ? pdfRenderer.openPage(0) : null;
            height = 0;
            PdfRenderer.Page page3 = page2;
            if (page3 == null) break block0;
            PdfRenderer.Page it = page = page3;
            height = page2.getHeight() * width / page2.getWidth();
            page2.close();
        }
        return new Size(width, height);
    }

    private final void openRenderer(File file) throws IOException {
        ParcelFileDescriptor fileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        this.mPdfRenderer = new PdfRenderer(fileDescriptor);
    }

    public PdfRendererProxy(@NotNull File file, int quality) {
        block0: {
            PdfRenderer pdfRenderer;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.mPool = new PdfPagePool();
            this.mSize = new Size(0, 0);
            this.openRenderer(file);
            PdfRenderer pdfRenderer2 = this.mPdfRenderer;
            if (pdfRenderer2 == null) break block0;
            PdfRenderer it = pdfRenderer = pdfRenderer2;
            this.mSize = this.getPageSize(quality);
        }
    }
}

