/*
 * Decompiled with CFR 0.152.
 */
package com.danjdt.pdfviewer.renderer;

import android.graphics.Bitmap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0007J\b\u0010\u0012\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/danjdt/pdfviewer/renderer/PdfPagePool;", "", "()V", "mMaxPoolSizeInBytes", "", "mPool", "Ljava/util/HashMap;", "Landroid/graphics/Bitmap;", "mPoolSizeInBytes", "mRemoveQueue", "Ljava/util/Queue;", "exists", "", "position", "get", "put", "", "bitmap", "removeLast", "pdfviewer_release"})
public final class PdfPagePool {
    private final int mMaxPoolSizeInBytes = 0x6400000;
    private int mPoolSizeInBytes;
    private final HashMap<Integer, Bitmap> mPool = new HashMap();
    private final Queue<Integer> mRemoveQueue = new LinkedList();

    public final void put(int position, @NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        if (this.mPool.get(position) == null) {
            while (this.mPoolSizeInBytes > this.mMaxPoolSizeInBytes) {
                this.removeLast();
            }
            this.mRemoveQueue.offer(position);
            Map map = this.mPool;
            Integer n = position;
            Bitmap bitmap2 = bitmap;
            map.put(n, bitmap2);
            this.mPoolSizeInBytes += bitmap.getByteCount();
        }
    }

    @Nullable
    public final Bitmap get(int position) {
        return this.mPool.get(position);
    }

    public final boolean exists(int position) {
        return this.mPool.get(position) != null;
    }

    private final void removeLast() {
        Integer removePos = this.mRemoveQueue.poll();
        Bitmap bitmap = this.mPool.get(removePos);
        if (bitmap == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"mPool[removePos]!!");
        this.mPoolSizeInBytes -= bitmap.getByteCount();
        this.mPool.remove(removePos);
    }
}

