/*
 * Decompiled with CFR 0.152.
 */
package com.danjdt.pdfviewer.renderer;

import android.graphics.Bitmap;
import android.graphics.pdf.PdfRenderer;
import android.os.AsyncTask;
import android.util.Size;
import androidx.annotation.RequiresApi;
import com.danjdt.pdfviewer.interfaces.PdfRendererListener;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ#\u0010\r\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000f\"\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0014J\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/danjdt/pdfviewer/renderer/PageRendererAsyncTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "Landroid/graphics/Bitmap;", "listener", "Lcom/danjdt/pdfviewer/interfaces/PdfRendererListener;", "pdfRenderer", "Landroid/graphics/pdf/PdfRenderer;", "position", "", "size", "Landroid/util/Size;", "(Lcom/danjdt/pdfviewer/interfaces/PdfRendererListener;Landroid/graphics/pdf/PdfRenderer;ILandroid/util/Size;)V", "doInBackground", "v", "", "([Ljava/lang/Void;)Landroid/graphics/Bitmap;", "onPostExecute", "", "result", "renderPDFPage", "index", "pdfviewer_release"})
@RequiresApi(value=21)
public final class PageRendererAsyncTask
extends AsyncTask<Void, Void, Bitmap> {
    private final PdfRendererListener listener;
    private final PdfRenderer pdfRenderer;
    private final int position;
    private final Size size;

    private final Bitmap renderPDFPage(PdfRenderer pdfRenderer, int index) throws IOException {
        PdfRenderer.Page page = pdfRenderer.openPage(index);
        Bitmap bitmap = Bitmap.createBitmap((int)this.size.getWidth(), (int)this.size.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        page.render(bitmap, null, null, 1);
        page.close();
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    @Nullable
    protected Bitmap doInBackground(Void ... v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        Thread.sleep(32L);
        if (this.listener.shouldRender(this.position)) {
            return this.renderPDFPage(this.pdfRenderer, this.position);
        }
        this.cancel(true);
        return null;
    }

    protected void onPostExecute(@Nullable Bitmap result) {
        super.onPostExecute((Object)result);
        this.listener.onRender(result, this.position);
    }

    public PageRendererAsyncTask(@NotNull PdfRendererListener listener, @NotNull PdfRenderer pdfRenderer, int position, @NotNull Size size) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)pdfRenderer, (String)"pdfRenderer");
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        this.listener = listener;
        this.pdfRenderer = pdfRenderer;
        this.position = position;
        this.size = size;
        this.execute(new Void[0]);
    }
}

