/*
 * Decompiled with CFR 0.152.
 */
package com.danjdt.pdfviewer.decoder;

import android.content.Context;
import androidx.annotation.RawRes;
import com.danjdt.pdfviewer.decoder.LoadFileFromInputStreamAsyncTask;
import com.danjdt.pdfviewer.decoder.LoadFileFromResAsyncTask;
import com.danjdt.pdfviewer.decoder.LoadFileFromUrlAsyncTask;
import com.danjdt.pdfviewer.interfaces.OnLoadFileListener;
import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/danjdt/pdfviewer/decoder/FileLoader;", "", "()V", "Companion", "pdfviewer_release"})
public final class FileLoader {
    private static final String FILE_NAME = "pdfView.pdf";
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/danjdt/pdfviewer/decoder/FileLoader$Companion;", "", "()V", "FILE_NAME", "", "getTempFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "loadFile", "", "listener", "Lcom/danjdt/pdfviewer/interfaces/OnLoadFileListener;", "input", "Ljava/io/InputStream;", "resId", "", "url", "pdfviewer_release"})
    public static final class Companion {
        private final File getTempFile(Context context) {
            return new File(context.getCacheDir(), FileLoader.FILE_NAME);
        }

        public final void loadFile(@NotNull Context context, @NotNull OnLoadFileListener listener, @RawRes int resId) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            InputStream input = context.getResources().openRawResource(context.getResources().getIdentifier(context.getResources().getResourceName(resId), context.getResources().getResourceTypeName(resId), context.getResources().getResourcePackageName(resId)));
            File file = this.getTempFile(context);
            InputStream inputStream = input;
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"input");
            new LoadFileFromResAsyncTask(file, listener, inputStream).execute(new Void[0]);
        }

        public final void loadFile(@NotNull Context context, @NotNull OnLoadFileListener listener, @NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            new LoadFileFromUrlAsyncTask(this.getTempFile(context), listener, url).execute(new Void[0]);
        }

        public final void loadFile(@NotNull Context context, @NotNull OnLoadFileListener listener, @NotNull InputStream input) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            new LoadFileFromInputStreamAsyncTask(this.getTempFile(context), listener, input).execute(new Void[0]);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

