/*
 * Decompiled with CFR 0.152.
 */
package com.danjdt.pdfviewer;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.MainThread;
import androidx.annotation.RawRes;
import androidx.annotation.RequiresApi;
import com.danjdt.pdfviewer.decoder.FileLoader;
import com.danjdt.pdfviewer.interfaces.OnErrorListener;
import com.danjdt.pdfviewer.interfaces.OnLoadFileListener;
import com.danjdt.pdfviewer.interfaces.OnPageChangedListener;
import com.danjdt.pdfviewer.interfaces.PdfViewInterface;
import com.danjdt.pdfviewer.utils.PdfPageQuality;
import com.danjdt.pdfviewer.view.PdfViewerRecyclerView;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0010\u001a\u00020\r2\b\b\u0001\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/danjdt/pdfviewer/PdfViewer;", "Lcom/danjdt/pdfviewer/interfaces/OnLoadFileListener;", "mRootView", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "mContext", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "mOnErrorListener", "Lcom/danjdt/pdfviewer/interfaces/OnErrorListener;", "mView", "Lcom/danjdt/pdfviewer/interfaces/PdfViewInterface;", "display", "", "file", "Ljava/io/File;", "load", "input", "Ljava/io/InputStream;", "resId", "", "url", "", "onFileLoadError", "e", "Ljava/lang/Exception;", "onFileLoaded", "Builder", "pdfviewer_release"})
@RequiresApi(value=21)
public final class PdfViewer
implements OnLoadFileListener {
    private Context mContext;
    private PdfViewInterface mView;
    private OnErrorListener mOnErrorListener;
    private final ViewGroup mRootView;

    @MainThread
    private final void display(File file) {
        block6: {
            try {
                PdfViewInterface pdfViewInterface = this.mView;
                if (pdfViewInterface == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mView");
                }
                if (pdfViewInterface == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.view.View");
                }
                this.mRootView.addView((View)pdfViewInterface);
                PdfViewInterface pdfViewInterface2 = this.mView;
                if (pdfViewInterface2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mView");
                }
                pdfViewInterface2.setup(file);
            }
            catch (IOException e) {
                OnErrorListener onErrorListener = this.mOnErrorListener;
                if (onErrorListener == null) break block6;
                onErrorListener.onPdfRendererError(e);
            }
            catch (Exception e) {
                OnErrorListener onErrorListener = this.mOnErrorListener;
                if (onErrorListener == null) break block6;
                onErrorListener.onAttachViewError(e);
            }
        }
    }

    public final void load(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.display(file);
    }

    public final void load(@RawRes int resId) {
        Context context = this.mContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContext");
        FileLoader.Companion.loadFile(context, (OnLoadFileListener)this, resId);
    }

    public final void load(@NotNull InputStream input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Context context = this.mContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContext");
        FileLoader.Companion.loadFile(context, (OnLoadFileListener)this, input);
    }

    public final void load(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Context context = this.mContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContext");
        FileLoader.Companion.loadFile(context, (OnLoadFileListener)this, url);
    }

    @Override
    public void onFileLoaded(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Context context = this.mContext;
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
        }
        ((Activity)context).runOnUiThread(new Runnable(this, file){
            final /* synthetic */ PdfViewer this$0;
            final /* synthetic */ File $file;

            public final void run() {
                PdfViewer.access$display(this.this$0, this.$file);
            }
            {
                this.this$0 = pdfViewer;
                this.$file = file;
            }
        });
    }

    @Override
    public void onFileLoadError(@NotNull Exception e) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            OnErrorListener onErrorListener = this.mOnErrorListener;
            if (onErrorListener == null) break block0;
            onErrorListener.onFileLoadError(e);
        }
    }

    private PdfViewer(ViewGroup mRootView) {
        this.mRootView = mRootView;
        this.mContext = this.mRootView.getContext();
    }

    public /* synthetic */ PdfViewer(@NotNull ViewGroup mRootView, DefaultConstructorMarker $constructor_marker) {
        this(mRootView);
    }

    @Nullable
    public static final /* synthetic */ OnErrorListener access$getMOnErrorListener$p(PdfViewer $this) {
        return $this.mOnErrorListener;
    }

    @NotNull
    public static final /* synthetic */ PdfViewInterface access$getMView$p(PdfViewer $this) {
        PdfViewInterface pdfViewInterface = $this.mView;
        if (pdfViewInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mView");
        }
        return pdfViewInterface;
    }

    public static final /* synthetic */ void access$display(PdfViewer $this, @NotNull File file) {
        $this.display(file);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/danjdt/pdfviewer/PdfViewer$Builder;", "", "rootView", "Landroid/view/View;", "(Landroid/view/View;)V", "context", "Landroid/content/Context;", "isZoomEnabled", "", "maxZoom", "", "onErrorListener", "Lcom/danjdt/pdfviewer/interfaces/OnErrorListener;", "onPageChangedListener", "Lcom/danjdt/pdfviewer/interfaces/OnPageChangedListener;", "pdfView", "Lcom/danjdt/pdfviewer/interfaces/PdfViewInterface;", "quality", "Lcom/danjdt/pdfviewer/utils/PdfPageQuality;", "build", "Lcom/danjdt/pdfviewer/PdfViewer;", "setMaxZoom", "setOnErrorListener", "setOnPageChangedListener", "setZoomEnabled", "isEnabled", "view", "pdfviewer_release"})
    public static final class Builder {
        private Context context;
        private PdfViewInterface pdfView;
        private PdfPageQuality quality;
        private float maxZoom;
        private boolean isZoomEnabled;
        private OnPageChangedListener onPageChangedListener;
        private OnErrorListener onErrorListener;
        private final View rootView;

        @NotNull
        public final Builder view(@NotNull PdfViewInterface pdfView) {
            Intrinsics.checkParameterIsNotNull((Object)pdfView, (String)"pdfView");
            this.pdfView = pdfView;
            return this;
        }

        @NotNull
        public final Builder setZoomEnabled(boolean isEnabled) {
            this.isZoomEnabled = isEnabled;
            return this;
        }

        @NotNull
        public final Builder setMaxZoom(float maxZoom) {
            this.maxZoom = maxZoom;
            return this;
        }

        @NotNull
        public final Builder setOnPageChangedListener(@NotNull OnPageChangedListener onPageChangedListener) {
            Intrinsics.checkParameterIsNotNull((Object)onPageChangedListener, (String)"onPageChangedListener");
            this.onPageChangedListener = onPageChangedListener;
            return this;
        }

        @NotNull
        public final Builder quality(@NotNull PdfPageQuality quality) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)quality), (String)"quality");
            this.quality = quality;
            return this;
        }

        @NotNull
        public final Builder setOnErrorListener(@NotNull OnErrorListener onErrorListener) {
            Intrinsics.checkParameterIsNotNull((Object)onErrorListener, (String)"onErrorListener");
            this.onErrorListener = onErrorListener;
            return this;
        }

        @NotNull
        public final PdfViewer build() {
            View view = this.rootView;
            if (view == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
            }
            PdfViewer pdfViewer = new PdfViewer((ViewGroup)view, null);
            this.pdfView.setQuality(this.quality.getValue());
            this.pdfView.setZoomEnabled(this.isZoomEnabled);
            this.pdfView.setMaxZoom(this.maxZoom);
            this.pdfView.setOnPageChangedListener(this.onPageChangedListener);
            pdfViewer.mOnErrorListener = this.onErrorListener;
            pdfViewer.mView = this.pdfView;
            return pdfViewer;
        }

        public Builder(@NotNull View rootView) {
            Intrinsics.checkParameterIsNotNull((Object)rootView, (String)"rootView");
            this.rootView = rootView;
            Context context = this.rootView.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"rootView.context");
            this.context = context;
            this.pdfView = new PdfViewerRecyclerView(this.context);
            this.quality = PdfPageQuality.QUALITY_1080;
            this.maxZoom = 3.0f;
            this.isZoomEnabled = true;
        }
    }
}

