/*
 * Decompiled with CFR 0.152.
 */
package com.danikula.videocache;

import android.text.TextUtils;
import com.danikula.videocache.CacheListener;
import com.danikula.videocache.GetRequest;
import com.danikula.videocache.HttpUrlSource;
import com.danikula.videocache.ProxyCache;
import com.danikula.videocache.ProxyCacheException;
import com.danikula.videocache.file.FileCache;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

class HttpProxyCache
extends ProxyCache {
    private static final float NO_CACHE_BARRIER = 0.2f;
    private final HttpUrlSource source;
    private final FileCache cache;
    private CacheListener listener;

    public HttpProxyCache(HttpUrlSource source, FileCache cache) {
        super(source, cache);
        this.cache = cache;
        this.source = source;
    }

    public void registerCacheListener(CacheListener cacheListener) {
        this.listener = cacheListener;
    }

    public void processRequest(GetRequest request, Socket socket) throws IOException, ProxyCacheException {
        BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
        String responseHeaders = this.newResponseHeaders(request);
        ((OutputStream)out).write(responseHeaders.getBytes("UTF-8"));
        long offset = request.rangeOffset;
        if (this.isUseCache(request)) {
            this.responseWithCache(out, offset);
        } else {
            this.responseWithoutCache(out, offset);
        }
    }

    private boolean isUseCache(GetRequest request) throws ProxyCacheException {
        int sourceLength = this.source.length();
        boolean sourceLengthKnown = sourceLength > 0;
        int cacheAvailable = this.cache.available();
        return !sourceLengthKnown || !request.partial || (float)request.rangeOffset <= (float)cacheAvailable + (float)sourceLength * 0.2f;
    }

    private String newResponseHeaders(GetRequest request) throws IOException, ProxyCacheException {
        String mime = this.source.getMime();
        boolean mimeKnown = !TextUtils.isEmpty((CharSequence)mime);
        int length = this.cache.isCompleted() ? this.cache.available() : this.source.length();
        boolean lengthKnown = length >= 0;
        long contentLength = request.partial ? (long)length - request.rangeOffset : (long)length;
        boolean addRange = lengthKnown && request.partial;
        return (request.partial ? "HTTP/1.1 206 PARTIAL CONTENT\n" : "HTTP/1.1 200 OK\n") + "Accept-Ranges: bytes\n" + (lengthKnown ? String.format("Content-Length: %d\n", contentLength) : "") + (addRange ? String.format("Content-Range: bytes %d-%d/%d\n", request.rangeOffset, length - 1, length) : "") + (mimeKnown ? String.format("Content-Type: %s\n", mime) : "") + "\n";
    }

    private void responseWithCache(OutputStream out, long offset) throws ProxyCacheException, IOException {
        int readBytes;
        byte[] buffer = new byte[8192];
        while ((readBytes = this.read(buffer, offset, buffer.length)) != -1) {
            out.write(buffer, 0, readBytes);
            offset += (long)readBytes;
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void responseWithoutCache(OutputStream out, long offset) throws ProxyCacheException, IOException {
        try (HttpUrlSource newSourceNoCache = new HttpUrlSource(this.source);){
            int readBytes;
            newSourceNoCache.open((int)offset);
            byte[] buffer = new byte[8192];
            while ((readBytes = newSourceNoCache.read(buffer)) != -1) {
                out.write(buffer, 0, readBytes);
                offset += (long)readBytes;
            }
            out.flush();
        }
    }

    @Override
    protected void onCachePercentsAvailableChanged(int percents) {
        if (this.listener != null) {
            this.listener.onCacheAvailable(this.cache.file, this.source.getUrl(), percents);
        }
    }
}

