/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser.visitor.or.node;

import com.dangdang.ddframe.rdb.sharding.parser.result.router.Condition;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.ConditionContext;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractOrASTNode {
    private final List<AbstractOrASTNode> subNodes = new ArrayList<AbstractOrASTNode>();
    private final List<List<Condition>> nestedConditions = new ArrayList<List<Condition>>();

    public final void addSubNode(AbstractOrASTNode node) {
        this.subNodes.add(node);
    }

    protected final void addNestedConditions(ConditionContext conditionContext) {
        this.nestedConditions.add(Lists.newArrayList(conditionContext.getAllConditions()));
    }

    public abstract void createOrASTAsRootNode();

    public final List<ConditionContext> getCondition() {
        return Lists.transform(this.nestedConditions, (Function)new Function<List<Condition>, ConditionContext>(){

            public ConditionContext apply(List<Condition> input) {
                ConditionContext result = new ConditionContext();
                for (Condition each : input) {
                    result.add(each);
                }
                return result;
            }
        });
    }

    protected final void mergeSubConditions() {
        if (this.subNodes.isEmpty()) {
            return;
        }
        List<List<Condition>> result = new ArrayList<List<Condition>>();
        result.addAll(this.subNodes.get(0).getNestedConditions());
        for (int i = 1; i < this.subNodes.size(); ++i) {
            result = this.cartesianNestedConditions(result, this.subNodes.get(i).getNestedConditions());
        }
        this.nestedConditions.addAll(result);
    }

    private List<List<Condition>> cartesianNestedConditions(List<List<Condition>> oneNestedConditions, List<List<Condition>> anotherNestedConditions) {
        ArrayList<List<Condition>> result = new ArrayList<List<Condition>>();
        for (List<Condition> oneNestedCondition : oneNestedConditions) {
            for (List<Condition> anotherNestedCondition : anotherNestedConditions) {
                ArrayList<Condition> mergedConditions = new ArrayList<Condition>();
                mergedConditions.addAll(oneNestedCondition);
                mergedConditions.addAll(anotherNestedCondition);
                result.add(mergedConditions);
            }
        }
        return result;
    }

    protected List<AbstractOrASTNode> getSubNodes() {
        return this.subNodes;
    }

    protected List<List<Condition>> getNestedConditions() {
        return this.nestedConditions;
    }
}

