/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser.visitor;

import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import com.dangdang.ddframe.rdb.sharding.parser.visitor.basic.mysql.AbstractMySQLVisitor;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VisitorLogProxy {
    private static final Logger log = LoggerFactory.getLogger(VisitorLogProxy.class);

    public static <T> T enhance(Class<T> target) {
        if (log.isTraceEnabled()) {
            Enhancer result = new Enhancer();
            result.setSuperclass(target);
            result.setCallback((Callback)new VisitorHandler());
            return (T)result.create();
        }
        try {
            return target.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            log.error("create Visitor exception: {}", (Throwable)ex);
            throw new ShardingJdbcException(ex);
        }
    }

    private VisitorLogProxy() {
    }

    private static class VisitorHandler
    implements MethodInterceptor {
        private final StringBuilder hierarchyIndex = new StringBuilder();
        private Integer depth = 0;

        private VisitorHandler() {
        }

        public Object intercept(Object enhancedObject, Method method, Object[] arguments, MethodProxy methodProxy) throws Throwable {
            if (this.isPrintable(method)) {
                this.hierarchyIn();
                log.trace("{}visit node: {}", (Object)this.hierarchyIndex, arguments[0].getClass());
                log.trace("{}visit argument: {}", (Object)this.hierarchyIndex, arguments[0]);
            }
            Object result = methodProxy.invokeSuper(enhancedObject, arguments);
            if (this.isPrintable(method)) {
                AbstractMySQLVisitor visitor = (AbstractMySQLVisitor)enhancedObject;
                log.trace("{}endVisit node: {}", (Object)this.hierarchyIndex, arguments[0].getClass());
                log.trace("{}endVisit result: {}", (Object)this.hierarchyIndex, (Object)visitor.getParseContext().getParsedResult());
                log.trace("{}endVisit condition: {}", (Object)this.hierarchyIndex, (Object)visitor.getParseContext().getCurrentConditionContext());
                log.trace("{}endVisit SQL: {}", (Object)this.hierarchyIndex, (Object)visitor.getSQLBuilder());
                this.hierarchyOut();
            }
            return result;
        }

        private boolean isPrintable(Method method) {
            return log.isTraceEnabled() && "visit".equals(method.getName());
        }

        private void hierarchyIn() {
            this.depth = this.depth + 1;
            this.hierarchyIndex.append("  ").append(this.depth).append(" ");
        }

        private void hierarchyOut() {
            this.hierarchyIndex.delete(this.hierarchyIndex.length() - 3 - this.depth.toString().length(), this.hierarchyIndex.length());
            Integer n = this.depth;
            Integer n2 = this.depth = Integer.valueOf(this.depth - 1);
        }
    }
}

