/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser.result.router;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class SQLBuilder
implements Appendable {
    private final Collection<Object> segments = new LinkedList<Object>();
    private final Map<String, StringToken> tokenMap = new HashMap<String, StringToken>();
    private StringBuilder currentSegment = new StringBuilder();

    public SQLBuilder() {
        this.segments.add(this.currentSegment);
    }

    public SQLBuilder appendToken(String token) {
        return this.appendToken(token, true);
    }

    public SQLBuilder appendToken(String token, boolean isSetValue) {
        StringToken stringToken;
        if (this.tokenMap.containsKey(token)) {
            stringToken = this.tokenMap.get(token);
        } else {
            stringToken = new StringToken();
            if (isSetValue) {
                stringToken.value = token;
            }
            this.tokenMap.put(token, stringToken);
        }
        this.segments.add(stringToken);
        this.currentSegment = new StringBuilder();
        this.segments.add(this.currentSegment);
        return this;
    }

    public SQLBuilder buildSQL(String originToken, String newToken) {
        if (this.tokenMap.containsKey(originToken)) {
            this.tokenMap.get(originToken).value = newToken;
        }
        return this;
    }

    public String toSQL() {
        StringBuilder result = new StringBuilder();
        for (Object each : this.segments) {
            result.append(each.toString());
        }
        return result.toString();
    }

    @Override
    public Appendable append(CharSequence sql) throws IOException {
        this.currentSegment.append(sql);
        return this;
    }

    @Override
    public Appendable append(CharSequence sql, int start, int end) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.currentSegment.append(c);
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Object each : this.segments) {
            if (each instanceof StringToken) {
                result.append(((StringToken)each).toToken());
                continue;
            }
            result.append(each.toString());
        }
        return result.toString();
    }

    private class StringToken {
        private String value;

        private StringToken() {
        }

        public String toToken() {
            return null == this.value ? "" : Joiner.on((String)"").join((Object)"[Token(", (Object)this.value, new Object[]{")]"});
        }

        public String toString() {
            return null == this.value ? "" : this.value;
        }
    }
}

