/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.dangdang.ddframe.rdb.sharding.exception.SQLParserException;
import com.dangdang.ddframe.rdb.sharding.parser.result.SQLParsedResult;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLStatementType;
import com.dangdang.ddframe.rdb.sharding.parser.visitor.SQLVisitor;
import com.dangdang.ddframe.rdb.sharding.parser.visitor.or.OrParser;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLParseEngine {
    private static final Logger log = LoggerFactory.getLogger(SQLParseEngine.class);
    private final SQLStatement sqlStatement;
    private final List<Object> parameters;
    private final SQLASTOutputVisitor visitor;
    private final Collection<String> shardingColumns;

    public SQLParsedResult parse() {
        SQLParsedResult result;
        Preconditions.checkArgument((boolean)(this.visitor instanceof SQLVisitor));
        SQLVisitor sqlVisitor = (SQLVisitor)this.visitor;
        this.visitor.setParameters(this.parameters);
        sqlVisitor.getParseContext().setShardingColumns(this.shardingColumns);
        this.sqlStatement.accept((SQLASTVisitor)this.visitor);
        if (sqlVisitor.getParseContext().isHasOrCondition()) {
            result = new OrParser(this.sqlStatement, this.visitor).parse();
        } else {
            sqlVisitor.getParseContext().mergeCurrentConditionContext();
            result = sqlVisitor.getParseContext().getParsedResult();
        }
        log.debug("Parsed SQL result: {}", (Object)result);
        log.debug("Parsed SQL: {}", (Object)sqlVisitor.getSQLBuilder());
        result.getRouteContext().setSqlBuilder(sqlVisitor.getSQLBuilder());
        result.getRouteContext().setSqlStatementType(this.getType());
        return result;
    }

    private SQLStatementType getType() {
        if (this.sqlStatement instanceof SQLSelectStatement) {
            return SQLStatementType.SELECT;
        }
        if (this.sqlStatement instanceof SQLInsertStatement) {
            return SQLStatementType.INSERT;
        }
        if (this.sqlStatement instanceof SQLUpdateStatement) {
            return SQLStatementType.UPDATE;
        }
        if (this.sqlStatement instanceof SQLDeleteStatement) {
            return SQLStatementType.DELETE;
        }
        throw new SQLParserException("Unsupported SQL statement: [%s]", this.sqlStatement);
    }

    @ConstructorProperties(value={"sqlStatement", "parameters", "visitor", "shardingColumns"})
    public SQLParseEngine(SQLStatement sqlStatement, List<Object> parameters, SQLASTOutputVisitor visitor, Collection<String> shardingColumns) {
        this.sqlStatement = sqlStatement;
        this.parameters = parameters;
        this.visitor = visitor;
        this.shardingColumns = shardingColumns;
    }
}

