/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger;

import com.dangdang.ddframe.rdb.sharding.merger.resultset.delegate.AbstractDelegateResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ShardingResultSets {
    private final List<ResultSet> resultSets;
    private final Type type;

    public ShardingResultSets(List<ResultSet> resultSets) throws SQLException {
        this.resultSets = this.filterResultSets(resultSets);
        this.type = this.generateType();
    }

    private List<ResultSet> filterResultSets(List<ResultSet> resultSets) throws SQLException {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>(resultSets.size());
        for (ResultSet each : resultSets) {
            if (!each.next()) continue;
            result.add(new WrapperResultSet(each));
        }
        return result;
    }

    private Type generateType() {
        if (this.resultSets.isEmpty()) {
            return Type.EMPTY;
        }
        if (1 == this.resultSets.size()) {
            return Type.SINGLE;
        }
        return Type.MULTIPLE;
    }

    public List<ResultSet> getResultSets() {
        return this.resultSets;
    }

    public Type getType() {
        return this.type;
    }

    private static final class WrapperResultSet
    extends AbstractDelegateResultSet {
        private WrapperResultSet(ResultSet resultSetWhenNextOnce) throws SQLException {
            super(Collections.singletonList(resultSetWhenNextOnce));
        }

        @Override
        protected boolean firstNext() throws SQLException {
            return true;
        }

        @Override
        protected boolean afterFirstNext() throws SQLException {
            return this.getDelegate().next();
        }
    }

    static enum Type {
        EMPTY,
        SINGLE,
        MULTIPLE;

    }
}

