/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc;

import com.codahale.metrics.Timer;
import com.dangdang.ddframe.rdb.sharding.hint.HintManagerHolder;
import com.dangdang.ddframe.rdb.sharding.jdbc.MasterSlaveDataSource;
import com.dangdang.ddframe.rdb.sharding.jdbc.ShardingContext;
import com.dangdang.ddframe.rdb.sharding.jdbc.ShardingPreparedStatement;
import com.dangdang.ddframe.rdb.sharding.jdbc.ShardingStatement;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractConnectionAdapter;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLStatementType;
import com.google.common.base.Joiner;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public final class ShardingConnection
extends AbstractConnectionAdapter {
    private final ShardingContext shardingContext;
    private final Map<String, Connection> connectionMap = new HashMap<String, Connection>();

    public Connection getConnection(String dataSourceName, SQLStatementType sqlStatementType) throws SQLException {
        Connection result = this.getConnectionInternal(dataSourceName, sqlStatementType);
        this.replayMethodsInvocation(result);
        return result;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection(this.shardingContext.getShardingRule().getDataSourceRule().getDataSourceNames().iterator().next(), SQLStatementType.SELECT).getMetaData();
    }

    private Connection getConnectionInternal(String dataSourceName, SQLStatementType sqlStatementType) throws SQLException {
        if (this.connectionMap.containsKey(dataSourceName)) {
            return this.connectionMap.get(dataSourceName);
        }
        Timer.Context metricsContext = MetricsContext.start(Joiner.on((String)"-").join((Object)"ShardingConnection-getConnection", (Object)dataSourceName, new Object[0]));
        DataSource dataSource = this.shardingContext.getShardingRule().getDataSourceRule().getDataSource(dataSourceName);
        if (dataSource instanceof MasterSlaveDataSource) {
            dataSource = ((MasterSlaveDataSource)dataSource).getDataSource(sqlStatementType);
        }
        Connection result = dataSource.getConnection();
        MetricsContext.stop(metricsContext);
        this.connectionMap.put(dataSourceName, result);
        return result;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ShardingPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new ShardingPreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new ShardingPreparedStatement(this, sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new ShardingPreparedStatement(this, sql, columnNames);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new ShardingStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Collection<Connection> getConnections() {
        return this.connectionMap.values();
    }

    @Override
    public void close() throws SQLException {
        super.close();
        HintManagerHolder.clear();
        MasterSlaveDataSource.resetDMLFlag();
    }

    @ConstructorProperties(value={"shardingContext"})
    public ShardingConnection(ShardingContext shardingContext) {
        this.shardingContext = shardingContext;
    }

    ShardingContext getShardingContext() {
        return this.shardingContext;
    }
}

