/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor;

import com.codahale.metrics.Timer;
import com.dangdang.ddframe.rdb.sharding.executor.ExecuteUnit;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorDataMap;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorEngine;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorExceptionHandler;
import com.dangdang.ddframe.rdb.sharding.executor.MergeUnit;
import com.dangdang.ddframe.rdb.sharding.executor.event.DMLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.DMLExecutionEventBus;
import com.dangdang.ddframe.rdb.sharding.executor.event.DQLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.DQLExecutionEventBus;
import com.dangdang.ddframe.rdb.sharding.executor.event.EventExecutionType;
import com.dangdang.ddframe.rdb.sharding.executor.event.ExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.PreparedStatementExecutorWrapper;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class PreparedStatementExecutor {
    private final ExecutorEngine executorEngine;
    private final Collection<PreparedStatementExecutorWrapper> preparedStatementExecutorWrappers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultSet> executeQuery() {
        List<ResultSet> result;
        Timer.Context context = MetricsContext.start("ShardingPreparedStatement-executeQuery");
        this.postExecutionEvents();
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        try {
            if (1 == this.preparedStatementExecutorWrappers.size()) {
                List<ResultSet> list = Collections.singletonList(this.executeQueryInternal(this.preparedStatementExecutorWrappers.iterator().next(), isExceptionThrown, dataMap));
                return list;
            }
            result = this.executorEngine.execute(this.preparedStatementExecutorWrappers, new ExecuteUnit<PreparedStatementExecutorWrapper, ResultSet>(){

                @Override
                public ResultSet execute(PreparedStatementExecutorWrapper input) throws Exception {
                    return PreparedStatementExecutor.this.executeQueryInternal(input, isExceptionThrown, dataMap);
                }
            });
        }
        finally {
            MetricsContext.stop(context);
        }
        return result;
    }

    private ResultSet executeQueryInternal(PreparedStatementExecutorWrapper preparedStatementExecutorWrapper, boolean isExceptionThrown, Map<String, Object> dataMap) {
        ResultSet result;
        ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
        ExecutorDataMap.setDataMap(dataMap);
        try {
            result = preparedStatementExecutorWrapper.getPreparedStatement().executeQuery();
        }
        catch (SQLException ex) {
            this.postExecutionEventsAfterExecution(preparedStatementExecutorWrapper, EventExecutionType.EXECUTE_FAILURE, (Optional<SQLException>)Optional.of((Object)ex));
            ExecutorExceptionHandler.handleException(ex);
            return null;
        }
        this.postExecutionEventsAfterExecution(preparedStatementExecutorWrapper);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() {
        Timer.Context context = MetricsContext.start("ShardingPreparedStatement-executeUpdate");
        this.postExecutionEvents();
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        try {
            if (1 == this.preparedStatementExecutorWrappers.size()) {
                int n = this.executeUpdateInternal(this.preparedStatementExecutorWrappers.iterator().next(), isExceptionThrown, dataMap);
                return n;
            }
            int n = this.executorEngine.execute(this.preparedStatementExecutorWrappers, new ExecuteUnit<PreparedStatementExecutorWrapper, Integer>(){

                @Override
                public Integer execute(PreparedStatementExecutorWrapper input) throws Exception {
                    return PreparedStatementExecutor.this.executeUpdateInternal(input, isExceptionThrown, dataMap);
                }
            }, new MergeUnit<Integer, Integer>(){

                @Override
                public Integer merge(List<Integer> results) {
                    if (null == results) {
                        return 0;
                    }
                    int result = 0;
                    for (Integer each : results) {
                        result += each.intValue();
                    }
                    return result;
                }
            });
            return n;
        }
        finally {
            MetricsContext.stop(context);
        }
    }

    private int executeUpdateInternal(PreparedStatementExecutorWrapper preparedStatementExecutorWrapper, boolean isExceptionThrown, Map<String, Object> dataMap) {
        int result;
        ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
        ExecutorDataMap.setDataMap(dataMap);
        try {
            result = preparedStatementExecutorWrapper.getPreparedStatement().executeUpdate();
        }
        catch (SQLException ex) {
            this.postExecutionEventsAfterExecution(preparedStatementExecutorWrapper, EventExecutionType.EXECUTE_FAILURE, (Optional<SQLException>)Optional.of((Object)ex));
            ExecutorExceptionHandler.handleException(ex);
            return 0;
        }
        this.postExecutionEventsAfterExecution(preparedStatementExecutorWrapper);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        Timer.Context context = MetricsContext.start("ShardingPreparedStatement-execute");
        this.postExecutionEvents();
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        try {
            if (1 == this.preparedStatementExecutorWrappers.size()) {
                PreparedStatementExecutorWrapper preparedStatementExecutorWrapper = this.preparedStatementExecutorWrappers.iterator().next();
                boolean bl = this.executeInternal(preparedStatementExecutorWrapper, isExceptionThrown, dataMap, (Optional<Timer.Context>)Optional.fromNullable((Object)context));
                return bl;
            }
            boolean bl = this.executorEngine.execute(this.preparedStatementExecutorWrappers, new ExecuteUnit<PreparedStatementExecutorWrapper, Boolean>(){

                @Override
                public Boolean execute(PreparedStatementExecutorWrapper input) throws Exception {
                    return PreparedStatementExecutor.this.executeInternal(input, isExceptionThrown, dataMap, (Optional<Timer.Context>)Optional.absent());
                }
            }).get(0);
            return bl;
        }
        finally {
            MetricsContext.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal(PreparedStatementExecutorWrapper preparedStatementExecutorWrapper, boolean isExceptionThrown, Map<String, Object> dataMap, Optional<Timer.Context> context) {
        boolean result;
        ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
        ExecutorDataMap.setDataMap(dataMap);
        try {
            result = preparedStatementExecutorWrapper.getPreparedStatement().execute();
        }
        catch (SQLException ex) {
            this.postExecutionEventsAfterExecution(preparedStatementExecutorWrapper, EventExecutionType.EXECUTE_FAILURE, (Optional<SQLException>)Optional.of((Object)ex));
            ExecutorExceptionHandler.handleException(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (context.isPresent()) {
                MetricsContext.stop((Timer.Context)context.get());
            }
        }
        this.postExecutionEventsAfterExecution(preparedStatementExecutorWrapper);
        return result;
    }

    private void postExecutionEvents() {
        for (PreparedStatementExecutorWrapper each : this.preparedStatementExecutorWrappers) {
            if (each.getDMLExecutionEvent().isPresent()) {
                DMLExecutionEventBus.post((DMLExecutionEvent)each.getDMLExecutionEvent().get());
            }
            if (!each.getDQLExecutionEvent().isPresent()) continue;
            DQLExecutionEventBus.post((DQLExecutionEvent)each.getDQLExecutionEvent().get());
        }
    }

    private void postExecutionEventsAfterExecution(PreparedStatementExecutorWrapper preparedStatementExecutorWrapper) {
        this.postExecutionEventsAfterExecution(preparedStatementExecutorWrapper, EventExecutionType.EXECUTE_SUCCESS, (Optional<SQLException>)Optional.absent());
    }

    private void postExecutionEventsAfterExecution(PreparedStatementExecutorWrapper preparedStatementExecutorWrapper, EventExecutionType eventExecutionType, Optional<SQLException> exp) {
        ExecutionEvent event;
        if (preparedStatementExecutorWrapper.getDMLExecutionEvent().isPresent()) {
            event = (DMLExecutionEvent)preparedStatementExecutorWrapper.getDMLExecutionEvent().get();
            event.setEventExecutionType(eventExecutionType);
            event.setExp(exp);
            DMLExecutionEventBus.post((DMLExecutionEvent)event);
        }
        if (preparedStatementExecutorWrapper.getDQLExecutionEvent().isPresent()) {
            event = (DQLExecutionEvent)preparedStatementExecutorWrapper.getDQLExecutionEvent().get();
            event.setEventExecutionType(eventExecutionType);
            event.setExp(exp);
            DQLExecutionEventBus.post((DQLExecutionEvent)event);
        }
    }

    @ConstructorProperties(value={"executorEngine", "preparedStatementExecutorWrappers"})
    public PreparedStatementExecutor(ExecutorEngine executorEngine, Collection<PreparedStatementExecutorWrapper> preparedStatementExecutorWrappers) {
        this.executorEngine = executorEngine;
        this.preparedStatementExecutorWrappers = preparedStatementExecutorWrappers;
    }
}

