/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava.grpc;

import com.daml.grpc.adapter.ExecutionSequencerFactory;
import com.daml.ledger.api.v1.TransactionServiceGrpc;
import com.daml.ledger.api.v1.TransactionServiceOuterClass;
import com.daml.ledger.javaapi.data.GetFlatTransactionResponse;
import com.daml.ledger.javaapi.data.GetLedgerEndResponse;
import com.daml.ledger.javaapi.data.GetTransactionResponse;
import com.daml.ledger.javaapi.data.GetTransactionTreesResponse;
import com.daml.ledger.javaapi.data.GetTransactionsRequest;
import com.daml.ledger.javaapi.data.GetTransactionsResponse;
import com.daml.ledger.javaapi.data.LedgerOffset;
import com.daml.ledger.javaapi.data.Transaction;
import com.daml.ledger.javaapi.data.TransactionFilter;
import com.daml.ledger.javaapi.data.TransactionTree;
import com.daml.ledger.rxjava.TransactionsClient;
import com.daml.ledger.rxjava.grpc.helpers.StubHelper;
import com.daml.ledger.rxjava.util.ClientPublisherFlowable;
import io.grpc.Channel;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;

public final class TransactionClientImpl
implements TransactionsClient {
    private final String ledgerId;
    private final TransactionServiceGrpc.TransactionServiceStub serviceStub;
    private final TransactionServiceGrpc.TransactionServiceFutureStub serviceFutureStub;
    private final ExecutionSequencerFactory sequencerFactory;

    public TransactionClientImpl(String ledgerId, Channel channel, ExecutionSequencerFactory sequencerFactory, Optional<String> accessToken) {
        this.ledgerId = ledgerId;
        this.sequencerFactory = sequencerFactory;
        this.serviceStub = StubHelper.authenticating(TransactionServiceGrpc.newStub((Channel)channel), accessToken);
        this.serviceFutureStub = StubHelper.authenticating(TransactionServiceGrpc.newFutureStub((Channel)channel), accessToken);
    }

    private Flowable<Transaction> extractTransactions(TransactionServiceOuterClass.GetTransactionsRequest request, Optional<String> accessToken) {
        return ClientPublisherFlowable.create(request, (arg_0, arg_1) -> ((TransactionServiceGrpc.TransactionServiceStub)StubHelper.authenticating(this.serviceStub, accessToken)).getTransactions(arg_0, arg_1), this.sequencerFactory).map(GetTransactionsResponse::fromProto).concatMapIterable(GetTransactionsResponse::getTransactions);
    }

    private Flowable<Transaction> getTransactions(LedgerOffset begin, LedgerOffset end, TransactionFilter filter, boolean verbose, Optional<String> accessToken) {
        TransactionServiceOuterClass.GetTransactionsRequest request = new GetTransactionsRequest(this.ledgerId, begin, end, filter, verbose).toProto();
        return this.extractTransactions(request, accessToken);
    }

    @Override
    public Flowable<Transaction> getTransactions(LedgerOffset begin, LedgerOffset end, TransactionFilter filter, boolean verbose) {
        return this.getTransactions(begin, end, filter, verbose, Optional.empty());
    }

    @Override
    public Flowable<Transaction> getTransactions(LedgerOffset begin, LedgerOffset end, TransactionFilter filter, boolean verbose, String accessToken) {
        return this.getTransactions(begin, end, filter, verbose, Optional.of(accessToken));
    }

    private Flowable<Transaction> getTransactions(LedgerOffset begin, TransactionFilter filter, boolean verbose, Optional<String> accessToken) {
        TransactionServiceOuterClass.GetTransactionsRequest request = new GetTransactionsRequest(this.ledgerId, begin, filter, verbose).toProto();
        return this.extractTransactions(request, accessToken);
    }

    @Override
    public Flowable<Transaction> getTransactions(LedgerOffset begin, TransactionFilter filter, boolean verbose) {
        return this.getTransactions(begin, filter, verbose, Optional.empty());
    }

    @Override
    public Flowable<Transaction> getTransactions(LedgerOffset begin, TransactionFilter filter, boolean verbose, String accessToken) {
        return this.getTransactions(begin, filter, verbose, Optional.of(accessToken));
    }

    private Flowable<TransactionTree> extractTransactionTrees(TransactionServiceOuterClass.GetTransactionsRequest request, Optional<String> accessToken) {
        return ClientPublisherFlowable.create(request, (arg_0, arg_1) -> ((TransactionServiceGrpc.TransactionServiceStub)StubHelper.authenticating(this.serviceStub, accessToken)).getTransactionTrees(arg_0, arg_1), this.sequencerFactory).map(GetTransactionTreesResponse::fromProto).concatMapIterable(GetTransactionTreesResponse::getTransactions);
    }

    private Flowable<TransactionTree> getTransactionsTrees(LedgerOffset begin, TransactionFilter filter, boolean verbose, Optional<String> accessToken) {
        TransactionServiceOuterClass.GetTransactionsRequest request = new GetTransactionsRequest(this.ledgerId, begin, filter, verbose).toProto();
        return this.extractTransactionTrees(request, accessToken);
    }

    @Override
    public Flowable<TransactionTree> getTransactionsTrees(LedgerOffset begin, TransactionFilter filter, boolean verbose) {
        return this.getTransactionsTrees(begin, filter, verbose, Optional.empty());
    }

    @Override
    public Flowable<TransactionTree> getTransactionsTrees(LedgerOffset begin, TransactionFilter filter, boolean verbose, String accessToken) {
        return this.getTransactionsTrees(begin, filter, verbose, Optional.of(accessToken));
    }

    private Flowable<TransactionTree> getTransactionsTrees(LedgerOffset begin, LedgerOffset end, TransactionFilter filter, boolean verbose, Optional<String> accessToken) {
        TransactionServiceOuterClass.GetTransactionsRequest request = new GetTransactionsRequest(this.ledgerId, begin, end, filter, verbose).toProto();
        return this.extractTransactionTrees(request, accessToken);
    }

    @Override
    public Flowable<TransactionTree> getTransactionsTrees(LedgerOffset begin, LedgerOffset end, TransactionFilter filter, boolean verbose) {
        return this.getTransactionsTrees(begin, end, filter, verbose, Optional.empty());
    }

    @Override
    public Flowable<TransactionTree> getTransactionsTrees(LedgerOffset begin, LedgerOffset end, TransactionFilter filter, boolean verbose, String accessToken) {
        return this.getTransactionsTrees(begin, end, filter, verbose, Optional.of(accessToken));
    }

    private Single<TransactionTree> extractTransactionTree(Future<TransactionServiceOuterClass.GetTransactionResponse> future) {
        return Single.fromFuture(future).map(GetTransactionResponse::fromProto).map(GetTransactionResponse::getTransaction);
    }

    private Single<TransactionTree> getTransactionByEventId(String eventId, Set<String> requestingParties, Optional<String> accessToken) {
        TransactionServiceOuterClass.GetTransactionByEventIdRequest request = TransactionServiceOuterClass.GetTransactionByEventIdRequest.newBuilder().setLedgerId(this.ledgerId).setEventId(eventId).addAllRequestingParties(requestingParties).build();
        return this.extractTransactionTree((Future<TransactionServiceOuterClass.GetTransactionResponse>)StubHelper.authenticating(this.serviceFutureStub, accessToken).getTransactionByEventId(request));
    }

    @Override
    public Single<TransactionTree> getTransactionByEventId(String eventId, Set<String> requestingParties) {
        return this.getTransactionByEventId(eventId, requestingParties, Optional.empty());
    }

    @Override
    public Single<TransactionTree> getTransactionByEventId(String eventId, Set<String> requestingParties, String accessToken) {
        return this.getTransactionByEventId(eventId, requestingParties, Optional.of(accessToken));
    }

    private Single<TransactionTree> getTransactionById(String transactionId, Set<String> requestingParties, Optional<String> accessToken) {
        TransactionServiceOuterClass.GetTransactionByIdRequest request = TransactionServiceOuterClass.GetTransactionByIdRequest.newBuilder().setLedgerId(this.ledgerId).setTransactionId(transactionId).addAllRequestingParties(requestingParties).build();
        return this.extractTransactionTree((Future<TransactionServiceOuterClass.GetTransactionResponse>)StubHelper.authenticating(this.serviceFutureStub, accessToken).getTransactionById(request));
    }

    @Override
    public Single<TransactionTree> getTransactionById(String transactionId, Set<String> requestingParties) {
        return this.getTransactionById(transactionId, requestingParties, Optional.empty());
    }

    @Override
    public Single<TransactionTree> getTransactionById(String transactionId, Set<String> requestingParties, String accessToken) {
        return this.getTransactionById(transactionId, requestingParties, Optional.of(accessToken));
    }

    private Single<Transaction> extractTransaction(Future<TransactionServiceOuterClass.GetFlatTransactionResponse> future) {
        return Single.fromFuture(future).map(GetFlatTransactionResponse::fromProto).map(GetFlatTransactionResponse::getTransaction);
    }

    private Single<Transaction> getFlatTransactionByEventId(String eventId, Set<String> requestingParties, Optional<String> accessToken) {
        TransactionServiceOuterClass.GetTransactionByEventIdRequest request = TransactionServiceOuterClass.GetTransactionByEventIdRequest.newBuilder().setLedgerId(this.ledgerId).setEventId(eventId).addAllRequestingParties(requestingParties).build();
        return this.extractTransaction((Future<TransactionServiceOuterClass.GetFlatTransactionResponse>)StubHelper.authenticating(this.serviceFutureStub, accessToken).getFlatTransactionByEventId(request));
    }

    @Override
    public Single<Transaction> getFlatTransactionByEventId(String eventId, Set<String> requestingParties) {
        return this.getFlatTransactionByEventId(eventId, requestingParties, Optional.empty());
    }

    @Override
    public Single<Transaction> getFlatTransactionByEventId(String eventId, Set<String> requestingParties, String accessToken) {
        return this.getFlatTransactionByEventId(eventId, requestingParties, Optional.of(accessToken));
    }

    private Single<Transaction> getFlatTransactionById(String transactionId, Set<String> requestingParties, Optional<String> accessToken) {
        TransactionServiceOuterClass.GetTransactionByIdRequest request = TransactionServiceOuterClass.GetTransactionByIdRequest.newBuilder().setLedgerId(this.ledgerId).setTransactionId(transactionId).addAllRequestingParties(requestingParties).build();
        return this.extractTransaction((Future<TransactionServiceOuterClass.GetFlatTransactionResponse>)StubHelper.authenticating(this.serviceFutureStub, accessToken).getFlatTransactionById(request));
    }

    @Override
    public Single<Transaction> getFlatTransactionById(String transactionId, Set<String> requestingParties) {
        return this.getFlatTransactionById(transactionId, requestingParties, Optional.empty());
    }

    @Override
    public Single<Transaction> getFlatTransactionById(String transactionId, Set<String> requestingParties, String accessToken) {
        return this.getFlatTransactionById(transactionId, requestingParties, Optional.of(accessToken));
    }

    private Single<LedgerOffset> getLedgerEnd(Optional<String> accessToken) {
        TransactionServiceOuterClass.GetLedgerEndRequest request = TransactionServiceOuterClass.GetLedgerEndRequest.newBuilder().setLedgerId(this.ledgerId).build();
        return Single.fromFuture((Future)StubHelper.authenticating(this.serviceFutureStub, accessToken).getLedgerEnd(request)).map(GetLedgerEndResponse::fromProto).map(GetLedgerEndResponse::getOffset);
    }

    @Override
    public Single<LedgerOffset> getLedgerEnd() {
        return this.getLedgerEnd(Optional.empty());
    }

    @Override
    public Single<LedgerOffset> getLedgerEnd(String accessToken) {
        return this.getLedgerEnd(Optional.of(accessToken));
    }
}

