/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava.grpc;

import com.daml.ledger.api.v1.LedgerIdentityServiceGrpc;
import com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass;
import com.daml.ledger.rxjava.LedgerIdentityClient;
import com.daml.ledger.rxjava.grpc.helpers.StubHelper;
import io.grpc.Channel;
import io.reactivex.Single;
import java.util.Optional;
import java.util.concurrent.Future;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LedgerIdentityClientImpl
implements LedgerIdentityClient {
    private LedgerIdentityServiceGrpc.LedgerIdentityServiceFutureStub serviceStub;

    public LedgerIdentityClientImpl(Channel channel, Optional<String> accessToken) {
        this.serviceStub = StubHelper.authenticating(LedgerIdentityServiceGrpc.newFutureStub((Channel)channel), accessToken);
    }

    private Single<String> getLedgerIdentity(@NonNull Optional<String> accessToken) {
        return Single.fromFuture((Future)StubHelper.authenticating(this.serviceStub, accessToken).getLedgerIdentity(LedgerIdentityServiceOuterClass.GetLedgerIdentityRequest.getDefaultInstance())).map(LedgerIdentityServiceOuterClass.GetLedgerIdentityResponse::getLedgerId);
    }

    @Override
    public Single<String> getLedgerIdentity() {
        return this.getLedgerIdentity(Optional.empty());
    }

    @Override
    public Single<String> getLedgerIdentity(@NonNull String accessToken) {
        return this.getLedgerIdentity(Optional.of(accessToken));
    }
}

