/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava.components.helpers;

import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Pair<F, S> {
    private final F first;
    private final S second;

    public Pair(@NonNull F first, @NonNull S second) {
        this.first = first;
        this.second = second;
    }

    public final @NonNull F getFirst() {
        return this.first;
    }

    public final @NonNull S getSecond() {
        return this.second;
    }

    public final <F2> @NonNull Pair<F2, S> mapFirst(Function<F, F2> f) {
        return new Pair<F2, S>(f.apply(this.getFirst()), this.getSecond());
    }

    public final <S2> @NonNull Pair<F, S2> mapSecond(Function<S, S2> f) {
        return new Pair<F, S2>(this.getFirst(), f.apply(this.getSecond()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.first, pair.first) && Objects.equals(this.second, pair.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return "Pair{first=" + this.first + ", second=" + this.second + '}';
    }
}

