/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.TransactionOuterClass;
import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.ExercisedEvent;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.UnsupportedEventTypeException;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface TreeEvent {
    public @NonNull List<@NonNull String> getWitnessParties();

    public @NonNull String getEventId();

    public @NonNull Identifier getTemplateId();

    public @NonNull String getContractId();

    default public TransactionOuterClass.TreeEvent toProtoTreeEvent() {
        TransactionOuterClass.TreeEvent.Builder eventBuilder = TransactionOuterClass.TreeEvent.newBuilder();
        if (this instanceof CreatedEvent) {
            CreatedEvent event = (CreatedEvent)this;
            eventBuilder.setCreated(event.toProto());
        } else if (this instanceof ExercisedEvent) {
            ExercisedEvent event = (ExercisedEvent)this;
            eventBuilder.setExercised(event.toProto());
        } else {
            throw new RuntimeException("this should be CreatedEvent or ExercisedEvent, found " + this.toString());
        }
        return eventBuilder.build();
    }

    public static TreeEvent fromProtoTreeEvent(TransactionOuterClass.TreeEvent event) {
        if (event.hasCreated()) {
            return CreatedEvent.fromProto(event.getCreated());
        }
        if (event.hasExercised()) {
            return ExercisedEvent.fromProto(event.getExercised());
        }
        throw new UnsupportedEventTypeException(event.toString());
    }
}

