/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.LedgerOffsetOuterClass;
import com.daml.ledger.javaapi.data.LedgerBoundaryUnrecognized;
import com.daml.ledger.javaapi.data.LedgerBoundaryUnset;
import com.daml.ledger.javaapi.data.LedgerOffsetUnknown;
import java.util.Objects;

public abstract class LedgerOffset {
    public static LedgerOffset fromProto(LedgerOffsetOuterClass.LedgerOffset ledgerOffset) {
        switch (ledgerOffset.getValueCase()) {
            case ABSOLUTE: {
                return new Absolute(ledgerOffset.getAbsolute());
            }
            case BOUNDARY: {
                switch (ledgerOffset.getBoundary()) {
                    case LEDGER_BEGIN: {
                        return LedgerBegin.instance;
                    }
                    case LEDGER_END: {
                        return LedgerEnd.instance;
                    }
                }
                throw new LedgerBoundaryUnrecognized(ledgerOffset.getBoundary());
            }
        }
        throw new LedgerBoundaryUnset(ledgerOffset);
    }

    public final LedgerOffsetOuterClass.LedgerOffset toProto() {
        if (this instanceof LedgerBegin) {
            return LedgerOffsetOuterClass.LedgerOffset.newBuilder().setBoundary(LedgerOffsetOuterClass.LedgerOffset.LedgerBoundary.LEDGER_BEGIN).build();
        }
        if (this instanceof LedgerEnd) {
            return LedgerOffsetOuterClass.LedgerOffset.newBuilder().setBoundary(LedgerOffsetOuterClass.LedgerOffset.LedgerBoundary.LEDGER_END).build();
        }
        if (this instanceof Absolute) {
            Absolute absolute = (Absolute)this;
            return LedgerOffsetOuterClass.LedgerOffset.newBuilder().setAbsolute(absolute.offset).build();
        }
        throw new LedgerOffsetUnknown(this);
    }

    public static final class Absolute
    extends LedgerOffset {
        private final String offset;

        public Absolute(String offset) {
            this.offset = offset;
        }

        public String getOffset() {
            return this.offset;
        }

        public String toString() {
            return "LedgerOffset.Absolute(" + this.offset + ')';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Absolute absolute = (Absolute)o;
            return Objects.equals(this.offset, absolute.offset);
        }

        public int hashCode() {
            return Objects.hash(this.offset);
        }
    }

    public static final class LedgerEnd
    extends LedgerOffset {
        static LedgerEnd instance = new LedgerEnd();

        private LedgerEnd() {
        }

        public static LedgerEnd getInstance() {
            return instance;
        }

        public String toString() {
            return "LedgerOffset.End";
        }
    }

    public static final class LedgerBegin
    extends LedgerOffset {
        static LedgerBegin instance = new LedgerBegin();

        private LedgerBegin() {
        }

        public static LedgerBegin getInstance() {
            return instance;
        }

        public String toString() {
            return "LedgerOffset.Begin";
        }
    }
}

