package com.daml.ledger.api.v1.admin;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * Status: experimental interface, will change before it is deemed production
 * ready
 * Inspect the party management state of a ledger participant and modify the
 * parts that are modifiable. We use 'backing participant' to refer to this
 * specific participant in the methods of this API.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/admin/party_management_service.proto")
public final class PartyManagementServiceGrpc {

  private PartyManagementServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.admin.PartyManagementService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse> getGetParticipantIdMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetParticipantId",
      requestType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest.class,
      responseType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse> getGetParticipantIdMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse> getGetParticipantIdMethod;
    if ((getGetParticipantIdMethod = PartyManagementServiceGrpc.getGetParticipantIdMethod) == null) {
      synchronized (PartyManagementServiceGrpc.class) {
        if ((getGetParticipantIdMethod = PartyManagementServiceGrpc.getGetParticipantIdMethod) == null) {
          PartyManagementServiceGrpc.getGetParticipantIdMethod = getGetParticipantIdMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.admin.PartyManagementService", "GetParticipantId"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new PartyManagementServiceMethodDescriptorSupplier("GetParticipantId"))
                  .build();
          }
        }
     }
     return getGetParticipantIdMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse> getGetPartiesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetParties",
      requestType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest.class,
      responseType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse> getGetPartiesMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse> getGetPartiesMethod;
    if ((getGetPartiesMethod = PartyManagementServiceGrpc.getGetPartiesMethod) == null) {
      synchronized (PartyManagementServiceGrpc.class) {
        if ((getGetPartiesMethod = PartyManagementServiceGrpc.getGetPartiesMethod) == null) {
          PartyManagementServiceGrpc.getGetPartiesMethod = getGetPartiesMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.admin.PartyManagementService", "GetParties"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new PartyManagementServiceMethodDescriptorSupplier("GetParties"))
                  .build();
          }
        }
     }
     return getGetPartiesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse> getListKnownPartiesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListKnownParties",
      requestType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest.class,
      responseType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse> getListKnownPartiesMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse> getListKnownPartiesMethod;
    if ((getListKnownPartiesMethod = PartyManagementServiceGrpc.getListKnownPartiesMethod) == null) {
      synchronized (PartyManagementServiceGrpc.class) {
        if ((getListKnownPartiesMethod = PartyManagementServiceGrpc.getListKnownPartiesMethod) == null) {
          PartyManagementServiceGrpc.getListKnownPartiesMethod = getListKnownPartiesMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.admin.PartyManagementService", "ListKnownParties"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new PartyManagementServiceMethodDescriptorSupplier("ListKnownParties"))
                  .build();
          }
        }
     }
     return getListKnownPartiesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse> getAllocatePartyMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "AllocateParty",
      requestType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest.class,
      responseType = com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest,
      com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse> getAllocatePartyMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse> getAllocatePartyMethod;
    if ((getAllocatePartyMethod = PartyManagementServiceGrpc.getAllocatePartyMethod) == null) {
      synchronized (PartyManagementServiceGrpc.class) {
        if ((getAllocatePartyMethod = PartyManagementServiceGrpc.getAllocatePartyMethod) == null) {
          PartyManagementServiceGrpc.getAllocatePartyMethod = getAllocatePartyMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest, com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.admin.PartyManagementService", "AllocateParty"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new PartyManagementServiceMethodDescriptorSupplier("AllocateParty"))
                  .build();
          }
        }
     }
     return getAllocatePartyMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static PartyManagementServiceStub newStub(io.grpc.Channel channel) {
    return new PartyManagementServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static PartyManagementServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new PartyManagementServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static PartyManagementServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new PartyManagementServiceFutureStub(channel);
  }

  /**
   * <pre>
   * Status: experimental interface, will change before it is deemed production
   * ready
   * Inspect the party management state of a ledger participant and modify the
   * parts that are modifiable. We use 'backing participant' to refer to this
   * specific participant in the methods of this API.
   * </pre>
   */
  public static abstract class PartyManagementServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Return the identifier of the backing participant.
     * All horizontally scaled replicas should return the same id.
     * daml-on-sql: returns an identifier supplied on command line at launch time
     * daml-on-kv-ledger: as above
     * canton: returns globally unique identifier of the backing participant
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public void getParticipantId(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetParticipantIdMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get the party details of the given parties. Only known parties will be
     * returned in the list.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public void getParties(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetPartiesMethod(), responseObserver);
    }

    /**
     * <pre>
     * List the parties known by the backing participant.
     * The list returned contains parties whose ledger access is facilitated by
     * backing participant and the ones maintained elsewhere.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public void listKnownParties(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListKnownPartiesMethod(), responseObserver);
    }

    /**
     * <pre>
     * Adds a new party to the set managed by the backing participant.
     * Caller specifies a party identifier suggestion, the actual identifier
     * allocated might be different and is implementation specific.
     * This call may:
     * - Succeed, in which case the actual allocated identifier is visible in
     *   the response.
     * - Respond with a gRPC error
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``UNIMPLEMENTED``: if synchronous party allocation is not supported by the backing participant
     * - ``INVALID_ARGUMENT``: if the provided hint and/or display name is invalid on the given ledger (see below).
     * daml-on-sql: suggestion's uniqueness is checked and call rejected if the identifier is already present
     * daml-on-kv-ledger: suggestion's uniqueness is checked by the validators in
     * the consensus layer and call rejected if the identifier is already present.
     * canton: completely different globally unique identifier is allocated.
     * Behind the scenes calls to an internal protocol are made. As that protocol
     * is richer than the surface protocol, the arguments take implicit values
     * </pre>
     */
    public void allocateParty(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getAllocatePartyMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getGetParticipantIdMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest,
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse>(
                  this, METHODID_GET_PARTICIPANT_ID)))
          .addMethod(
            getGetPartiesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest,
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse>(
                  this, METHODID_GET_PARTIES)))
          .addMethod(
            getListKnownPartiesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest,
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse>(
                  this, METHODID_LIST_KNOWN_PARTIES)))
          .addMethod(
            getAllocatePartyMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest,
                com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse>(
                  this, METHODID_ALLOCATE_PARTY)))
          .build();
    }
  }

  /**
   * <pre>
   * Status: experimental interface, will change before it is deemed production
   * ready
   * Inspect the party management state of a ledger participant and modify the
   * parts that are modifiable. We use 'backing participant' to refer to this
   * specific participant in the methods of this API.
   * </pre>
   */
  public static final class PartyManagementServiceStub extends io.grpc.stub.AbstractStub<PartyManagementServiceStub> {
    private PartyManagementServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PartyManagementServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PartyManagementServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PartyManagementServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Return the identifier of the backing participant.
     * All horizontally scaled replicas should return the same id.
     * daml-on-sql: returns an identifier supplied on command line at launch time
     * daml-on-kv-ledger: as above
     * canton: returns globally unique identifier of the backing participant
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public void getParticipantId(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetParticipantIdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get the party details of the given parties. Only known parties will be
     * returned in the list.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public void getParties(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetPartiesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * List the parties known by the backing participant.
     * The list returned contains parties whose ledger access is facilitated by
     * backing participant and the ones maintained elsewhere.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public void listKnownParties(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListKnownPartiesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Adds a new party to the set managed by the backing participant.
     * Caller specifies a party identifier suggestion, the actual identifier
     * allocated might be different and is implementation specific.
     * This call may:
     * - Succeed, in which case the actual allocated identifier is visible in
     *   the response.
     * - Respond with a gRPC error
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``UNIMPLEMENTED``: if synchronous party allocation is not supported by the backing participant
     * - ``INVALID_ARGUMENT``: if the provided hint and/or display name is invalid on the given ledger (see below).
     * daml-on-sql: suggestion's uniqueness is checked and call rejected if the identifier is already present
     * daml-on-kv-ledger: suggestion's uniqueness is checked by the validators in
     * the consensus layer and call rejected if the identifier is already present.
     * canton: completely different globally unique identifier is allocated.
     * Behind the scenes calls to an internal protocol are made. As that protocol
     * is richer than the surface protocol, the arguments take implicit values
     * </pre>
     */
    public void allocateParty(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getAllocatePartyMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Status: experimental interface, will change before it is deemed production
   * ready
   * Inspect the party management state of a ledger participant and modify the
   * parts that are modifiable. We use 'backing participant' to refer to this
   * specific participant in the methods of this API.
   * </pre>
   */
  public static final class PartyManagementServiceBlockingStub extends io.grpc.stub.AbstractStub<PartyManagementServiceBlockingStub> {
    private PartyManagementServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PartyManagementServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PartyManagementServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PartyManagementServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Return the identifier of the backing participant.
     * All horizontally scaled replicas should return the same id.
     * daml-on-sql: returns an identifier supplied on command line at launch time
     * daml-on-kv-ledger: as above
     * canton: returns globally unique identifier of the backing participant
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse getParticipantId(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetParticipantIdMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get the party details of the given parties. Only known parties will be
     * returned in the list.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse getParties(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetPartiesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * List the parties known by the backing participant.
     * The list returned contains parties whose ledger access is facilitated by
     * backing participant and the ones maintained elsewhere.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse listKnownParties(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest request) {
      return blockingUnaryCall(
          getChannel(), getListKnownPartiesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Adds a new party to the set managed by the backing participant.
     * Caller specifies a party identifier suggestion, the actual identifier
     * allocated might be different and is implementation specific.
     * This call may:
     * - Succeed, in which case the actual allocated identifier is visible in
     *   the response.
     * - Respond with a gRPC error
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``UNIMPLEMENTED``: if synchronous party allocation is not supported by the backing participant
     * - ``INVALID_ARGUMENT``: if the provided hint and/or display name is invalid on the given ledger (see below).
     * daml-on-sql: suggestion's uniqueness is checked and call rejected if the identifier is already present
     * daml-on-kv-ledger: suggestion's uniqueness is checked by the validators in
     * the consensus layer and call rejected if the identifier is already present.
     * canton: completely different globally unique identifier is allocated.
     * Behind the scenes calls to an internal protocol are made. As that protocol
     * is richer than the surface protocol, the arguments take implicit values
     * </pre>
     */
    public com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse allocateParty(com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest request) {
      return blockingUnaryCall(
          getChannel(), getAllocatePartyMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Status: experimental interface, will change before it is deemed production
   * ready
   * Inspect the party management state of a ledger participant and modify the
   * parts that are modifiable. We use 'backing participant' to refer to this
   * specific participant in the methods of this API.
   * </pre>
   */
  public static final class PartyManagementServiceFutureStub extends io.grpc.stub.AbstractStub<PartyManagementServiceFutureStub> {
    private PartyManagementServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PartyManagementServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PartyManagementServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PartyManagementServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Return the identifier of the backing participant.
     * All horizontally scaled replicas should return the same id.
     * daml-on-sql: returns an identifier supplied on command line at launch time
     * daml-on-kv-ledger: as above
     * canton: returns globally unique identifier of the backing participant
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse> getParticipantId(
        com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetParticipantIdMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get the party details of the given parties. Only known parties will be
     * returned in the list.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse> getParties(
        com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetPartiesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * List the parties known by the backing participant.
     * The list returned contains parties whose ledger access is facilitated by
     * backing participant and the ones maintained elsewhere.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse> listKnownParties(
        com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListKnownPartiesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Adds a new party to the set managed by the backing participant.
     * Caller specifies a party identifier suggestion, the actual identifier
     * allocated might be different and is implementation specific.
     * This call may:
     * - Succeed, in which case the actual allocated identifier is visible in
     *   the response.
     * - Respond with a gRPC error
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``UNIMPLEMENTED``: if synchronous party allocation is not supported by the backing participant
     * - ``INVALID_ARGUMENT``: if the provided hint and/or display name is invalid on the given ledger (see below).
     * daml-on-sql: suggestion's uniqueness is checked and call rejected if the identifier is already present
     * daml-on-kv-ledger: suggestion's uniqueness is checked by the validators in
     * the consensus layer and call rejected if the identifier is already present.
     * canton: completely different globally unique identifier is allocated.
     * Behind the scenes calls to an internal protocol are made. As that protocol
     * is richer than the surface protocol, the arguments take implicit values
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse> allocateParty(
        com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getAllocatePartyMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_PARTICIPANT_ID = 0;
  private static final int METHODID_GET_PARTIES = 1;
  private static final int METHODID_LIST_KNOWN_PARTIES = 2;
  private static final int METHODID_ALLOCATE_PARTY = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final PartyManagementServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(PartyManagementServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_PARTICIPANT_ID:
          serviceImpl.getParticipantId((com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetParticipantIdResponse>) responseObserver);
          break;
        case METHODID_GET_PARTIES:
          serviceImpl.getParties((com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.GetPartiesResponse>) responseObserver);
          break;
        case METHODID_LIST_KNOWN_PARTIES:
          serviceImpl.listKnownParties((com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.ListKnownPartiesResponse>) responseObserver);
          break;
        case METHODID_ALLOCATE_PARTY:
          serviceImpl.allocateParty((com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.AllocatePartyResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class PartyManagementServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    PartyManagementServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.admin.PartyManagementServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("PartyManagementService");
    }
  }

  private static final class PartyManagementServiceFileDescriptorSupplier
      extends PartyManagementServiceBaseDescriptorSupplier {
    PartyManagementServiceFileDescriptorSupplier() {}
  }

  private static final class PartyManagementServiceMethodDescriptorSupplier
      extends PartyManagementServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    PartyManagementServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (PartyManagementServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new PartyManagementServiceFileDescriptorSupplier())
              .addMethod(getGetParticipantIdMethod())
              .addMethod(getGetPartiesMethod())
              .addMethod(getListKnownPartiesMethod())
              .addMethod(getAllocatePartyMethod())
              .build();
        }
      }
    }
    return result;
  }
}
