package com.daml.ledger.api.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * Allows clients to verify that the server they are communicating with exposes the ledger they wish to operate on.
 * Note that every ledger has a unique ID.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/ledger_identity_service.proto")
public final class LedgerIdentityServiceGrpc {

  private LedgerIdentityServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.LedgerIdentityService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityRequest,
      com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityResponse> getGetLedgerIdentityMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetLedgerIdentity",
      requestType = com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityRequest.class,
      responseType = com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityRequest,
      com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityResponse> getGetLedgerIdentityMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityRequest, com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityResponse> getGetLedgerIdentityMethod;
    if ((getGetLedgerIdentityMethod = LedgerIdentityServiceGrpc.getGetLedgerIdentityMethod) == null) {
      synchronized (LedgerIdentityServiceGrpc.class) {
        if ((getGetLedgerIdentityMethod = LedgerIdentityServiceGrpc.getGetLedgerIdentityMethod) == null) {
          LedgerIdentityServiceGrpc.getGetLedgerIdentityMethod = getGetLedgerIdentityMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityRequest, com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.LedgerIdentityService", "GetLedgerIdentity"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new LedgerIdentityServiceMethodDescriptorSupplier("GetLedgerIdentity"))
                  .build();
          }
        }
     }
     return getGetLedgerIdentityMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static LedgerIdentityServiceStub newStub(io.grpc.Channel channel) {
    return new LedgerIdentityServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static LedgerIdentityServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new LedgerIdentityServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static LedgerIdentityServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new LedgerIdentityServiceFutureStub(channel);
  }

  /**
   * <pre>
   * Allows clients to verify that the server they are communicating with exposes the ledger they wish to operate on.
   * Note that every ledger has a unique ID.
   * </pre>
   */
  public static abstract class LedgerIdentityServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Clients may call this RPC to return the identifier of the ledger they are connected to.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public void getLedgerIdentity(com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetLedgerIdentityMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getGetLedgerIdentityMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityRequest,
                com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityResponse>(
                  this, METHODID_GET_LEDGER_IDENTITY)))
          .build();
    }
  }

  /**
   * <pre>
   * Allows clients to verify that the server they are communicating with exposes the ledger they wish to operate on.
   * Note that every ledger has a unique ID.
   * </pre>
   */
  public static final class LedgerIdentityServiceStub extends io.grpc.stub.AbstractStub<LedgerIdentityServiceStub> {
    private LedgerIdentityServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private LedgerIdentityServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LedgerIdentityServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new LedgerIdentityServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Clients may call this RPC to return the identifier of the ledger they are connected to.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public void getLedgerIdentity(com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetLedgerIdentityMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Allows clients to verify that the server they are communicating with exposes the ledger they wish to operate on.
   * Note that every ledger has a unique ID.
   * </pre>
   */
  public static final class LedgerIdentityServiceBlockingStub extends io.grpc.stub.AbstractStub<LedgerIdentityServiceBlockingStub> {
    private LedgerIdentityServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private LedgerIdentityServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LedgerIdentityServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new LedgerIdentityServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Clients may call this RPC to return the identifier of the ledger they are connected to.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityResponse getLedgerIdentity(com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetLedgerIdentityMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Allows clients to verify that the server they are communicating with exposes the ledger they wish to operate on.
   * Note that every ledger has a unique ID.
   * </pre>
   */
  public static final class LedgerIdentityServiceFutureStub extends io.grpc.stub.AbstractStub<LedgerIdentityServiceFutureStub> {
    private LedgerIdentityServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private LedgerIdentityServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LedgerIdentityServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new LedgerIdentityServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Clients may call this RPC to return the identifier of the ledger they are connected to.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityResponse> getLedgerIdentity(
        com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetLedgerIdentityMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_LEDGER_IDENTITY = 0;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final LedgerIdentityServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(LedgerIdentityServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_LEDGER_IDENTITY:
          serviceImpl.getLedgerIdentity((com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.GetLedgerIdentityResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class LedgerIdentityServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    LedgerIdentityServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.LedgerIdentityServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("LedgerIdentityService");
    }
  }

  private static final class LedgerIdentityServiceFileDescriptorSupplier
      extends LedgerIdentityServiceBaseDescriptorSupplier {
    LedgerIdentityServiceFileDescriptorSupplier() {}
  }

  private static final class LedgerIdentityServiceMethodDescriptorSupplier
      extends LedgerIdentityServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    LedgerIdentityServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (LedgerIdentityServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new LedgerIdentityServiceFileDescriptorSupplier())
              .addMethod(getGetLedgerIdentityMethod())
              .build();
        }
      }
    }
    return result;
  }
}
