package com.daml.ledger.api.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * Allows clients to attempt advancing the ledger's state by submitting commands.
 * The final states of their submissions are disclosed by the Command Completion Service.
 * The on-ledger effects of their submissions are disclosed by the Transaction Service.
 * Commands may fail in 2 distinct manners:
 * 1. Failure communicated in the gRPC error of the submission.
 * 2. Failure communicated in a Completion.
 * Only successfully submitted commands may produce a completion event.
 * Clients that do not receive a successful completion about their submission MUST NOT assume that it was successful.
 * Clients SHOULD subscribe to the CompletionStream before starting to submit commands to prevent race conditions.
 * Interprocess tracing of command submissions may be achieved via Zipkin by filling out the ``trace_context`` field.
 * The server will return a child context of the submitted one, (or a new one if the context was missing) on both the Completion and Transaction streams.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/command_submission_service.proto")
public final class CommandSubmissionServiceGrpc {

  private CommandSubmissionServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.CommandSubmissionService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass.SubmitRequest,
      com.google.protobuf.Empty> getSubmitMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Submit",
      requestType = com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass.SubmitRequest.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass.SubmitRequest,
      com.google.protobuf.Empty> getSubmitMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass.SubmitRequest, com.google.protobuf.Empty> getSubmitMethod;
    if ((getSubmitMethod = CommandSubmissionServiceGrpc.getSubmitMethod) == null) {
      synchronized (CommandSubmissionServiceGrpc.class) {
        if ((getSubmitMethod = CommandSubmissionServiceGrpc.getSubmitMethod) == null) {
          CommandSubmissionServiceGrpc.getSubmitMethod = getSubmitMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass.SubmitRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.CommandSubmissionService", "Submit"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass.SubmitRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
                  .setSchemaDescriptor(new CommandSubmissionServiceMethodDescriptorSupplier("Submit"))
                  .build();
          }
        }
     }
     return getSubmitMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static CommandSubmissionServiceStub newStub(io.grpc.Channel channel) {
    return new CommandSubmissionServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static CommandSubmissionServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new CommandSubmissionServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static CommandSubmissionServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new CommandSubmissionServiceFutureStub(channel);
  }

  /**
   * <pre>
   * Allows clients to attempt advancing the ledger's state by submitting commands.
   * The final states of their submissions are disclosed by the Command Completion Service.
   * The on-ledger effects of their submissions are disclosed by the Transaction Service.
   * Commands may fail in 2 distinct manners:
   * 1. Failure communicated in the gRPC error of the submission.
   * 2. Failure communicated in a Completion.
   * Only successfully submitted commands may produce a completion event.
   * Clients that do not receive a successful completion about their submission MUST NOT assume that it was successful.
   * Clients SHOULD subscribe to the CompletionStream before starting to submit commands to prevent race conditions.
   * Interprocess tracing of command submissions may be achieved via Zipkin by filling out the ``trace_context`` field.
   * The server will return a child context of the submitted one, (or a new one if the context was missing) on both the Completion and Transaction streams.
   * </pre>
   */
  public static abstract class CommandSubmissionServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Submit a single composite command.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``RESOURCE_EXHAUSTED``: if the participant or the ledger is overloaded. Clients should back off exponentially and retry.
     * </pre>
     */
    public void submit(com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass.SubmitRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncUnimplementedUnaryCall(getSubmitMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getSubmitMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass.SubmitRequest,
                com.google.protobuf.Empty>(
                  this, METHODID_SUBMIT)))
          .build();
    }
  }

  /**
   * <pre>
   * Allows clients to attempt advancing the ledger's state by submitting commands.
   * The final states of their submissions are disclosed by the Command Completion Service.
   * The on-ledger effects of their submissions are disclosed by the Transaction Service.
   * Commands may fail in 2 distinct manners:
   * 1. Failure communicated in the gRPC error of the submission.
   * 2. Failure communicated in a Completion.
   * Only successfully submitted commands may produce a completion event.
   * Clients that do not receive a successful completion about their submission MUST NOT assume that it was successful.
   * Clients SHOULD subscribe to the CompletionStream before starting to submit commands to prevent race conditions.
   * Interprocess tracing of command submissions may be achieved via Zipkin by filling out the ``trace_context`` field.
   * The server will return a child context of the submitted one, (or a new one if the context was missing) on both the Completion and Transaction streams.
   * </pre>
   */
  public static final class CommandSubmissionServiceStub extends io.grpc.stub.AbstractStub<CommandSubmissionServiceStub> {
    private CommandSubmissionServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private CommandSubmissionServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CommandSubmissionServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new CommandSubmissionServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Submit a single composite command.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``RESOURCE_EXHAUSTED``: if the participant or the ledger is overloaded. Clients should back off exponentially and retry.
     * </pre>
     */
    public void submit(com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass.SubmitRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSubmitMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Allows clients to attempt advancing the ledger's state by submitting commands.
   * The final states of their submissions are disclosed by the Command Completion Service.
   * The on-ledger effects of their submissions are disclosed by the Transaction Service.
   * Commands may fail in 2 distinct manners:
   * 1. Failure communicated in the gRPC error of the submission.
   * 2. Failure communicated in a Completion.
   * Only successfully submitted commands may produce a completion event.
   * Clients that do not receive a successful completion about their submission MUST NOT assume that it was successful.
   * Clients SHOULD subscribe to the CompletionStream before starting to submit commands to prevent race conditions.
   * Interprocess tracing of command submissions may be achieved via Zipkin by filling out the ``trace_context`` field.
   * The server will return a child context of the submitted one, (or a new one if the context was missing) on both the Completion and Transaction streams.
   * </pre>
   */
  public static final class CommandSubmissionServiceBlockingStub extends io.grpc.stub.AbstractStub<CommandSubmissionServiceBlockingStub> {
    private CommandSubmissionServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private CommandSubmissionServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CommandSubmissionServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new CommandSubmissionServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Submit a single composite command.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``RESOURCE_EXHAUSTED``: if the participant or the ledger is overloaded. Clients should back off exponentially and retry.
     * </pre>
     */
    public com.google.protobuf.Empty submit(com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass.SubmitRequest request) {
      return blockingUnaryCall(
          getChannel(), getSubmitMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Allows clients to attempt advancing the ledger's state by submitting commands.
   * The final states of their submissions are disclosed by the Command Completion Service.
   * The on-ledger effects of their submissions are disclosed by the Transaction Service.
   * Commands may fail in 2 distinct manners:
   * 1. Failure communicated in the gRPC error of the submission.
   * 2. Failure communicated in a Completion.
   * Only successfully submitted commands may produce a completion event.
   * Clients that do not receive a successful completion about their submission MUST NOT assume that it was successful.
   * Clients SHOULD subscribe to the CompletionStream before starting to submit commands to prevent race conditions.
   * Interprocess tracing of command submissions may be achieved via Zipkin by filling out the ``trace_context`` field.
   * The server will return a child context of the submitted one, (or a new one if the context was missing) on both the Completion and Transaction streams.
   * </pre>
   */
  public static final class CommandSubmissionServiceFutureStub extends io.grpc.stub.AbstractStub<CommandSubmissionServiceFutureStub> {
    private CommandSubmissionServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private CommandSubmissionServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CommandSubmissionServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new CommandSubmissionServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Submit a single composite command.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``RESOURCE_EXHAUSTED``: if the participant or the ledger is overloaded. Clients should back off exponentially and retry.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.protobuf.Empty> submit(
        com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass.SubmitRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getSubmitMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_SUBMIT = 0;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final CommandSubmissionServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(CommandSubmissionServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_SUBMIT:
          serviceImpl.submit((com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass.SubmitRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class CommandSubmissionServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    CommandSubmissionServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("CommandSubmissionService");
    }
  }

  private static final class CommandSubmissionServiceFileDescriptorSupplier
      extends CommandSubmissionServiceBaseDescriptorSupplier {
    CommandSubmissionServiceFileDescriptorSupplier() {}
  }

  private static final class CommandSubmissionServiceMethodDescriptorSupplier
      extends CommandSubmissionServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    CommandSubmissionServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (CommandSubmissionServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new CommandSubmissionServiceFileDescriptorSupplier())
              .addMethod(getSubmitMethod())
              .build();
        }
      }
    }
    return result;
  }
}
