package com.daml.ledger.api.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * Command Service is able to correlate submitted commands with completion data, identify timeouts, and return contextual
 * information with each tracking result. This supports the implementation of stateless clients.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/command_service.proto")
public final class CommandServiceGrpc {

  private CommandServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.CommandService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.google.protobuf.Empty> getSubmitAndWaitMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SubmitAndWait",
      requestType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.google.protobuf.Empty> getSubmitAndWaitMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.google.protobuf.Empty> getSubmitAndWaitMethod;
    if ((getSubmitAndWaitMethod = CommandServiceGrpc.getSubmitAndWaitMethod) == null) {
      synchronized (CommandServiceGrpc.class) {
        if ((getSubmitAndWaitMethod = CommandServiceGrpc.getSubmitAndWaitMethod) == null) {
          CommandServiceGrpc.getSubmitAndWaitMethod = getSubmitAndWaitMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.CommandService", "SubmitAndWait"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
                  .setSchemaDescriptor(new CommandServiceMethodDescriptorSupplier("SubmitAndWait"))
                  .build();
          }
        }
     }
     return getSubmitAndWaitMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse> getSubmitAndWaitForTransactionIdMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SubmitAndWaitForTransactionId",
      requestType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.class,
      responseType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse> getSubmitAndWaitForTransactionIdMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse> getSubmitAndWaitForTransactionIdMethod;
    if ((getSubmitAndWaitForTransactionIdMethod = CommandServiceGrpc.getSubmitAndWaitForTransactionIdMethod) == null) {
      synchronized (CommandServiceGrpc.class) {
        if ((getSubmitAndWaitForTransactionIdMethod = CommandServiceGrpc.getSubmitAndWaitForTransactionIdMethod) == null) {
          CommandServiceGrpc.getSubmitAndWaitForTransactionIdMethod = getSubmitAndWaitForTransactionIdMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.CommandService", "SubmitAndWaitForTransactionId"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new CommandServiceMethodDescriptorSupplier("SubmitAndWaitForTransactionId"))
                  .build();
          }
        }
     }
     return getSubmitAndWaitForTransactionIdMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse> getSubmitAndWaitForTransactionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SubmitAndWaitForTransaction",
      requestType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.class,
      responseType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse> getSubmitAndWaitForTransactionMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse> getSubmitAndWaitForTransactionMethod;
    if ((getSubmitAndWaitForTransactionMethod = CommandServiceGrpc.getSubmitAndWaitForTransactionMethod) == null) {
      synchronized (CommandServiceGrpc.class) {
        if ((getSubmitAndWaitForTransactionMethod = CommandServiceGrpc.getSubmitAndWaitForTransactionMethod) == null) {
          CommandServiceGrpc.getSubmitAndWaitForTransactionMethod = getSubmitAndWaitForTransactionMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.CommandService", "SubmitAndWaitForTransaction"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new CommandServiceMethodDescriptorSupplier("SubmitAndWaitForTransaction"))
                  .build();
          }
        }
     }
     return getSubmitAndWaitForTransactionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse> getSubmitAndWaitForTransactionTreeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SubmitAndWaitForTransactionTree",
      requestType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.class,
      responseType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse> getSubmitAndWaitForTransactionTreeMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse> getSubmitAndWaitForTransactionTreeMethod;
    if ((getSubmitAndWaitForTransactionTreeMethod = CommandServiceGrpc.getSubmitAndWaitForTransactionTreeMethod) == null) {
      synchronized (CommandServiceGrpc.class) {
        if ((getSubmitAndWaitForTransactionTreeMethod = CommandServiceGrpc.getSubmitAndWaitForTransactionTreeMethod) == null) {
          CommandServiceGrpc.getSubmitAndWaitForTransactionTreeMethod = getSubmitAndWaitForTransactionTreeMethod = 
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "com.daml.ledger.api.v1.CommandService", "SubmitAndWaitForTransactionTree"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new CommandServiceMethodDescriptorSupplier("SubmitAndWaitForTransactionTree"))
                  .build();
          }
        }
     }
     return getSubmitAndWaitForTransactionTreeMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static CommandServiceStub newStub(io.grpc.Channel channel) {
    return new CommandServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static CommandServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new CommandServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static CommandServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new CommandServiceFutureStub(channel);
  }

  /**
   * <pre>
   * Command Service is able to correlate submitted commands with completion data, identify timeouts, and return contextual
   * information with each tracking result. This supports the implementation of stateless clients.
   * </pre>
   */
  public static abstract class CommandServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Submits a single composite command and waits for its result.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public void submitAndWait(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncUnimplementedUnaryCall(getSubmitAndWaitMethod(), responseObserver);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction id.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public void submitAndWaitForTransactionId(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getSubmitAndWaitForTransactionIdMethod(), responseObserver);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public void submitAndWaitForTransaction(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getSubmitAndWaitForTransactionMethod(), responseObserver);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction tree.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public void submitAndWaitForTransactionTree(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getSubmitAndWaitForTransactionTreeMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getSubmitAndWaitMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
                com.google.protobuf.Empty>(
                  this, METHODID_SUBMIT_AND_WAIT)))
          .addMethod(
            getSubmitAndWaitForTransactionIdMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse>(
                  this, METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION_ID)))
          .addMethod(
            getSubmitAndWaitForTransactionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse>(
                  this, METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION)))
          .addMethod(
            getSubmitAndWaitForTransactionTreeMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse>(
                  this, METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION_TREE)))
          .build();
    }
  }

  /**
   * <pre>
   * Command Service is able to correlate submitted commands with completion data, identify timeouts, and return contextual
   * information with each tracking result. This supports the implementation of stateless clients.
   * </pre>
   */
  public static final class CommandServiceStub extends io.grpc.stub.AbstractStub<CommandServiceStub> {
    private CommandServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private CommandServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CommandServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new CommandServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Submits a single composite command and waits for its result.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public void submitAndWait(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSubmitAndWaitMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction id.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public void submitAndWaitForTransactionId(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSubmitAndWaitForTransactionIdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public void submitAndWaitForTransaction(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSubmitAndWaitForTransactionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction tree.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public void submitAndWaitForTransactionTree(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSubmitAndWaitForTransactionTreeMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Command Service is able to correlate submitted commands with completion data, identify timeouts, and return contextual
   * information with each tracking result. This supports the implementation of stateless clients.
   * </pre>
   */
  public static final class CommandServiceBlockingStub extends io.grpc.stub.AbstractStub<CommandServiceBlockingStub> {
    private CommandServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private CommandServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CommandServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new CommandServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Submits a single composite command and waits for its result.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public com.google.protobuf.Empty submitAndWait(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return blockingUnaryCall(
          getChannel(), getSubmitAndWaitMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction id.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse submitAndWaitForTransactionId(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return blockingUnaryCall(
          getChannel(), getSubmitAndWaitForTransactionIdMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse submitAndWaitForTransaction(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return blockingUnaryCall(
          getChannel(), getSubmitAndWaitForTransactionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction tree.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse submitAndWaitForTransactionTree(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return blockingUnaryCall(
          getChannel(), getSubmitAndWaitForTransactionTreeMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Command Service is able to correlate submitted commands with completion data, identify timeouts, and return contextual
   * information with each tracking result. This supports the implementation of stateless clients.
   * </pre>
   */
  public static final class CommandServiceFutureStub extends io.grpc.stub.AbstractStub<CommandServiceFutureStub> {
    private CommandServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private CommandServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CommandServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new CommandServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Submits a single composite command and waits for its result.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.protobuf.Empty> submitAndWait(
        com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getSubmitAndWaitMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction id.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse> submitAndWaitForTransactionId(
        com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getSubmitAndWaitForTransactionIdMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse> submitAndWaitForTransaction(
        com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getSubmitAndWaitForTransactionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction tree.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``RESOURCE_EXHAUSTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse> submitAndWaitForTransactionTree(
        com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getSubmitAndWaitForTransactionTreeMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_SUBMIT_AND_WAIT = 0;
  private static final int METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION_ID = 1;
  private static final int METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION = 2;
  private static final int METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION_TREE = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final CommandServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(CommandServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_SUBMIT_AND_WAIT:
          serviceImpl.submitAndWait((com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        case METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION_ID:
          serviceImpl.submitAndWaitForTransactionId((com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse>) responseObserver);
          break;
        case METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION:
          serviceImpl.submitAndWaitForTransaction((com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse>) responseObserver);
          break;
        case METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION_TREE:
          serviceImpl.submitAndWaitForTransactionTree((com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class CommandServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    CommandServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.CommandServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("CommandService");
    }
  }

  private static final class CommandServiceFileDescriptorSupplier
      extends CommandServiceBaseDescriptorSupplier {
    CommandServiceFileDescriptorSupplier() {}
  }

  private static final class CommandServiceMethodDescriptorSupplier
      extends CommandServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    CommandServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (CommandServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new CommandServiceFileDescriptorSupplier())
              .addMethod(getSubmitAndWaitMethod())
              .addMethod(getSubmitAndWaitForTransactionIdMethod())
              .addMethod(getSubmitAndWaitForTransactionMethod())
              .addMethod(getSubmitAndWaitForTransactionTreeMethod())
              .build();
        }
      }
    }
    return result;
  }
}
