/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.conf;

import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.conf.EP;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class EPGroup
implements Serializable {
    private static ILogger log = LogFactory.getLog(EPGroup.class);
    public String name;
    public List<EP> epList = null;
    public DmProperties props;
    public static final int RECONNECT_OFF = 0;
    public static final int RECONNECT_CONN_ERROR = 1;
    public static final int RECONNECT_HEAD_FIRST = 2;
    public static final int RECONNECT_LOAD_BALANCE = 4;
    public static final int RECONNECT_LOAD_BALANCE_AND_CONN_ERROR = 5;
    public static final int RECONNECT_HEAD_FIRST_AND_CONN_ERROR = 3;
    public int reconnect = Configuration.reconnect.getDefault();
    public int switchTimes = Configuration.switchTimes.getDefault();
    public int switchInterval = Configuration.switchInterval.getDefault();
    public int checkFreq = Configuration.checkFreq.getDefault();
    public int allowRange = Configuration.allowRange.getDefault();
    public static final int LOGIN_MODE_PRIMARY_FIRST = 0;
    public static final int LOGIN_MODE_PRIMARY_ONLY = 1;
    public static final int LOGIN_MODE_STANDBY_ONLY = 2;
    public static final int LOGIN_MODE_STANDBY_FIRST = 3;
    public static final int LOGIN_MODE_NORMAL_FIRST = 4;
    public int loginMode = Configuration.loginMode.getDefault();
    public static final int LOGIN_STATUS_OFF = 0;
    public static final int LOGIN_STATUS_OPEN = 4;
    public static final int LOGIN_STATUS_MOUNT = 3;
    public static final int LOGIN_STATUS_SUSPEND = 5;
    public int loginStatus = Configuration.loginStatus.getDefault();
    public boolean loginDscCtrl = Configuration.loginDscCtrl.getDefault();
    public static final int CLUSTER_NORMAL = 0;
    public static final int CLUSTER_RW = 1;
    public static final int CLUSTER_DW = 2;
    public static final int CLUSTER_DSC = 3;
    public static final int CLUSTER_MPP = 4;
    public static final int CLUSTER_DPC = 5;
    public int cluster = Configuration.cluster.getDefault();
    public EPSelector epSelector = null;
    public String user;
    public String password;
    public AtomicLong sessions = new AtomicLong(0L);
    public long checkTime = 0L;

    public EPGroup(String name, List<EP> serverList) {
        this.name = name;
        this.epList = serverList;
    }

    public EPGroup setAttributes(DmProperties props) {
        int n2 = this.cluster = props.getInt(Configuration.rwSeparate) != 0 ? 1 : this.cluster;
        if (this.cluster == 1) {
            this.loginMode = 1;
            this.loginStatus = 4;
            this.reconnect = 1;
        }
        if (props.contains(Configuration.user)) {
            this.user = props.getProperty(Configuration.user.getName());
        }
        if (props.contains(Configuration.password)) {
            this.password = props.getProperty(Configuration.password.getName());
        }
        if (props.contains(Configuration.cluster)) {
            this.cluster = Configuration.parseCluster(props);
        }
        if (props.contains(Configuration.loginMode)) {
            this.loginMode = props.getInt(Configuration.loginMode);
        }
        if (props.contains(Configuration.loginStatus)) {
            this.loginStatus = props.getInt(Configuration.loginStatus);
        }
        if (props.contains(Configuration.loginDscCtrl)) {
            this.loginDscCtrl = props.getBoolean(Configuration.loginDscCtrl);
        }
        if (props.contains(Configuration.switchTimes)) {
            this.switchTimes = props.getInt(Configuration.switchTimes);
        }
        if (props.contains(Configuration.switchInterval)) {
            this.switchInterval = props.getMilliSecond(Configuration.switchInterval);
        }
        if (props.contains(Configuration.reconnect)) {
            this.reconnect = props.getInt(Configuration.reconnect);
        }
        if (props.contains(Configuration.checkFreq)) {
            this.checkFreq = props.getMilliSecond(Configuration.checkFreq);
        }
        if (props.contains(Configuration.allowRange)) {
            this.allowRange = props.getInt(Configuration.allowRange);
        }
        int selectorType = props.getInt(Configuration.epSelector);
        if (this.epSelector == null || selectorType != this.epSelector.type) {
            switch (selectorType) {
                case 0: {
                    this.epSelector = new WellDistributeSelector(this);
                    break;
                }
                case 1: {
                    this.epSelector = new HeadFirstSelector(this);
                }
            }
        }
        return this;
    }

    public String toString() {
        return String.valueOf(this.name) + "=(" + Arrays.toString(this.epList.toArray()) + ")";
    }

    public void connect(DmdbConnection conn) throws SQLException {
        EP[] eps = this.epSelector.start();
        SQLException ex = null;
        int cycleCount = this.epList.size() == 1 ? this.switchTimes : this.switchTimes + 1;
        int i2 = 0;
        while (i2 < cycleCount) {
            if (i2 != 0) {
                MiscUtil.sleep(this.switchInterval);
            }
            log.debug("try connect loop " + i2);
            try {
                this.epSelector.select(eps, conn, i2 == 0, i2 == cycleCount - 1);
                this.sessions.incrementAndGet();
                return;
            }
            catch (SQLException e2) {
                ex = e2;
                if (e2.getErrorCode() != DBError.ECJDBC_COMMUNITION_ERROR.errCode && e2.getErrorCode() != DBError.ECJDBC_INVALID_SERVER_MODE.errCode) break;
                ++i2;
            }
        }
        throw ex;
    }

    public void connect(DmdbConnection conn, int epSeqno) throws SQLException {
        EP dest = null;
        for (EP ep : this.epList) {
            if (ep.epSeqno != epSeqno) continue;
            dest = ep;
            break;
        }
        if (dest == null) {
            log.warn("try connect invalid epSeqno: " + epSeqno);
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(new Object[0]);
        }
        log.debug("try connect EP num: " + epSeqno + " [" + dest.host + ":" + dest.port + "]");
        dest.connect(conn);
    }

    public void connect(DmdbConnection conn, String host, int port) throws SQLException {
        EP dest = null;
        for (EP ep : this.epList) {
            if (!StringUtil.equals(ep.host, host) || ep.port != port) continue;
            dest = ep;
            break;
        }
        if (dest == null) {
            dest = new EP(host, port);
        }
        log.debug("try connect EP : [" + host + ":" + port + "]");
        dest.connect(conn);
    }

    public void incrementSession(DmdbConnection conn) {
        this.sessions.incrementAndGet();
    }

    public void decrementSession(DmdbConnection conn) {
        this.sessions.decrementAndGet();
    }

    public boolean isReconnectWhenError() {
        return (this.reconnect & 1) != 0;
    }

    public static abstract class EPSelector {
        public static final int TYPE_WELL_DISTRIBUTE = 0;
        public static final int TYPE_HEAD_FIRST = 1;
        public EPGroup group;
        public int type = -1;

        public EPSelector(EPGroup group, int type) {
            this.group = group;
            this.type = type;
        }

        public abstract EP[] start();

        public abstract void beforeSelect(EP[] var1, boolean var2) throws SQLException;

        public void select(EP[] eps, DmdbConnection conn, boolean firstTime, boolean lastTime) throws SQLException {
            int n2;
            this.beforeSelect(eps, firstTime);
            StringBuilder errorMsg = new StringBuilder();
            SQLException firstEx = null;
            if (lastTime && !firstTime) {
                boolean hasAlive = false;
                EP[] ePArray = eps;
                int n3 = eps.length;
                n2 = 0;
                while (n2 < n3) {
                    EP ep = ePArray[n2];
                    if (ep.alive) {
                        hasAlive = true;
                        break;
                    }
                    ++n2;
                }
                if (!hasAlive) {
                    DBError.ECJDBC_COMMUNITION_ERROR.throwz(new Object[0]);
                    return;
                }
            }
            EP[] ePArray = eps;
            n2 = eps.length;
            int n4 = 0;
            while (n4 < n2) {
                EP ep = ePArray[n4];
                try {
                    ep.connect(conn);
                    if (!this.checkServerMode(lastTime, conn)) {
                        conn.free();
                        DBError.ECJDBC_INVALID_SERVER_MODE.throwz(new Object[0]);
                    }
                    log.debug("try connect success [" + conn.host + ":" + conn.port + "]");
                    return;
                }
                catch (SQLException e2) {
                    if (firstEx == null) {
                        firstEx = e2;
                    }
                    errorMsg.append("[").append(ep.toString()).append("]").append(e2.getMessage()).append(StringUtil.LINE_SEPARATOR);
                    log.debug("try connect fail [" + ep.toString() + "] " + e2.getMessage());
                    if (e2.getErrorCode() != DBError.ECJDBC_COMMUNITION_ERROR.errCode && e2.getErrorCode() != DBError.ECJDBC_INVALID_SERVER_MODE.errCode) break;
                    ++n4;
                }
            }
            if (firstEx != null) {
                throw firstEx;
            }
            DBError.throwException(errorMsg.toString(), DBError.ECJDBC_COMMUNITION_ERROR.errCode);
        }

        public boolean checkServerMode(boolean lastTime, DmdbConnection conn) throws SQLException {
            if (this.group.loginDscCtrl && !conn.dscControl) {
                conn.free();
                DBError.ECJDBC_INVALID_SERVER_MODE.throwz(new Object[0]);
            }
            if (this.group.loginStatus > 0 && conn.svrStat != this.group.loginStatus) {
                conn.free();
                DBError.ECJDBC_INVALID_SERVER_MODE.throwz(new Object[0]);
            }
            if (lastTime) {
                switch (this.group.loginMode) {
                    case 1: {
                        return conn.svrMode == 1;
                    }
                    case 2: {
                        return conn.svrMode == 2;
                    }
                }
                return true;
            }
            switch (this.group.loginMode) {
                case 4: {
                    return conn.svrMode == 0;
                }
                case 0: 
                case 1: {
                    return conn.svrMode == 1;
                }
                case 2: 
                case 3: {
                    return conn.svrMode == 2;
                }
            }
            return false;
        }
    }

    static class HeadFirstSelector
    extends EPSelector {
        public HeadFirstSelector(EPGroup group) {
            super(group, 1);
        }

        @Override
        public EP[] start() {
            return this.group.epList.toArray(new EP[0]);
        }

        @Override
        public void beforeSelect(EP[] eps, boolean firstTime) throws SQLException {
        }

        @Override
        public boolean checkServerMode(boolean lastTime, DmdbConnection conn) throws SQLException {
            if (!lastTime && conn.ep != this.group.epList.get(0)) {
                return false;
            }
            return super.checkServerMode(lastTime, conn);
        }
    }

    static class WellDistributeSelector
    extends EPSelector {
        private int connectStartPos = -1;
        public ReentrantLock posLock = new ReentrantLock();
        static Comparator<EP> sortComparator = new Comparator<EP>(){

            @Override
            public int compare(EP o1, EP o2) {
                if (o1.sort > o2.sort) {
                    return -1;
                }
                if (o1.sort == o2.sort) {
                    return 0;
                }
                return 1;
            }
        };

        public WellDistributeSelector(EPGroup group) {
            super(group, 0);
            this.connectStartPos = group.epList == null || group.epList.size() == 0 ? -1 : new Random().nextInt(group.epList.size()) - 1;
        }

        @Override
        public EP[] start() {
            int serverCount = this.group.epList.size();
            EP[] sortEps = new EP[serverCount];
            int pos = 0;
            try {
                this.posLock.lock();
                pos = this.connectStartPos = (this.connectStartPos + 1) % serverCount;
            }
            finally {
                this.posLock.unlock();
            }
            int i2 = 0;
            while (i2 < serverCount) {
                sortEps[i2] = this.group.epList.get((i2 + pos) % serverCount);
                ++i2;
            }
            return sortEps;
        }

        @Override
        public void beforeSelect(EP[] eps, boolean firstTime) throws SQLException {
            if (!firstTime) {
                Arrays.sort(eps, sortComparator);
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.group.checkTime == 0L || currentTime - this.group.checkTime >= 20000L) {
                return;
            }
            Arrays.sort(eps, sortComparator);
        }
    }
}

