/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.conf;

import dm.jdbc.driver.Configuration;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.conf.EPGroup;
import dm.jdbc.internal.desc.Const;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.FileUtil;
import dm.jdbc.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DmSvcConf {
    public static DmSvcConf GLOBAL = null;
    public int dbAliveCheckFreq = 0;
    public int dbAliveCheckTimeout = 10000;
    public String markConf;
    public Locale locale = Locale.getDefault();
    public int logLevel = 0;
    public String logDir = DriverUtil.formatDir(System.getProperty("user.dir"));
    public int logFlushFreq = 30;
    public int logBufferSize = 32768;
    public boolean statEnable = false;
    public String statDir = DriverUtil.formatDir(System.getProperty("user.dir"));
    public int statFileType = Configuration.STAT_FILE_TYPE_CSV;
    public int statFlushFreq = 30;
    public int statSlowSqlCount = 100;
    public int statHighFreqSqlCount = 100;
    public int statSqlMaxCount = 100000;
    public int statSqlRemoveMode = Configuration.STAT_SQL_REMOVE_LATEST;
    public ConcurrentHashMap<String, EPGroup> serverGroupMap = new ConcurrentHashMap();
    public DmProperties props = new DmProperties();
    public String filePath = "";
    private long lastModified;

    static {
        String filePath = null;
        if (System.getProperty("os.name").startsWith("Win")) {
            String strVersion = System.getProperty("java.version");
            filePath = !strVersion.contains("1.4") ? System.getenv("SystemRoot") : "C:\\WINDOWS";
            filePath = String.valueOf(filePath) + "\\system32\\dm_svc.conf";
        } else {
            filePath = "/etc/dm_svc.conf";
        }
        GLOBAL = DmSvcConf.load(filePath);
        if (GLOBAL == null) {
            GLOBAL = new DmSvcConf(filePath);
        }
    }

    public DmSvcConf(String filePath) {
        this.filePath = filePath;
        this.lastModified = FileUtil.lastModified(filePath);
    }

    public void setAttributes(DmProperties props) {
        if (props == null || props.size() == 0) {
            return;
        }
        this.locale = Configuration.parseLanguage(props);
        this.dbAliveCheckFreq = props.getMilliSecond(Configuration.dbAliveCheckFreq);
        this.dbAliveCheckTimeout = props.getMilliSecond(Configuration.dbAliveCheckTimeout);
        this.markConf = props.getTrimString(Configuration.markConf);
        this.logLevel = Configuration.parseLogLevel(props);
        this.logDir = DriverUtil.formatDir(props.getTrimString(Configuration.logDir));
        this.logBufferSize = props.getInt(Configuration.logBufferSize);
        this.logFlushFreq = props.getSecond(Configuration.logFlushFreq);
        this.statEnable = props.getBoolean(Configuration.statEnable);
        this.statDir = DriverUtil.formatDir(props.getTrimString(Configuration.statDir));
        this.statFileType = Configuration.parseStatFileType(props);
        this.statFlushFreq = props.getSecond(Configuration.statFlushFreq);
        this.statHighFreqSqlCount = props.getInt(Configuration.statHighFreqSqlCount);
        this.statSlowSqlCount = props.getInt(Configuration.statSlowSqlCount);
        this.statSqlMaxCount = props.getInt(Configuration.statSqlMaxCount);
        this.statSqlRemoveMode = Configuration.parseStatSqlRemoveMode(props);
    }

    public int getLanguage() {
        return Const.j2dbLanguage(this.locale);
    }

    public EPGroup getDBGroup(String svrGroupName) {
        if (StringUtil.isNotEmpty(svrGroupName) && this.serverGroupMap.containsKey(svrGroupName.toLowerCase())) {
            return this.serverGroupMap.get(svrGroupName.toLowerCase());
        }
        return null;
    }

    public boolean compatibleOracle() {
        int compatibleMode = Configuration.parseCompatibleMode(DmSvcConf.GLOBAL.props);
        return (compatibleMode & 1) != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DmSvcConf load(String filePath) {
        DmSvcConf dmsvcconf;
        block25: {
            if (StringUtil.isEmpty(filePath)) {
                return null;
            }
            BufferedReader m_bufdReader = null;
            try {
                File file = new File(filePath);
                if (file.isDirectory()) {
                    filePath = String.valueOf(file.getAbsolutePath()) + File.separator + "dm_svc.conf";
                }
                m_bufdReader = new BufferedReader(new FileReader(filePath));
            }
            catch (Throwable throwable) {}
            if (m_bufdReader == null) {
                return null;
            }
            dmsvcconf = new DmSvcConf(filePath);
            DmProperties serverGroupProps = null;
            try {
                try {
                    String line;
                    while ((line = m_bufdReader.readLine()) != null) {
                        int notesIndex = -1;
                        notesIndex = line.indexOf("#");
                        if (notesIndex != -1) {
                            line = line.substring(0, notesIndex);
                        }
                        if ((notesIndex = line.indexOf("//")) != -1) {
                            line = line.substring(0, notesIndex);
                        }
                        if (StringUtil.isEmpty(line = StringUtil.trimToEmpty(line))) continue;
                        if (line.startsWith("[") && line.endsWith("]")) {
                            String groupName = StringUtil.trimToEmpty(line.substring(1, line.length() - 1)).toLowerCase();
                            if (StringUtil.isEmpty(groupName) || !dmsvcconf.serverGroupMap.containsKey(groupName) || (serverGroupProps = dmsvcconf.serverGroupMap.get((Object)groupName).props) != null) continue;
                            dmsvcconf.serverGroupMap.get((Object)groupName).props = serverGroupProps = new DmProperties(dmsvcconf.props);
                            continue;
                        }
                        try {
                            EPGroup serverGroup;
                            String[] cfgInfo = line.split("=");
                            if (cfgInfo.length < 2) continue;
                            String name = StringUtil.trimToEmpty(cfgInfo[0]);
                            String value = StringUtil.trimToEmpty(cfgInfo[1]);
                            if (value.startsWith("(") && value.endsWith(")")) {
                                value = StringUtil.trimToEmpty(value.substring(1, value.length() - 1));
                            }
                            if (StringUtil.isEmpty(name) || StringUtil.isEmpty(value) || dmsvcconf.setServerGroupProperties(serverGroupProps == null ? dmsvcconf.props : serverGroupProps, name, value) || (serverGroup = Configuration.parseEpGroup(name, value)) == null) continue;
                            dmsvcconf.serverGroupMap.put(name.toLowerCase(), serverGroup);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException iOException) {
                    try {
                        m_bufdReader.close();
                    }
                    catch (IOException iOException2) {}
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    m_bufdReader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                m_bufdReader.close();
            }
            catch (IOException iOException) {}
        }
        for (Map.Entry<String, EPGroup> group : dmsvcconf.serverGroupMap.entrySet()) {
            if (group.getValue().props == null) {
                group.getValue().props = new DmProperties(dmsvcconf.props);
            }
            group.getValue().setAttributes(group.getValue().props);
        }
        return dmsvcconf;
    }

    private boolean setServerGroupProperties(DmProperties props, String name, String value) {
        Configuration info = Configuration.valueOf(name);
        if (info == null) {
            return false;
        }
        if (info == Configuration.addressRemap || info == Configuration.userRemap) {
            String has = props.getProperty(info.getName());
            value = StringUtil.isNotEmpty(has) ? String.valueOf(has) + "&(" + value + ")" : "(" + value + ")";
        }
        props.setProperty(info.getName(), value);
        return true;
    }

    public synchronized void reload() {
        long modified = FileUtil.lastModified(this.filePath);
        if (this.lastModified > 0L && this.lastModified >= modified) {
            return;
        }
        this.lastModified = modified;
        DmSvcConf newConfig = DmSvcConf.load(this.filePath);
        if (newConfig == null) {
            return;
        }
        this.props = newConfig.props;
        this.setAttributes(this.props);
        for (Map.Entry<String, EPGroup> element : newConfig.serverGroupMap.entrySet()) {
            if (!this.serverGroupMap.containsKey(element.getKey())) {
                this.serverGroupMap.put(element.getKey(), element.getValue());
                continue;
            }
            EPGroup newEpGroup = element.getValue();
            EPGroup oldEpGroup = this.serverGroupMap.get(element.getKey());
            oldEpGroup.epList = newEpGroup.epList;
            oldEpGroup.props = newEpGroup.props;
            oldEpGroup.setAttributes(newEpGroup.props);
        }
    }

    public static void main(String[] args) {
        DmSvcConf config = DmSvcConf.load("d:\\dm_svc.conf");
        System.out.println(config);
        System.out.println(config.getLanguage());
    }
}

