/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat.util;

import dm.jdbc.filter.stat.util.JSONUtils;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CsvFormator {
    public static void main(String[] args) {
        String[] titles;
        String[] fields = titles = new String[]{"ID", "SQL", "DESC"};
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put(fields[0], "123");
        obj.put(fields[1], "select \r\n1    from \"dual\";");
        obj.put(fields[2], "\u8fbe\u68a6\u6570\u636e\u5e93");
        ArrayList<Map<String, Object>> objList = new ArrayList<Map<String, Object>>();
        objList.add(obj);
        CsvFormator.addTitles(objList, titles, fields);
        System.out.println(CsvFormator.toTable(objList, fields, null, true, false));
    }

    public static void addTitles(List<Map<String, Object>> objList, String[] titles, String[] fields) {
        HashMap<String, String> titleMap = new HashMap<String, String>(fields.length);
        int i2 = 0;
        while (i2 < fields.length) {
            titleMap.put(fields[i2], titles[i2]);
            ++i2;
        }
        objList.add(0, titleMap);
    }

    public static String toTable(List<Map<String, Object>> objList, String[] fields, int[] colLens, boolean showAll, boolean append) {
        if (fields == null || objList == null) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        if (!append) {
            output.append(StringUtil.LINE_SEPARATOR);
        }
        for (Map<String, Object> obj : objList) {
            Map<String, Object> objMore = obj;
            if (objMore == null) continue;
            CsvFormator.formateLine(output, objMore, fields, colLens, showAll);
            output.append(StringUtil.LINE_SEPARATOR);
        }
        return output.toString();
    }

    private static void formateLine(StringBuilder output, Map obj, String[] fields, int[] colLens, boolean showAll) {
        int i2 = 0;
        while (i2 < fields.length) {
            if (i2 != 0) {
                output.append(",");
            }
            output.append("\"" + StringUtil.processDoubleQuoteOfName(CsvFormator.getColValue(obj.get(fields[i2]))) + "\"");
            ++i2;
        }
    }

    private static String getColValue(Object colObj) {
        String colVal = colObj == null ? "null" : (colObj.getClass().isArray() ? JSONUtils.toJSONString(colObj) : colObj.toString());
        colVal = colVal.replace('\t', ' ');
        colVal = colVal.replace('\n', ' ');
        colVal = colVal.replace('\r', ' ');
        return colVal;
    }
}

