/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter;

import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbXAResource;
import dm.jdbc.filter.Filter;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.processor.DeamonThreadFactory;
import dm.jdbc.plugin.fldr.FldrConfig;
import dm.jdbc.plugin.fldr.FldrStatement;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.RowIdLifetime;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class BaseFilter
implements Filter {
    protected static ExecutorService executor = Executors.newCachedThreadPool(new DeamonThreadFactory());

    public static <T> boolean doTaskParallel(T[] list, final FilterCallback<T> callback) throws SQLException {
        if (list == null || list.length == 0) {
            return false;
        }
        int count = list.length;
        CountDownLatch countDownLatch = new CountDownLatch(count);
        FilterTask[] tasks = new FilterTask[count];
        int i2 = 0;
        T[] TArray = list;
        int n2 = list.length;
        int n3 = 0;
        while (n3 < n2) {
            final T siteObj = TArray[n3];
            tasks[i2] = new FilterTask(countDownLatch){

                @Override
                protected void doTask() throws SQLException {
                    if (siteObj == null) {
                        return;
                    }
                    callback.run(siteObj);
                }
            };
            executor.submit(tasks[i2]);
            ++i2;
            ++n3;
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {}
        boolean success = true;
        FilterTask[] filterTaskArray = tasks;
        int n4 = tasks.length;
        n2 = 0;
        while (n2 < n4) {
            FilterTask task = filterTaskArray[n2];
            if (!task.isSuccess()) {
                if (task.getError() != null) {
                    throw task.getError();
                }
                success = false;
                break;
            }
            ++n2;
        }
        return success;
    }

    @Override
    public long Blob_length(FilterChain filterChain, DmdbBlob blob) throws SQLException {
        return filterChain.Blob_length(blob);
    }

    @Override
    public byte[] Blob_getBytes(FilterChain filterChain, DmdbBlob blob, long pos, int length) throws SQLException {
        return filterChain.Blob_getBytes(blob, pos, length);
    }

    @Override
    public InputStream Blob_getBinaryStream(FilterChain filterChain, DmdbBlob blob) throws SQLException {
        return filterChain.Blob_getBinaryStream(blob);
    }

    @Override
    public long Blob_position(FilterChain filterChain, DmdbBlob blob, byte[] pattern, long start) throws SQLException {
        return filterChain.Blob_position(blob, pattern, start);
    }

    @Override
    public long Blob_position(FilterChain filterChain, DmdbBlob blob, Blob pattern, long start) throws SQLException {
        return filterChain.Blob_position(blob, pattern, start);
    }

    @Override
    public int Blob_setBytes(FilterChain filterChain, DmdbBlob blob, long pos, byte[] bytes) throws SQLException {
        return filterChain.Blob_setBytes(blob, pos, bytes);
    }

    @Override
    public int Blob_setBytes(FilterChain filterChain, DmdbBlob blob, long pos, byte[] bytes, int offset, int len) throws SQLException {
        return filterChain.Blob_setBytes(blob, pos, bytes, offset, len);
    }

    @Override
    public OutputStream Blob_setBinaryStream(FilterChain filterChain, DmdbBlob blob, long pos) throws SQLException {
        return filterChain.Blob_setBinaryStream(blob, pos);
    }

    @Override
    public void Blob_truncate(FilterChain filterChain, DmdbBlob blob, long len) throws SQLException {
        filterChain.Blob_truncate(blob, len);
    }

    @Override
    public void Blob_free(FilterChain filterChain, DmdbBlob blob) throws SQLException {
        filterChain.Blob_free(blob);
    }

    @Override
    public InputStream Blob_getBinaryStream(FilterChain filterChain, DmdbBlob blob, long pos, long length) throws SQLException {
        return filterChain.Blob_getBinaryStream(blob, pos, length);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType) throws SQLException {
        filterChain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, int scale) throws SQLException {
        filterChain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, scale);
    }

    @Override
    public boolean CallableStatement_wasNull(FilterChain filterChain, DmdbCallableStatement callableStatement) throws SQLException {
        return filterChain.CallableStatement_wasNull(callableStatement);
    }

    @Override
    public String CallableStatement_getString(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getString(callableStatement, parameterIndex);
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getBoolean(callableStatement, parameterIndex);
    }

    @Override
    public byte CallableStatement_getByte(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getByte(callableStatement, parameterIndex);
    }

    @Override
    public short CallableStatement_getShort(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getShort(callableStatement, parameterIndex);
    }

    @Override
    public int CallableStatement_getInt(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getInt(callableStatement, parameterIndex);
    }

    @Override
    public long CallableStatement_getLong(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getLong(callableStatement, parameterIndex);
    }

    @Override
    public float CallableStatement_getFloat(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getFloat(callableStatement, parameterIndex);
    }

    @Override
    public double CallableStatement_getDouble(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getDouble(callableStatement, parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int scale) throws SQLException {
        return filterChain.CallableStatement_getBigDecimal(callableStatement, parameterIndex, scale);
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getBytes(callableStatement, parameterIndex);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getDate(callableStatement, parameterIndex);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getTime(callableStatement, parameterIndex);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getTimestamp(callableStatement, parameterIndex);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getObject(callableStatement, parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getBigDecimal(callableStatement, parameterIndex);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return filterChain.CallableStatement_getObject(callableStatement, parameterIndex, map);
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getRef(callableStatement, parameterIndex);
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getBlob(callableStatement, parameterIndex);
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getClob(callableStatement, parameterIndex);
    }

    @Override
    public Array CallableStatement_getArray(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getArray(callableStatement, parameterIndex);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return filterChain.CallableStatement_getDate(callableStatement, parameterIndex, cal);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return filterChain.CallableStatement_getTime(callableStatement, parameterIndex, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return filterChain.CallableStatement_getTimestamp(callableStatement, parameterIndex, cal);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        filterChain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, typeName);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        filterChain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, int scale) throws SQLException {
        filterChain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        filterChain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, typeName);
    }

    @Override
    public URL CallableStatement_getURL(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getURL(callableStatement, parameterIndex);
    }

    @Override
    public void CallableStatement_setURL(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, URL val) throws SQLException {
        filterChain.CallableStatement_setURL(callableStatement, parameterName, val);
    }

    @Override
    public void CallableStatement_setNull(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        filterChain.CallableStatement_setNull(callableStatement, parameterName, sqlType);
    }

    @Override
    public void CallableStatement_setBoolean(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, boolean x2) throws SQLException {
        filterChain.CallableStatement_setBoolean(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setByte(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, byte x2) throws SQLException {
        filterChain.CallableStatement_setByte(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setShort(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, short x2) throws SQLException {
        filterChain.CallableStatement_setShort(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setInt(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int x2) throws SQLException {
        filterChain.CallableStatement_setInt(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setLong(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, long x2) throws SQLException {
        filterChain.CallableStatement_setLong(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setFloat(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, float x2) throws SQLException {
        filterChain.CallableStatement_setFloat(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setDouble(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, double x2) throws SQLException {
        filterChain.CallableStatement_setDouble(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, BigDecimal x2) throws SQLException {
        filterChain.CallableStatement_setBigDecimal(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, String x2) throws SQLException {
        filterChain.CallableStatement_setString(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBytes(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, byte[] x2) throws SQLException {
        filterChain.CallableStatement_setBytes(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Date x2) throws SQLException {
        filterChain.CallableStatement_setDate(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Time x2) throws SQLException {
        filterChain.CallableStatement_setTime(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Timestamp x2) throws SQLException {
        filterChain.CallableStatement_setTimestamp(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        filterChain.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        filterChain.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        filterChain.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scale);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType) throws SQLException {
        filterChain.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2) throws SQLException {
        filterChain.CallableStatement_setObject(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, int length) throws SQLException {
        filterChain.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Date x2, Calendar cal) throws SQLException {
        filterChain.CallableStatement_setDate(callableStatement, parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Time x2, Calendar cal) throws SQLException {
        filterChain.CallableStatement_setTime(callableStatement, parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        filterChain.CallableStatement_setTimestamp(callableStatement, parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setNull(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        filterChain.CallableStatement_setNull(callableStatement, parameterName, sqlType, typeName);
    }

    @Override
    public String CallableStatement_getString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getString(callableStatement, parameterName);
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getBoolean(callableStatement, parameterName);
    }

    @Override
    public byte CallableStatement_getByte(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getByte(callableStatement, parameterName);
    }

    @Override
    public short CallableStatement_getShort(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getShort(callableStatement, parameterName);
    }

    @Override
    public int CallableStatement_getInt(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getInt(callableStatement, parameterName);
    }

    @Override
    public long CallableStatement_getLong(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getLong(callableStatement, parameterName);
    }

    @Override
    public float CallableStatement_getFloat(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getFloat(callableStatement, parameterName);
    }

    @Override
    public double CallableStatement_getDouble(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getDouble(callableStatement, parameterName);
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getBytes(callableStatement, parameterName);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getDate(callableStatement, parameterName);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getTime(callableStatement, parameterName);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getTimestamp(callableStatement, parameterName);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getObject(callableStatement, parameterName);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getBigDecimal(callableStatement, parameterName);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Map<String, Class<?>> map) throws SQLException {
        return filterChain.CallableStatement_getObject(callableStatement, parameterName, map);
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getRef(callableStatement, parameterName);
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getBlob(callableStatement, parameterName);
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getClob(callableStatement, parameterName);
    }

    @Override
    public Array CallableStatement_getArray(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getArray(callableStatement, parameterName);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return filterChain.CallableStatement_getDate(callableStatement, parameterName, cal);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return filterChain.CallableStatement_getTime(callableStatement, parameterName, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return filterChain.CallableStatement_getTimestamp(callableStatement, parameterName, cal);
    }

    @Override
    public URL CallableStatement_getURL(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getURL(callableStatement, parameterName);
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getRowId(callableStatement, parameterIndex);
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getRowId(callableStatement, parameterName);
    }

    @Override
    public void CallableStatement_setRowId(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, RowId x2) throws SQLException {
        filterChain.CallableStatement_setRowId(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setNString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, String value) throws SQLException {
        filterChain.CallableStatement_setNString(callableStatement, parameterName, value);
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader value, long length) throws SQLException {
        filterChain.CallableStatement_setNCharacterStream(callableStatement, parameterName, value, length);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, NClob value) throws SQLException {
        filterChain.CallableStatement_setNClob(callableStatement, parameterName, value);
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        filterChain.CallableStatement_setClob(callableStatement, parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream, long length) throws SQLException {
        filterChain.CallableStatement_setBlob(callableStatement, parameterName, inputStream, length);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        filterChain.CallableStatement_setNClob(callableStatement, parameterName, reader, length);
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getNClob(callableStatement, parameterIndex);
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getNClob(callableStatement, parameterName);
    }

    @Override
    public void CallableStatement_setSQLXML(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLXML xmlObject) throws SQLException {
        filterChain.CallableStatement_setSQLXML(callableStatement, parameterName, xmlObject);
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getSQLXML(callableStatement, parameterIndex);
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getSQLXML(callableStatement, parameterName);
    }

    @Override
    public String CallableStatement_getNString(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getNString(callableStatement, parameterIndex);
    }

    @Override
    public String CallableStatement_getNString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getNString(callableStatement, parameterName);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getNCharacterStream(callableStatement, parameterIndex);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getNCharacterStream(callableStatement, parameterName);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getCharacterStream(callableStatement, parameterIndex);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getCharacterStream(callableStatement, parameterName);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Blob x2) throws SQLException {
        filterChain.CallableStatement_setBlob(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Clob x2) throws SQLException {
        filterChain.CallableStatement_setClob(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        filterChain.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        filterChain.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        filterChain.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        filterChain.CallableStatement_setAsciiStream(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        filterChain.CallableStatement_setBinaryStream(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        filterChain.CallableStatement_setCharacterStream(callableStatement, parameterName, reader);
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader value) throws SQLException {
        filterChain.CallableStatement_setNCharacterStream(callableStatement, parameterName, value);
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        filterChain.CallableStatement_setClob(callableStatement, parameterName, reader);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream) throws SQLException {
        filterChain.CallableStatement_setBlob(callableStatement, parameterName, inputStream);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        filterChain.CallableStatement_setNClob(callableStatement, parameterName, reader);
    }

    @Override
    public <T> T CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        return filterChain.CallableStatement_getObject(callableStatement, parameterIndex, type);
    }

    @Override
    public <T> T CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        return filterChain.CallableStatement_getObject(callableStatement, parameterName, type);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        filterChain.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType) throws SQLException {
        filterChain.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType) throws SQLException {
        filterChain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        filterChain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        filterChain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, typeName);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType) throws SQLException {
        filterChain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, int scale) throws SQLException {
        filterChain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, String typeName) throws SQLException {
        filterChain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, typeName);
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getINTERVALYM(callableStatement, parameterIndex);
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getINTERVALDT(callableStatement, parameterIndex);
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getTIMESTAMP(callableStatement, parameterIndex);
    }

    @Override
    public ResultSet CallableStatement_getCursor(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return filterChain.CallableStatement_getCursor(callableStatement, parameterIndex);
    }

    @Override
    public long Clob_length(FilterChain filterChain, DmdbClob clob) throws SQLException {
        return filterChain.Clob_length(clob);
    }

    @Override
    public String Clob_getSubString(FilterChain filterChain, DmdbClob clob, long pos, int length) throws SQLException {
        return filterChain.Clob_getSubString(clob, pos, length);
    }

    @Override
    public Reader Clob_getCharacterStream(FilterChain filterChain, DmdbClob clob) throws SQLException {
        return filterChain.Clob_getCharacterStream(clob);
    }

    @Override
    public InputStream Clob_getAsciiStream(FilterChain filterChain, DmdbClob clob) throws SQLException {
        return filterChain.Clob_getAsciiStream(clob);
    }

    @Override
    public long Clob_position(FilterChain filterChain, DmdbClob clob, String searchstr, long start) throws SQLException {
        return filterChain.Clob_position(clob, searchstr, start);
    }

    @Override
    public long Clob_position(FilterChain filterChain, DmdbClob clob, Clob searchstr, long start) throws SQLException {
        return filterChain.Clob_position(clob, searchstr, start);
    }

    @Override
    public int Clob_setString(FilterChain filterChain, DmdbClob clob, long pos, String str) throws SQLException {
        return filterChain.Clob_setString(clob, pos, str);
    }

    @Override
    public int Clob_setString(FilterChain filterChain, DmdbClob clob, long pos, String str, int offset, int len) throws SQLException {
        return filterChain.Clob_setString(clob, pos, str, offset, len);
    }

    @Override
    public OutputStream Clob_setAsciiStream(FilterChain filterChain, DmdbClob clob, long pos) throws SQLException {
        return filterChain.Clob_setAsciiStream(clob, pos);
    }

    @Override
    public Writer Clob_setCharacterStream(FilterChain filterChain, DmdbClob clob, long pos) throws SQLException {
        return filterChain.Clob_setCharacterStream(clob, pos);
    }

    @Override
    public void Clob_truncate(FilterChain filterChain, DmdbClob clob, long len) throws SQLException {
        filterChain.Clob_truncate(clob, len);
    }

    @Override
    public void Clob_free(FilterChain filterChain, DmdbClob clob) throws SQLException {
        filterChain.Clob_free(clob);
    }

    @Override
    public Reader Clob_getCharacterStream(FilterChain filterChain, DmdbClob clob, long pos, long length) throws SQLException {
        return filterChain.Clob_getCharacterStream(clob, pos, length);
    }

    @Override
    public void Connection_reconnect(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        filterChain.Connection_reconnect(connection);
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_createStatement(connection);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql) throws SQLException {
        return filterChain.Connection_prepareStatement(connection, sql);
    }

    @Override
    public FldrStatement Connection_fldrPrepareStatement(FilterChain filterChain, DmdbConnection connection, FldrConfig config) throws SQLException {
        return filterChain.Connection_fldrStatement(connection, config);
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection connection, String sql) throws SQLException {
        return filterChain.Connection_prepareCall(connection, sql);
    }

    @Override
    public String Connection_nativeSQL(FilterChain filterChain, DmdbConnection connection, String sql) throws SQLException {
        return filterChain.Connection_nativeSQL(connection, sql);
    }

    @Override
    public void Connection_setAutoCommit(FilterChain filterChain, DmdbConnection connection, boolean autoCommit) throws SQLException {
        filterChain.Connection_setAutoCommit(connection, autoCommit);
    }

    @Override
    public boolean Connection_getAutoCommit(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_getAutoCommit(connection);
    }

    @Override
    public void Connection_commit(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        filterChain.Connection_commit(connection);
    }

    @Override
    public void Connection_rollback(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        filterChain.Connection_rollback(connection);
    }

    @Override
    public void Connection_close(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        filterChain.Connection_close(connection);
    }

    @Override
    public boolean Connection_isClosed(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_isClosed(connection);
    }

    @Override
    public DatabaseMetaData Connection_getMetaData(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_getMetaData(connection);
    }

    @Override
    public void Connection_setReadOnly(FilterChain filterChain, DmdbConnection connection, boolean readOnly) throws SQLException {
        filterChain.Connection_setReadOnly(connection, readOnly);
    }

    @Override
    public boolean Connection_isReadOnly(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_isReadOnly(connection);
    }

    @Override
    public void Connection_setCatalog(FilterChain filterChain, DmdbConnection connection, String catalog) throws SQLException {
        filterChain.Connection_setCatalog(connection, catalog);
    }

    @Override
    public String Connection_getCatalog(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_getCatalog(connection);
    }

    @Override
    public void Connection_setTransactionIsolation(FilterChain filterChain, DmdbConnection connection, int level) throws SQLException {
        filterChain.Connection_setTransactionIsolation(connection, level);
    }

    @Override
    public int Connection_getTransactionIsolation(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_getTransactionIsolation(connection);
    }

    @Override
    public SQLWarning Connection_getWarnings(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_getWarnings(connection);
    }

    @Override
    public void Connection_clearWarnings(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        filterChain.Connection_clearWarnings(connection);
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        return filterChain.Connection_createStatement(connection, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return filterChain.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return filterChain.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> Connection_getTypeMap(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_getTypeMap(connection);
    }

    @Override
    public void Connection_setTypeMap(FilterChain filterChain, DmdbConnection connection, Map<String, Class<?>> map) throws SQLException {
        filterChain.Connection_setTypeMap(connection, map);
    }

    @Override
    public void Connection_setHoldability(FilterChain filterChain, DmdbConnection connection, int holdability) throws SQLException {
        filterChain.Connection_setHoldability(connection, holdability);
    }

    @Override
    public int Connection_getHoldability(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_getHoldability(connection);
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_setSavepoint(connection);
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain filterChain, DmdbConnection connection, String name) throws SQLException {
        return filterChain.Connection_setSavepoint(connection, name);
    }

    @Override
    public void Connection_rollback(FilterChain filterChain, DmdbConnection connection, Savepoint savepoint) throws SQLException {
        filterChain.Connection_rollback(connection, savepoint);
    }

    @Override
    public void Connection_releaseSavepoint(FilterChain filterChain, DmdbConnection connection, Savepoint savepoint) throws SQLException {
        filterChain.Connection_releaseSavepoint(connection, savepoint);
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return filterChain.Connection_createStatement(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return filterChain.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return filterChain.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        return filterChain.Connection_prepareStatement(connection, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, int[] columnIndexes) throws SQLException {
        return filterChain.Connection_prepareStatement(connection, sql, columnIndexes);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, String[] columnNames) throws SQLException {
        return filterChain.Connection_prepareStatement(connection, sql, columnNames);
    }

    @Override
    public Clob Connection_createClob(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_createClob(connection);
    }

    @Override
    public Blob Connection_createBlob(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_createBlob(connection);
    }

    @Override
    public NClob Connection_createNClob(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_createNClob(connection);
    }

    @Override
    public SQLXML Connection_createSQLXML(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_createSQLXML(connection);
    }

    @Override
    public boolean Connection_isValid(FilterChain filterChain, DmdbConnection connection, int timeout) throws SQLException {
        return filterChain.Connection_isValid(connection, timeout);
    }

    @Override
    public void Connection_setClientInfo(FilterChain filterChain, DmdbConnection connection, String name, String value) throws SQLClientInfoException {
        filterChain.Connection_setClientInfo(connection, name, value);
    }

    @Override
    public void Connection_setClientInfo(FilterChain filterChain, DmdbConnection connection, Properties properties) throws SQLClientInfoException {
        filterChain.Connection_setClientInfo(connection, properties);
    }

    @Override
    public String Connection_getClientInfo(FilterChain filterChain, DmdbConnection connection, String name) throws SQLException {
        return filterChain.Connection_getClientInfo(connection, name);
    }

    @Override
    public Properties Connection_getClientInfo(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_getClientInfo(connection);
    }

    @Override
    public Array Connection_createArrayOf(FilterChain filterChain, DmdbConnection connection, String typeName, Object[] elements) throws SQLException {
        return filterChain.Connection_createArrayOf(connection, typeName, elements);
    }

    @Override
    public Struct Connection_createStruct(FilterChain filterChain, DmdbConnection connection, String typeName, Object[] attributes) throws SQLException {
        return filterChain.Connection_createStruct(connection, typeName, attributes);
    }

    @Override
    public void Connection_setSchema(FilterChain filterChain, DmdbConnection connection, String schema) throws SQLException {
        filterChain.Connection_setSchema(connection, schema);
    }

    @Override
    public String Connection_getSchema(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_getSchema(connection);
    }

    @Override
    public void Connection_abort(FilterChain filterChain, DmdbConnection connection, Executor executor) throws SQLException {
        filterChain.Connection_abort(connection, executor);
    }

    @Override
    public void Connection_setNetworkTimeout(FilterChain filterChain, DmdbConnection connection, Executor executor, int milliseconds) throws SQLException {
        filterChain.Connection_setNetworkTimeout(connection, executor, milliseconds);
    }

    @Override
    public int Connection_getNetworkTimeout(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_getNetworkTimeout(connection);
    }

    @Override
    public boolean DatabaseMetaData_allProceduresAreCallable(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_allProceduresAreCallable(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_allTablesAreSelectable(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_allTablesAreSelectable(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getURL(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getURL(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getUserName(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getUserName(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_isReadOnly(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_isReadOnly(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedHigh(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_nullsAreSortedHigh(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedLow(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_nullsAreSortedLow(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtStart(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_nullsAreSortedAtStart(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtEnd(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_nullsAreSortedAtEnd(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductName(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getDatabaseProductName(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getDatabaseProductVersion(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getDriverName(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getDriverName(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getDriverVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getDriverVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDriverMajorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) {
        return filterChain.DatabaseMetaData_getDriverMajorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDriverMinorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) {
        return filterChain.DatabaseMetaData_getDriverMinorVersion(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFiles(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_usesLocalFiles(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFilePerTable(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_usesLocalFilePerTable(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsMixedCaseIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_storesUpperCaseIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_storesLowerCaseIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_storesMixedCaseIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_storesUpperCaseQuotedIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_storesLowerCaseQuotedIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_storesMixedCaseQuotedIdentifiers(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getIdentifierQuoteString(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getIdentifierQuoteString(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getSQLKeywords(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getSQLKeywords(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getNumericFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getNumericFunctions(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getStringFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getStringFunctions(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getSystemFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getSystemFunctions(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getTimeDateFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getTimeDateFunctions(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getSearchStringEscape(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getSearchStringEscape(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getExtraNameCharacters(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getExtraNameCharacters(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithAddColumn(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsAlterTableWithAddColumn(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithDropColumn(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsAlterTableWithDropColumn(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsColumnAliasing(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsColumnAliasing(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullPlusNonNullIsNull(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_nullPlusNonNullIsNull(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsConvert(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int fromType, int toType) throws SQLException {
        return filterChain.DatabaseMetaData_supportsConvert(databaseMetaData, fromType, toType);
    }

    @Override
    public boolean DatabaseMetaData_supportsTableCorrelationNames(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsTableCorrelationNames(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsDifferentTableCorrelationNames(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsDifferentTableCorrelationNames(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsExpressionsInOrderBy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsExpressionsInOrderBy(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOrderByUnrelated(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsOrderByUnrelated(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupBy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsGroupBy(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByUnrelated(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsGroupByUnrelated(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByBeyondSelect(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsGroupByBeyondSelect(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsLikeEscapeClause(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsLikeEscapeClause(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleResultSets(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsMultipleResultSets(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleTransactions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsMultipleTransactions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsNonNullableColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsNonNullableColumns(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMinimumSQLGrammar(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsMinimumSQLGrammar(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCoreSQLGrammar(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsCoreSQLGrammar(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsExtendedSQLGrammar(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsExtendedSQLGrammar(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92EntryLevelSQL(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsANSI92EntryLevelSQL(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92IntermediateSQL(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsANSI92IntermediateSQL(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92FullSQL(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsANSI92FullSQL(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsIntegrityEnhancementFacility(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsIntegrityEnhancementFacility(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOuterJoins(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsOuterJoins(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsFullOuterJoins(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsFullOuterJoins(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsLimitedOuterJoins(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsLimitedOuterJoins(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getSchemaTerm(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getSchemaTerm(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getProcedureTerm(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getProcedureTerm(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getCatalogTerm(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getCatalogTerm(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_isCatalogAtStart(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_isCatalogAtStart(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getCatalogSeparator(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getCatalogSeparator(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInDataManipulation(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsSchemasInDataManipulation(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInProcedureCalls(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsSchemasInProcedureCalls(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInTableDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsSchemasInTableDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInIndexDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsSchemasInIndexDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInDataManipulation(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsCatalogsInDataManipulation(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInProcedureCalls(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsCatalogsInProcedureCalls(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInTableDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsCatalogsInTableDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInIndexDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsCatalogsInIndexDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedDelete(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsPositionedDelete(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedUpdate(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsPositionedUpdate(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSelectForUpdate(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsSelectForUpdate(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredProcedures(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsStoredProcedures(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInComparisons(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsSubqueriesInComparisons(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInExists(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsSubqueriesInExists(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInIns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsSubqueriesInIns(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInQuantifieds(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsSubqueriesInQuantifieds(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCorrelatedSubqueries(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsCorrelatedSubqueries(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsUnion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsUnion(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsUnionAll(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsUnionAll(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossCommit(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsOpenCursorsAcrossCommit(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossRollback(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsOpenCursorsAcrossRollback(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossCommit(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsOpenStatementsAcrossCommit(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossRollback(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsOpenStatementsAcrossRollback(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxBinaryLiteralLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxBinaryLiteralLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxCharLiteralLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxCharLiteralLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxColumnNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInGroupBy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxColumnsInGroupBy(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInIndex(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxColumnsInIndex(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInOrderBy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxColumnsInOrderBy(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInSelect(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxColumnsInSelect(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInTable(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxColumnsInTable(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxConnections(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxConnections(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxCursorNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxCursorNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxIndexLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxIndexLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxSchemaNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxSchemaNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxProcedureNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxProcedureNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxCatalogNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxCatalogNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxRowSize(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxRowSize(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_doesMaxRowSizeIncludeBlobs(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_doesMaxRowSizeIncludeBlobs(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxStatementLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxStatementLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxStatements(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxStatements(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxTableNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxTableNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxTablesInSelect(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxTablesInSelect(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxUserNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxUserNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDefaultTransactionIsolation(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getDefaultTransactionIsolation(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsTransactions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactionIsolationLevel(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int level) throws SQLException {
        return filterChain.DatabaseMetaData_supportsTransactionIsolationLevel(databaseMetaData, level);
    }

    @Override
    public boolean DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsDataManipulationTransactionsOnly(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsDataManipulationTransactionsOnly(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionCausesTransactionCommit(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_dataDefinitionCausesTransactionCommit(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionIgnoredInTransactions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_dataDefinitionIgnoredInTransactions(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedures(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return filterChain.DatabaseMetaData_getProcedures(databaseMetaData, catalog, schemaPattern, procedureNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedureColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return filterChain.DatabaseMetaData_getProcedureColumns(databaseMetaData, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getTables(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return filterChain.DatabaseMetaData_getTables(databaseMetaData, catalog, schemaPattern, tableNamePattern, types);
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getSchemas(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getCatalogs(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getCatalogs(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getTableTypes(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getTableTypes(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return filterChain.DatabaseMetaData_getColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getColumnPrivileges(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return filterChain.DatabaseMetaData_getColumnPrivileges(databaseMetaData, catalog, schema, table, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getTablePrivileges(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return filterChain.DatabaseMetaData_getTablePrivileges(databaseMetaData, catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getBestRowIdentifier(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return filterChain.DatabaseMetaData_getBestRowIdentifier(databaseMetaData, catalog, schema, table, scope, nullable);
    }

    @Override
    public ResultSet DatabaseMetaData_getVersionColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        return filterChain.DatabaseMetaData_getVersionColumns(databaseMetaData, catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getPrimaryKeys(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        return filterChain.DatabaseMetaData_getPrimaryKeys(databaseMetaData, catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getImportedKeys(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        return filterChain.DatabaseMetaData_getImportedKeys(databaseMetaData, catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getExportedKeys(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        return filterChain.DatabaseMetaData_getExportedKeys(databaseMetaData, catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getCrossReference(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return filterChain.DatabaseMetaData_getCrossReference(databaseMetaData, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public ResultSet DatabaseMetaData_getTypeInfo(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getTypeInfo(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getIndexInfo(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return filterChain.DatabaseMetaData_getIndexInfo(databaseMetaData, catalog, schema, table, unique, approximate);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetType(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return filterChain.DatabaseMetaData_supportsResultSetType(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetConcurrency(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type, int concurrency) throws SQLException {
        return filterChain.DatabaseMetaData_supportsResultSetConcurrency(databaseMetaData, type, concurrency);
    }

    @Override
    public boolean DatabaseMetaData_ownUpdatesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return filterChain.DatabaseMetaData_ownUpdatesAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_ownDeletesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return filterChain.DatabaseMetaData_ownDeletesAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_ownInsertsAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return filterChain.DatabaseMetaData_ownInsertsAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_othersUpdatesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return filterChain.DatabaseMetaData_othersUpdatesAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_othersDeletesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return filterChain.DatabaseMetaData_othersDeletesAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_othersInsertsAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return filterChain.DatabaseMetaData_othersInsertsAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_updatesAreDetected(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return filterChain.DatabaseMetaData_updatesAreDetected(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_deletesAreDetected(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return filterChain.DatabaseMetaData_deletesAreDetected(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_insertsAreDetected(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return filterChain.DatabaseMetaData_insertsAreDetected(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_supportsBatchUpdates(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsBatchUpdates(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getUDTs(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return filterChain.DatabaseMetaData_getUDTs(databaseMetaData, catalog, schemaPattern, typeNamePattern, types);
    }

    @Override
    public Connection DatabaseMetaData_getConnection(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getConnection(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSavepoints(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsSavepoints(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsNamedParameters(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsNamedParameters(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleOpenResults(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsMultipleOpenResults(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsGetGeneratedKeys(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsGetGeneratedKeys(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTypes(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return filterChain.DatabaseMetaData_getSuperTypes(databaseMetaData, catalog, schemaPattern, typeNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTables(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return filterChain.DatabaseMetaData_getSuperTables(databaseMetaData, catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getAttributes(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return filterChain.DatabaseMetaData_getAttributes(databaseMetaData, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetHoldability(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int holdability) throws SQLException {
        return filterChain.DatabaseMetaData_supportsResultSetHoldability(databaseMetaData, holdability);
    }

    @Override
    public int DatabaseMetaData_getResultSetHoldability(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getResultSetHoldability(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDatabaseMajorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getDatabaseMajorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDatabaseMinorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getDatabaseMinorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getJDBCMajorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getJDBCMajorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getJDBCMinorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getJDBCMinorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getSQLStateType(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getSQLStateType(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_locatorsUpdateCopy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_locatorsUpdateCopy(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsStatementPooling(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsStatementPooling(databaseMetaData);
    }

    @Override
    public RowIdLifetime DatabaseMetaData_getRowIdLifetime(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getRowIdLifetime(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern) throws SQLException {
        return filterChain.DatabaseMetaData_getSchemas(databaseMetaData, catalog, schemaPattern);
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_autoCommitFailureClosesAllResultSets(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_autoCommitFailureClosesAllResultSets(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getClientInfoProperties(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getClientInfoProperties(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return filterChain.DatabaseMetaData_getFunctions(databaseMetaData, catalog, schemaPattern, functionNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctionColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return filterChain.DatabaseMetaData_getFunctionColumns(databaseMetaData, catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getPseudoColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return filterChain.DatabaseMetaData_getPseudoColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public boolean DatabaseMetaData_generatedKeyAlwaysReturned(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_generatedKeyAlwaysReturned(databaseMetaData);
    }

    @Override
    public long DatabaseMetaData_getMaxLogicalLobSize(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_getMaxLogicalLobSize(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsRefCursors(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return filterChain.DatabaseMetaData_supportsRefCursors(databaseMetaData);
    }

    @Override
    public Connection Driver_connect(FilterChain filterChain, DmDriver driver, DmProperties props) throws SQLException {
        return filterChain.Driver_connect(driver, props);
    }

    @Override
    public int ParameterMetaData_getParameterCount(FilterChain filterChain, DmdbParameterMetaData parameterMetaData) throws SQLException {
        return filterChain.ParameterMetaData_getParameterCount(parameterMetaData);
    }

    @Override
    public int ParameterMetaData_isNullable(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return filterChain.ParameterMetaData_isNullable(parameterMetaData, param);
    }

    @Override
    public boolean ParameterMetaData_isSigned(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return filterChain.ParameterMetaData_isSigned(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_getPrecision(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return filterChain.ParameterMetaData_getPrecision(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_getScale(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return filterChain.ParameterMetaData_getScale(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_getParameterType(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return filterChain.ParameterMetaData_getParameterType(parameterMetaData, param);
    }

    @Override
    public String ParameterMetaData_getParameterTypeName(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return filterChain.ParameterMetaData_getParameterTypeName(parameterMetaData, param);
    }

    @Override
    public String ParameterMetaData_getParameterClassName(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return filterChain.ParameterMetaData_getParameterClassName(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_getParameterMode(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return filterChain.ParameterMetaData_getParameterMode(parameterMetaData, param);
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return filterChain.PreparedStatement_executeQuery(preparedStatement);
    }

    @Override
    public int PreparedStatement_executeUpdate(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return filterChain.PreparedStatement_executeUpdate(preparedStatement);
    }

    @Override
    public int[] PreparedStatement_executeBatch(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return filterChain.PreparedStatement_executeBatch(preparedStatement);
    }

    @Override
    public long[] PreparedStatement_executeLargeBatch(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return filterChain.PreparedStatement_executeLargeBatch(preparedStatement);
    }

    @Override
    public void PreparedStatement_setNull(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType) throws SQLException {
        filterChain.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType);
    }

    @Override
    public void PreparedStatement_setBoolean(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, boolean x2) throws SQLException {
        filterChain.PreparedStatement_setBoolean(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setByte(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, byte x2) throws SQLException {
        filterChain.PreparedStatement_setByte(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setShort(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, short x2) throws SQLException {
        filterChain.PreparedStatement_setShort(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setInt(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, int x2) throws SQLException {
        filterChain.PreparedStatement_setInt(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setLong(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, long x2) throws SQLException {
        filterChain.PreparedStatement_setLong(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setFloat(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, float x2) throws SQLException {
        filterChain.PreparedStatement_setFloat(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setDouble(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, double x2) throws SQLException {
        filterChain.PreparedStatement_setDouble(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBigDecimal(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, BigDecimal x2) throws SQLException {
        filterChain.PreparedStatement_setBigDecimal(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setString(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        filterChain.PreparedStatement_setString(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBytes(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, byte[] x2) throws SQLException {
        filterChain.PreparedStatement_setBytes(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setDate(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2) throws SQLException {
        filterChain.PreparedStatement_setDate(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTime(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2) throws SQLException {
        filterChain.PreparedStatement_setTime(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2) throws SQLException {
        filterChain.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        filterChain.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setUnicodeStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        filterChain.PreparedStatement_setUnicodeStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        filterChain.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_clearParameters(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        filterChain.PreparedStatement_clearParameters(preparedStatement);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        filterChain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2) throws SQLException {
        filterChain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2);
    }

    @Override
    public boolean PreparedStatement_execute(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return filterChain.PreparedStatement_execute(preparedStatement);
    }

    @Override
    public void PreparedStatement_addBatch(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        filterChain.PreparedStatement_addBatch(preparedStatement);
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, int length) throws SQLException {
        filterChain.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setRef(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Ref x2) throws SQLException {
        filterChain.PreparedStatement_setRef(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Blob x2) throws SQLException {
        filterChain.PreparedStatement_setBlob(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Clob x2) throws SQLException {
        filterChain.PreparedStatement_setClob(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setArray(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Array x2) throws SQLException {
        filterChain.PreparedStatement_setArray(preparedStatement, parameterIndex, x2);
    }

    @Override
    public ResultSetMetaData PreparedStatement_getMetaData(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return filterChain.PreparedStatement_getMetaData(preparedStatement);
    }

    @Override
    public void PreparedStatement_setDate(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2, Calendar cal) throws SQLException {
        filterChain.PreparedStatement_setDate(preparedStatement, parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setTime(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2, Calendar cal) throws SQLException {
        filterChain.PreparedStatement_setTime(preparedStatement, parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        filterChain.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setNull(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        filterChain.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType, typeName);
    }

    @Override
    public void PreparedStatement_setURL(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, URL x2) throws SQLException {
        filterChain.PreparedStatement_setURL(preparedStatement, parameterIndex, x2);
    }

    @Override
    public ParameterMetaData PreparedStatement_getParameterMetaData(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return filterChain.PreparedStatement_getParameterMetaData(preparedStatement);
    }

    @Override
    public void PreparedStatement_setRowId(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, RowId x2) throws SQLException {
        filterChain.PreparedStatement_setRowId(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setNString(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, String value) throws SQLException {
        filterChain.PreparedStatement_setNString(preparedStatement, parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value, long length) throws SQLException {
        filterChain.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value, length);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, NClob value) throws SQLException {
        filterChain.PreparedStatement_setNClob(preparedStatement, parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        filterChain.PreparedStatement_setClob(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream, long length) throws SQLException {
        filterChain.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream, length);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        filterChain.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setSQLXML(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, SQLXML xmlObject) throws SQLException {
        filterChain.PreparedStatement_setSQLXML(preparedStatement, parameterIndex, xmlObject);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        filterChain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        filterChain.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        filterChain.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        filterChain.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        filterChain.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        filterChain.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        filterChain.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value) throws SQLException {
        filterChain.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        filterChain.PreparedStatement_setClob(preparedStatement, parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream) throws SQLException {
        filterChain.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        filterChain.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        filterChain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType) throws SQLException {
        filterChain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType);
    }

    @Override
    public long PreparedStatement_executeLargeUpdate(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return filterChain.PreparedStatement_executeLargeUpdate(preparedStatement);
    }

    @Override
    public void PreparedStatement_preCompile(FilterChain filterChain, DmdbPreparedStatement preparedStatement, String sql) throws SQLException {
        filterChain.PreparedStatement_preCompile(preparedStatement, sql);
    }

    @Override
    public void PreparedStatement_setTIMESTAMP(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbTimestamp x2) throws SQLException {
        filterChain.PreparedStatement_setTIMESTAMP(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setINTERVALYM(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        filterChain.PreparedStatement_setINTERVALYM(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setINTERVALDT(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        filterChain.PreparedStatement_setINTERVALDT(preparedStatement, parameterIndex, x2);
    }

    @Override
    public boolean ResultSet_next(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_next(resultSet);
    }

    @Override
    public void ResultSet_close(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        filterChain.ResultSet_close(resultSet);
    }

    @Override
    public boolean ResultSet_wasNull(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_wasNull(resultSet);
    }

    @Override
    public String ResultSet_getString(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getString(resultSet, columnIndex);
    }

    @Override
    public boolean ResultSet_getBoolean(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getBoolean(resultSet, columnIndex);
    }

    @Override
    public byte ResultSet_getByte(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getByte(resultSet, columnIndex);
    }

    @Override
    public short ResultSet_getShort(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getShort(resultSet, columnIndex);
    }

    @Override
    public int ResultSet_getInt(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getInt(resultSet, columnIndex);
    }

    @Override
    public long ResultSet_getLong(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getLong(resultSet, columnIndex);
    }

    @Override
    public float ResultSet_getFloat(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getFloat(resultSet, columnIndex);
    }

    @Override
    public double ResultSet_getDouble(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getDouble(resultSet, columnIndex);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, int scale) throws SQLException {
        return filterChain.ResultSet_getBigDecimal(resultSet, columnIndex);
    }

    @Override
    public byte[] ResultSet_getBytes(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getBytes(resultSet, columnIndex);
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getDate(resultSet, columnIndex);
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getTime(resultSet, columnIndex);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getTimestamp(resultSet, columnIndex);
    }

    @Override
    public InputStream ResultSet_getAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getAsciiStream(resultSet, columnIndex);
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getUnicodeStream(resultSet, columnIndex);
    }

    @Override
    public InputStream ResultSet_getBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getBinaryStream(resultSet, columnIndex);
    }

    @Override
    public String ResultSet_getString(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getString(resultSet, columnLabel);
    }

    @Override
    public boolean ResultSet_getBoolean(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getBoolean(resultSet, columnLabel);
    }

    @Override
    public byte ResultSet_getByte(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getByte(resultSet, columnLabel);
    }

    @Override
    public short ResultSet_getShort(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getShort(resultSet, columnLabel);
    }

    @Override
    public int ResultSet_getInt(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getInt(resultSet, columnLabel);
    }

    @Override
    public long ResultSet_getLong(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getLong(resultSet, columnLabel);
    }

    @Override
    public float ResultSet_getFloat(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getFloat(resultSet, columnLabel);
    }

    @Override
    public double ResultSet_getDouble(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getDouble(resultSet, columnLabel);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, int scale) throws SQLException {
        return filterChain.ResultSet_getBigDecimal(resultSet, columnLabel, scale);
    }

    @Override
    public byte[] ResultSet_getBytes(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getBytes(resultSet, columnLabel);
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getDate(resultSet, columnLabel);
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getTime(resultSet, columnLabel);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getTimestamp(resultSet, columnLabel);
    }

    @Override
    public InputStream ResultSet_getAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getAsciiStream(resultSet, columnLabel);
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getUnicodeStream(resultSet, columnLabel);
    }

    @Override
    public InputStream ResultSet_getBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getBinaryStream(resultSet, columnLabel);
    }

    @Override
    public SQLWarning ResultSet_getWarnings(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_getWarnings(resultSet);
    }

    @Override
    public void ResultSet_clearWarnings(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        filterChain.ResultSet_clearWarnings(resultSet);
    }

    @Override
    public String ResultSet_getCursorName(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_getCursorName(resultSet);
    }

    @Override
    public ResultSetMetaData ResultSet_getMetaData(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_getMetaData(resultSet);
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getObject(resultSet, columnIndex);
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getObject(resultSet, columnLabel);
    }

    @Override
    public int ResultSet_findColumn(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_findColumn(resultSet, columnLabel);
    }

    @Override
    public Reader ResultSet_getCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getCharacterStream(resultSet, columnIndex);
    }

    @Override
    public Reader ResultSet_getCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getCharacterStream(resultSet, columnLabel);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getBigDecimal(resultSet, columnIndex);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getBigDecimal(resultSet, columnLabel);
    }

    @Override
    public boolean ResultSet_isBeforeFirst(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_isBeforeFirst(resultSet);
    }

    @Override
    public boolean ResultSet_isAfterLast(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_isAfterLast(resultSet);
    }

    @Override
    public boolean ResultSet_isFirst(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_isFirst(resultSet);
    }

    @Override
    public boolean ResultSet_isLast(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_isLast(resultSet);
    }

    @Override
    public void ResultSet_beforeFirst(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        filterChain.ResultSet_beforeFirst(resultSet);
    }

    @Override
    public void ResultSet_afterLast(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        filterChain.ResultSet_afterLast(resultSet);
    }

    @Override
    public boolean ResultSet_first(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_first(resultSet);
    }

    @Override
    public boolean ResultSet_last(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_last(resultSet);
    }

    @Override
    public int ResultSet_getRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_getRow(resultSet);
    }

    @Override
    public boolean ResultSet_absolute(FilterChain filterChain, DmdbResultSet resultSet, int row) throws SQLException {
        return filterChain.ResultSet_absolute(resultSet, row);
    }

    @Override
    public boolean ResultSet_relative(FilterChain filterChain, DmdbResultSet resultSet, int rows) throws SQLException {
        return filterChain.ResultSet_relative(resultSet, rows);
    }

    @Override
    public boolean ResultSet_previous(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_previous(resultSet);
    }

    @Override
    public void ResultSet_setFetchDirection(FilterChain filterChain, DmdbResultSet resultSet, int direction) throws SQLException {
        filterChain.ResultSet_setFetchDirection(resultSet, direction);
    }

    @Override
    public int ResultSet_getFetchDirection(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_getFetchDirection(resultSet);
    }

    @Override
    public void ResultSet_setFetchSize(FilterChain filterChain, DmdbResultSet resultSet, int rows) throws SQLException {
        filterChain.ResultSet_setFetchSize(resultSet, rows);
    }

    @Override
    public int ResultSet_getFetchSize(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_getFetchSize(resultSet);
    }

    @Override
    public int ResultSet_getType(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_getType(resultSet);
    }

    @Override
    public int ResultSet_getConcurrency(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_getConcurrency(resultSet);
    }

    @Override
    public boolean ResultSet_rowUpdated(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_rowUpdated(resultSet);
    }

    @Override
    public boolean ResultSet_rowInserted(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_rowInserted(resultSet);
    }

    @Override
    public boolean ResultSet_rowDeleted(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_rowDeleted(resultSet);
    }

    @Override
    public void ResultSet_updateNull(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        filterChain.ResultSet_updateNull(resultSet, columnIndex);
    }

    @Override
    public void ResultSet_updateBoolean(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, boolean x2) throws SQLException {
        filterChain.ResultSet_updateBoolean(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateByte(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, byte x2) throws SQLException {
        filterChain.ResultSet_updateByte(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateShort(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, short x2) throws SQLException {
        filterChain.ResultSet_updateShort(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateInt(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, int x2) throws SQLException {
        filterChain.ResultSet_updateInt(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateLong(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, long x2) throws SQLException {
        filterChain.ResultSet_updateLong(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateFloat(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, float x2) throws SQLException {
        filterChain.ResultSet_updateFloat(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateDouble(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, double x2) throws SQLException {
        filterChain.ResultSet_updateDouble(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, BigDecimal x2) throws SQLException {
        filterChain.ResultSet_updateBigDecimal(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateString(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, String x2) throws SQLException {
        filterChain.ResultSet_updateString(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBytes(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, byte[] x2) throws SQLException {
        filterChain.ResultSet_updateBytes(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateDate(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Date x2) throws SQLException {
        filterChain.ResultSet_updateDate(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateTime(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Time x2) throws SQLException {
        filterChain.ResultSet_updateTime(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateTimestamp(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Timestamp x2) throws SQLException {
        filterChain.ResultSet_updateTimestamp(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        filterChain.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        filterChain.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2, int length) throws SQLException {
        filterChain.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Object x2, int scaleOrLength) throws SQLException {
        filterChain.ResultSet_updateObject(resultSet, columnIndex, x2, scaleOrLength);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Object x2) throws SQLException {
        filterChain.ResultSet_updateObject(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateNull(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        filterChain.ResultSet_updateNull(resultSet, columnLabel);
    }

    @Override
    public void ResultSet_updateBoolean(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, boolean x2) throws SQLException {
        filterChain.ResultSet_updateBoolean(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateByte(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, byte x2) throws SQLException {
        filterChain.ResultSet_updateByte(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateShort(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, short x2) throws SQLException {
        filterChain.ResultSet_updateShort(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateInt(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, int x2) throws SQLException {
        filterChain.ResultSet_updateInt(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateLong(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, long x2) throws SQLException {
        filterChain.ResultSet_updateLong(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateFloat(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, float x2) throws SQLException {
        filterChain.ResultSet_updateFloat(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateDouble(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, double x2) throws SQLException {
        filterChain.ResultSet_updateDouble(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, BigDecimal x2) throws SQLException {
        filterChain.ResultSet_updateBigDecimal(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateString(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, String x2) throws SQLException {
        filterChain.ResultSet_updateString(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBytes(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, byte[] x2) throws SQLException {
        filterChain.ResultSet_updateBytes(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateDate(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Date x2) throws SQLException {
        filterChain.ResultSet_updateDate(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateTime(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Time x2) throws SQLException {
        filterChain.ResultSet_updateTime(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateTimestamp(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Timestamp x2) throws SQLException {
        filterChain.ResultSet_updateTimestamp(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        filterChain.ResultSet_updateAsciiStream(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        filterChain.ResultSet_updateBinaryStream(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, int length) throws SQLException {
        filterChain.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Object x2, int scaleOrLength) throws SQLException {
        filterChain.ResultSet_updateObject(resultSet, columnLabel, x2, scaleOrLength);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Object x2) throws SQLException {
        filterChain.ResultSet_updateObject(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_insertRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        filterChain.ResultSet_insertRow(resultSet);
    }

    @Override
    public void ResultSet_updateRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        filterChain.ResultSet_updateRow(resultSet);
    }

    @Override
    public void ResultSet_deleteRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        filterChain.ResultSet_deleteRow(resultSet);
    }

    @Override
    public void ResultSet_refreshRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        filterChain.ResultSet_refreshRow(resultSet);
    }

    @Override
    public void ResultSet_cancelRowUpdates(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        filterChain.ResultSet_cancelRowUpdates(resultSet);
    }

    @Override
    public void ResultSet_moveToInsertRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        filterChain.ResultSet_moveToInsertRow(resultSet);
    }

    @Override
    public void ResultSet_moveToCurrentRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        filterChain.ResultSet_moveToCurrentRow(resultSet);
    }

    @Override
    public Statement ResultSet_getStatement(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_getStatement(resultSet);
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return filterChain.ResultSet_getObject(resultSet, columnIndex, map);
    }

    @Override
    public Ref ResultSet_getRef(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getRef(resultSet, columnIndex);
    }

    @Override
    public Blob ResultSet_getBlob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getBlob(resultSet, columnIndex);
    }

    @Override
    public Clob ResultSet_getClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getClob(resultSet, columnIndex);
    }

    @Override
    public Array ResultSet_getArray(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getArray(resultSet, columnIndex);
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return filterChain.ResultSet_getObject(resultSet, columnLabel, map);
    }

    @Override
    public Ref ResultSet_getRef(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getRef(resultSet, columnLabel);
    }

    @Override
    public Blob ResultSet_getBlob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getBlob(resultSet, columnLabel);
    }

    @Override
    public Clob ResultSet_getClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getClob(resultSet, columnLabel);
    }

    @Override
    public Array ResultSet_getArray(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getArray(resultSet, columnLabel);
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        return filterChain.ResultSet_getDate(resultSet, columnIndex, cal);
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        return filterChain.ResultSet_getDate(resultSet, columnLabel, cal);
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        return filterChain.ResultSet_getTime(resultSet, columnIndex, cal);
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        return filterChain.ResultSet_getTime(resultSet, columnLabel, cal);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        return filterChain.ResultSet_getTimestamp(resultSet, columnIndex, cal);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        return filterChain.ResultSet_getTimestamp(resultSet, columnLabel, cal);
    }

    @Override
    public URL ResultSet_getURL(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getURL(resultSet, columnIndex);
    }

    @Override
    public URL ResultSet_getURL(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getURL(resultSet, columnLabel);
    }

    @Override
    public void ResultSet_updateRef(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Ref x2) throws SQLException {
        filterChain.ResultSet_updateRef(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateRef(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Ref x2) throws SQLException {
        filterChain.ResultSet_updateRef(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Blob x2) throws SQLException {
        filterChain.ResultSet_updateBlob(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Blob x2) throws SQLException {
        filterChain.ResultSet_updateBlob(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Clob x2) throws SQLException {
        filterChain.ResultSet_updateClob(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Clob x2) throws SQLException {
        filterChain.ResultSet_updateClob(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateArray(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Array x2) throws SQLException {
        filterChain.ResultSet_updateArray(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateArray(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Array x2) throws SQLException {
        filterChain.ResultSet_updateArray(resultSet, columnLabel, x2);
    }

    @Override
    public RowId ResultSet_getRowId(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getRowId(resultSet, columnIndex);
    }

    @Override
    public RowId ResultSet_getRowId(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getRowId(resultSet, columnLabel);
    }

    @Override
    public void ResultSet_updateRowId(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, RowId x2) throws SQLException {
        filterChain.ResultSet_updateRowId(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateRowId(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, RowId x2) throws SQLException {
        filterChain.ResultSet_updateRowId(resultSet, columnLabel, x2);
    }

    @Override
    public int ResultSet_getHoldability(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_getHoldability(resultSet);
    }

    @Override
    public boolean ResultSet_isClosed(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return filterChain.ResultSet_isClosed(resultSet);
    }

    @Override
    public void ResultSet_updateNString(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, String nString) throws SQLException {
        filterChain.ResultSet_updateNString(resultSet, columnIndex, nString);
    }

    @Override
    public void ResultSet_updateNString(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, String nString) throws SQLException {
        filterChain.ResultSet_updateNString(resultSet, columnLabel, nString);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, NClob nClob) throws SQLException {
        filterChain.ResultSet_updateNClob(resultSet, columnIndex, nClob);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, NClob nClob) throws SQLException {
        filterChain.ResultSet_updateNClob(resultSet, columnLabel, nClob);
    }

    @Override
    public NClob ResultSet_getNClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getNClob(resultSet, columnIndex);
    }

    @Override
    public NClob ResultSet_getNClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getNClob(resultSet, columnLabel);
    }

    @Override
    public SQLXML ResultSet_getSQLXML(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getSQLXML(resultSet, columnIndex);
    }

    @Override
    public SQLXML ResultSet_getSQLXML(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getSQLXML(resultSet, columnLabel);
    }

    @Override
    public void ResultSet_updateSQLXML(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, SQLXML xmlObject) throws SQLException {
        filterChain.ResultSet_updateSQLXML(resultSet, columnIndex, xmlObject);
    }

    @Override
    public void ResultSet_updateSQLXML(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, SQLXML xmlObject) throws SQLException {
        filterChain.ResultSet_updateSQLXML(resultSet, columnLabel, xmlObject);
    }

    @Override
    public String ResultSet_getNString(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getNString(resultSet, columnIndex);
    }

    @Override
    public String ResultSet_getNString(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getNString(resultSet, columnLabel);
    }

    @Override
    public Reader ResultSet_getNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return filterChain.ResultSet_getNCharacterStream(resultSet, columnIndex);
    }

    @Override
    public Reader ResultSet_getNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return filterChain.ResultSet_getNCharacterStream(resultSet, columnLabel);
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        filterChain.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        filterChain.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        filterChain.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        filterChain.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        filterChain.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        filterChain.ResultSet_updateAsciiStream(resultSet, columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        filterChain.ResultSet_updateBinaryStream(resultSet, columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        filterChain.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream inputStream, long length) throws SQLException {
        filterChain.ResultSet_updateBlob(resultSet, columnIndex, inputStream, length);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream inputStream, long length) throws SQLException {
        filterChain.ResultSet_updateBlob(resultSet, columnLabel, inputStream, length);
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        filterChain.ResultSet_updateClob(resultSet, columnIndex, reader, length);
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        filterChain.ResultSet_updateClob(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        filterChain.ResultSet_updateNClob(resultSet, columnIndex, reader, length);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        filterChain.ResultSet_updateNClob(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        filterChain.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        filterChain.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        filterChain.ResultSet_updateAsciiStream(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        filterChain.ResultSet_updateBinaryStream(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        filterChain.ResultSet_updateCharacterStream(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        filterChain.ResultSet_updateAsciiStream(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        filterChain.ResultSet_updateBinaryStream(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        filterChain.ResultSet_updateCharacterStream(resultSet, columnLabel, reader);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream inputStream) throws SQLException {
        filterChain.ResultSet_updateBlob(resultSet, columnIndex, inputStream);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream inputStream) throws SQLException {
        filterChain.ResultSet_updateBlob(resultSet, columnLabel, inputStream);
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        filterChain.ResultSet_updateClob(resultSet, columnIndex, reader);
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        filterChain.ResultSet_updateClob(resultSet, columnLabel, reader);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        filterChain.ResultSet_updateNClob(resultSet, columnIndex, reader);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        filterChain.ResultSet_updateNClob(resultSet, columnLabel, reader);
    }

    @Override
    public <T> T ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Class<T> type) throws SQLException {
        return filterChain.ResultSet_getObject(resultSet, columnIndex, type);
    }

    @Override
    public <T> T ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Class<T> type) throws SQLException {
        return filterChain.ResultSet_getObject(resultSet, columnLabel, type);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        filterChain.ResultSet_updateObject(resultSet, columnIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        filterChain.ResultSet_updateObject(resultSet, columnLabel, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Object x2, SQLType targetSqlType) throws SQLException {
        filterChain.ResultSet_updateObject(resultSet, columnIndex, x2, targetSqlType);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Object x2, SQLType targetSqlType) throws SQLException {
        filterChain.ResultSet_updateObject(resultSet, columnLabel, x2, targetSqlType);
    }

    @Override
    public int ResultSetMetaData_getColumnCount(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData) throws SQLException {
        return filterChain.ResultSetMetaData_getColumnCount(resultSetMetaData);
    }

    @Override
    public boolean ResultSetMetaData_isAutoIncrement(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_isAutoIncrement(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isCaseSensitive(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_isCaseSensitive(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isSearchable(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_isSearchable(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isCurrency(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_isCurrency(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_isNullable(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_isNullable(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isSigned(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_isSigned(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_getColumnDisplaySize(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_getColumnDisplaySize(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getColumnLabel(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_getColumnLabel(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getColumnName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_getColumnName(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getSchemaName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_getSchemaName(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_getPrecision(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_getPrecision(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_getScale(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_getScale(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getTableName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_getTableName(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getCatalogName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_getCatalogName(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_getColumnType(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_getColumnType(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getColumnTypeName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_getColumnTypeName(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isReadOnly(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_isReadOnly(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isWritable(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_isWritable(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isDefinitelyWritable(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_isDefinitelyWritable(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getColumnClassName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return filterChain.ResultSetMetaData_getColumnClassName(resultSetMetaData, column);
    }

    @Override
    public ResultSet Statement_executeQuery(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        return filterChain.Statement_executeQuery(statement, sql);
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        return filterChain.Statement_executeUpdate(statement, sql);
    }

    @Override
    public void Statement_close(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        filterChain.Statement_close(statement);
    }

    @Override
    public int Statement_getMaxFieldSize(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getMaxFieldSize(statement);
    }

    @Override
    public void Statement_setMaxFieldSize(FilterChain filterChain, DmdbStatement statement, int max) throws SQLException {
        filterChain.Statement_setMaxFieldSize(statement, max);
    }

    @Override
    public int Statement_getMaxRows(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getMaxRows(statement);
    }

    @Override
    public void Statement_setMaxRows(FilterChain filterChain, DmdbStatement statement, int max) throws SQLException {
        filterChain.Statement_setMaxRows(statement, max);
    }

    @Override
    public void Statement_setEscapeProcessing(FilterChain filterChain, DmdbStatement statement, boolean enable) throws SQLException {
        filterChain.Statement_setEscapeProcessing(statement, enable);
    }

    @Override
    public int Statement_getQueryTimeout(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getQueryTimeout(statement);
    }

    @Override
    public void Statement_setQueryTimeout(FilterChain filterChain, DmdbStatement statement, int seconds) throws SQLException {
        filterChain.Statement_setQueryTimeout(statement, seconds);
    }

    @Override
    public void Statement_cancel(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        filterChain.Statement_cancel(statement);
    }

    @Override
    public SQLWarning Statement_getWarnings(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getWarnings(statement);
    }

    @Override
    public void Statement_clearWarnings(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        filterChain.Statement_clearWarnings(statement);
    }

    @Override
    public void Statement_setCursorName(FilterChain filterChain, DmdbStatement statement, String name) throws SQLException {
        filterChain.Statement_setCursorName(statement, name);
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        return filterChain.Statement_execute(statement, sql);
    }

    @Override
    public ResultSet Statement_getResultSet(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getResultSet(statement);
    }

    @Override
    public int Statement_getUpdateCount(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getUpdateCount(statement);
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getMoreResults(statement);
    }

    @Override
    public void Statement_setFetchDirection(FilterChain filterChain, DmdbStatement statement, int direction) throws SQLException {
        filterChain.Statement_setFetchDirection(statement, direction);
    }

    @Override
    public int Statement_getFetchDirection(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getFetchDirection(statement);
    }

    @Override
    public void Statement_setFetchSize(FilterChain filterChain, DmdbStatement statement, int rows) throws SQLException {
        filterChain.Statement_setFetchSize(statement, rows);
    }

    @Override
    public int Statement_getFetchSize(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getFetchSize(statement);
    }

    @Override
    public int Statement_getResultSetConcurrency(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getResultSetConcurrency(statement);
    }

    @Override
    public int Statement_getResultSetType(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getResultSetType(statement);
    }

    @Override
    public void Statement_addBatch(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        filterChain.Statement_addBatch(statement, sql);
    }

    @Override
    public void Statement_clearBatch(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        filterChain.Statement_clearBatch(statement);
    }

    @Override
    public int[] Statement_executeBatch(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_executeBatch(statement);
    }

    @Override
    public Connection Statement_getConnection(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getConnection(statement);
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain filterChain, DmdbStatement statement, int current) throws SQLException {
        return filterChain.Statement_getMoreResults(statement, current);
    }

    @Override
    public ResultSet Statement_getGeneratedKeys(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getGeneratedKeys(statement);
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        return filterChain.Statement_executeUpdate(statement, sql, autoGeneratedKeys);
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        return filterChain.Statement_executeUpdate(statement, sql, columnIndexes);
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        return filterChain.Statement_executeUpdate(statement, sql, columnNames);
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        return filterChain.Statement_execute(statement, sql, autoGeneratedKeys);
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        return filterChain.Statement_execute(statement, sql, columnIndexes);
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        return filterChain.Statement_execute(statement, sql, columnNames);
    }

    @Override
    public int Statement_getResultSetHoldability(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getResultSetHoldability(statement);
    }

    @Override
    public boolean Statement_isClosed(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_isClosed(statement);
    }

    @Override
    public void Statement_setPoolable(FilterChain filterChain, DmdbStatement statement, boolean poolable) throws SQLException {
        filterChain.Statement_setPoolable(statement, poolable);
    }

    @Override
    public boolean Statement_isPoolable(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_isPoolable(statement);
    }

    @Override
    public void Statement_closeOnCompletion(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        filterChain.Statement_closeOnCompletion(statement);
    }

    @Override
    public boolean Statement_isCloseOnCompletion(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_isCloseOnCompletion(statement);
    }

    @Override
    public long Statement_getLargeUpdateCount(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getLargeUpdateCount(statement);
    }

    @Override
    public void Statement_setLargeMaxRows(FilterChain filterChain, DmdbStatement statement, long max) throws SQLException {
        filterChain.Statement_setLargeMaxRows(statement, max);
    }

    @Override
    public long Statement_getLargeMaxRows(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getLargeMaxRows(statement);
    }

    @Override
    public long[] Statement_executeLargeBatch(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_executeLargeBatch(statement);
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        return filterChain.Statement_executeLargeUpdate(statement, sql);
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        return filterChain.Statement_executeLargeUpdate(statement, sql, autoGeneratedKeys);
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        return filterChain.Statement_executeLargeUpdate(statement, sql, columnIndexes);
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        return filterChain.Statement_executeLargeUpdate(statement, sql, columnNames);
    }

    @Override
    public long Statement_getExecuteId(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getExecuteId(statement);
    }

    @Override
    public String Statement_getPrintMsg(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getPrintMsg(statement);
    }

    @Override
    public int Statement_getSqlType(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getSqlType(statement);
    }

    @Override
    public RowId Statement_getRowId(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getRowId(statement);
    }

    @Override
    public ResultSet[] Statement_getResultSets(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return filterChain.Statement_getResultSets(statement);
    }

    @Override
    public void Connection_reset(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        filterChain.Connection_reset(connection);
    }

    @Override
    public String Statement_getExplain(FilterChain filterChain, DmdbStatement dmdbStatement) {
        return filterChain.Statement_getExplain(dmdbStatement);
    }

    @Override
    public ResultSet CallableStatement_getCursor(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return filterChain.CallableStatement_getCursor(callableStatement, parameterName);
    }

    @Override
    public void CallableStatement_setINTERVALDT(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName, DmdbIntervalDT x2) throws SQLException {
        filterChain.CallableStatement_setINTERVALDT(callableStatement, paramName, x2);
    }

    @Override
    public void CallableStatement_setINTERVALYM(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName, DmdbIntervalYM x2) throws SQLException {
        filterChain.CallableStatement_setINTERVALYM(callableStatement, paramName, x2);
    }

    @Override
    public void CallableStatement_setTIMESTAMP(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName, DmdbTimestamp x2) throws SQLException {
        filterChain.CallableStatement_setTIMESTAMP(callableStatement, paramName, x2);
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        return filterChain.CallableStatement_getTIMESTAMP(callableStatement, paramName);
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        return filterChain.CallableStatement_getINTERVALDT(callableStatement, paramName);
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        return filterChain.CallableStatement_getINTERVALYM(callableStatement, paramName);
    }

    @Override
    public void XAResource_start(FilterChain filterChain, DmdbXAResource xaResource, Xid xid, int flags) throws XAException {
        filterChain.XAResource_start(xaResource, xid, flags);
    }

    @Override
    public void XAResource_end(FilterChain filterChain, DmdbXAResource xaResource, Xid xid, int flags) throws XAException {
        filterChain.XAResource_end(xaResource, xid, flags);
    }

    @Override
    public boolean XAResource_setTransactionTimeout(FilterChain filterChain, DmdbXAResource xaResource, int seconds) throws XAException {
        return filterChain.XAResource_setTransactionTimeout(xaResource, seconds);
    }

    @Override
    public int XAResource_getTransactionTimeout(FilterChain filterChain, DmdbXAResource xaResource) throws XAException {
        return filterChain.XAResource_getTransactionTimeout(xaResource);
    }

    @Override
    public void XAResource_rollback(FilterChain filterChain, DmdbXAResource xaResource, Xid xid) throws XAException {
        filterChain.XAResource_rollback(xaResource, xid);
    }

    @Override
    public void XAResource_commit(FilterChain filterChain, DmdbXAResource xaResource, Xid xid, boolean onePhase) throws XAException {
        filterChain.XAResource_commit(xaResource, xid, onePhase);
    }

    @Override
    public Xid[] XAResource_recover(FilterChain filterChain, DmdbXAResource xaResource, int flag) throws XAException {
        return filterChain.XAResource_recover(xaResource, flag);
    }

    @Override
    public int XAResource_prepare(FilterChain filterChain, DmdbXAResource xaResource, Xid xid) throws XAException {
        return filterChain.XAResource_prepare(xaResource, xid);
    }

    @Override
    public boolean XAResource_isSameRM(FilterChain filterChain, DmdbXAResource xaResource, XAResource xaRes) throws XAException {
        return filterChain.XAResource_isSameRM(xaResource, xaRes);
    }

    @Override
    public void XAResource_forget(FilterChain filterChain, DmdbXAResource xaResource, Xid xid) throws XAException {
        filterChain.XAResource_forget(xaResource, xid);
    }

    public static abstract class FilterCallback<T> {
        public abstract void run(T var1) throws SQLException;
    }

    public static abstract class FilterTask
    implements Runnable {
        private boolean success = false;
        private SQLException error = null;
        private CountDownLatch countDownLatch;

        public FilterTask(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                try {
                    this.doTask();
                    this.setSuccess(true);
                }
                catch (SQLException e2) {
                    this.setError(e2);
                    this.setSuccess(false);
                    this.countDownLatch.countDown();
                }
            }
            finally {
                this.countDownLatch.countDown();
            }
        }

        protected abstract void doTask() throws SQLException;

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setError(SQLException error) {
            this.error = error;
        }

        public SQLException getError() {
            return this.error;
        }
    }
}

