/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class DmdbInputStream
extends InputStream {
    public static final int BINARY = 1;
    public static final int ASCII = 2;
    public static final int UNICODE = 3;
    private int type = 1;
    public static final int IS_BLOB = 1;
    public static final int IS_CLOB = 2;
    public static final int IS_BYTE = 3;
    private int objType;
    private Object obj = null;
    private long objPos;
    private long objLength;
    private boolean cut;
    private byte[] buf;
    private int bufPos = 0;
    private long avaliable;

    public DmdbInputStream(Object o2) throws SQLException {
        this.obj = o2;
        this.objPos = 0L;
        if (o2 instanceof DmdbBlob) {
            this.objType = 1;
            this.avaliable = this.objLength = ((DmdbBlob)o2).do_length();
        } else if (o2 instanceof DmdbClob) {
            this.objType = 2;
            this.objLength = ((DmdbClob)o2).do_length();
            this.avaliable = ((DmdbClob)o2).bytesLength;
        } else if (o2 instanceof byte[]) {
            this.objType = 3;
            this.avaliable = this.objLength = (long)((byte[])o2).length;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
    }

    protected DmdbInputStream(DmdbBlob blob, long pos, long length) throws SQLException {
        this(blob);
        this.objPos = pos - 1L;
        this.objLength = Math.min(this.objLength, this.objPos + length);
        this.cut = this.objPos > 0L || this.objLength < blob.do_length();
        this.avaliable = this.objLength - this.objPos;
    }

    public DmdbInputStream(Object o2, int type) throws SQLException {
        this(o2);
        this.type = type;
    }

    public Object useRealObject(long targetLength) {
        switch (this.objType) {
            case 1: 
            case 2: {
                if (this.objPos != 0L || this.cut || -1L != targetLength && targetLength < this.objLength) break;
                return this.obj;
            }
        }
        return this;
    }

    @Override
    public int read(byte[] bs, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > bs.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.avaliable <= 0L) {
            return -1;
        }
        int readLen = 0;
        while (readLen < len) {
            int bufLeaveLen = this.bufLeaveLen();
            if (bufLeaveLen == 0 && (bufLeaveLen = this.fillBuffer()) <= 0) break;
            int needLen = len - readLen;
            int iLen = Math.min(needLen, bufLeaveLen);
            System.arraycopy(this.buf, this.bufPos, bs, off, iLen);
            this.bufPos += iLen;
            off += iLen;
            readLen += iLen;
        }
        this.avaliable -= (long)readLen;
        return readLen == 0 ? -1 : readLen;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int retLen = this.read(buf);
        if (retLen == -1) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] bs) throws IOException {
        return this.read(bs, 0, bs.length);
    }

    @Override
    public int available() {
        return this.obj instanceof DmdbClob ? 0 : (this.avaliable > Integer.MAX_VALUE ? 0 : (int)this.avaliable);
    }

    @Override
    public long skip(long n2) throws IOException {
        if (this.objType == 2) {
            return super.skip(n2);
        }
        long skip = Math.min(this.avaliable, n2);
        if (skip <= 0L) {
            return 0L;
        }
        int bufLeaveLen = this.bufLeaveLen();
        if (skip < (long)bufLeaveLen) {
            this.bufPos = (int)((long)this.bufPos + skip);
        } else {
            this.objPos += skip - (long)bufLeaveLen;
            this.fillBuffer();
        }
        return skip;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
    }

    private int bufLeaveLen() {
        return this.buf == null ? 0 : this.buf.length - this.bufPos;
    }

    private int fillBuffer() throws IOException {
        switch (this.objType) {
            case 1: {
                return this.readFromBlob(32640);
            }
            case 2: {
                return this.readFromClob(16320);
            }
            case 3: {
                return this.readFromBytes();
            }
        }
        DBError.throwIOException(DBError.ECJDBC_DATA_CONVERTION_ERROR.reason);
        return 0;
    }

    private int readFromBytes() {
        long leaveLen = this.objLength - this.objPos;
        int readLen = 0;
        if (leaveLen <= 0L) {
            return -1;
        }
        this.buf = (byte[])this.obj;
        readLen = this.buf == null ? 0 : this.buf.length;
        this.objPos += (long)readLen;
        this.bufPos = 0;
        return readLen;
    }

    private int readFromBlob(int destLen) throws IOException {
        int readLen;
        long leaveLen;
        DmdbBlob blob;
        block3: {
            blob = (DmdbBlob)this.obj;
            leaveLen = this.objLength - this.objPos;
            readLen = 0;
            if (leaveLen > 0L) break block3;
            return -1;
        }
        try {
            destLen = (int)Math.min(leaveLen, (long)destLen);
            this.buf = blob.do_getBytes(this.objPos + 1L, destLen);
            readLen = this.buf == null ? 0 : this.buf.length;
            this.objPos += (long)readLen;
            this.bufPos = 0;
        }
        catch (SQLException sqle) {
            DBError.throwIOException(sqle.getMessage());
        }
        return readLen;
    }

    private int readFromClob(int destLen) throws IOException {
        int readLen;
        long leaveLen;
        DmdbClob clob;
        block3: {
            clob = (DmdbClob)this.obj;
            leaveLen = this.objLength - this.objPos;
            readLen = 0;
            if (leaveLen > 0L) break block3;
            return -1;
        }
        try {
            destLen = (int)Math.min(leaveLen, (long)destLen);
            String str = clob.do_getSubString(this.objPos + 1L, destLen);
            this.buf = this.type == 2 ? (str == null ? new byte[]{} : ConvertUtil.StringToAsciiBytes(str)) : (this.type == 3 ? (str == null ? new byte[]{} : ConvertUtil.StringToUnicodeBytes(str)) : (str == null ? new byte[]{} : ByteUtil.fromString(str, clob.serverEncoding)));
            readLen = this.buf == null ? 0 : this.buf.length;
            this.objPos += (long)destLen;
            this.bufPos = 0;
        }
        catch (SQLException sqle) {
            DBError.throwIOException(sqle.getMessage());
        }
        return readLen;
    }
}

