/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.DateFormatOracle;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;

public class DmdbTimestamp
extends Timestamp
implements Serializable {
    private static final long serialVersionUID = 544720274538766252L;
    public static final long MiSeconds_1900_1970 = 2209017600000L;
    public static final int MAX_YEAR = 9999;
    public static final int MIN_YEAR = -4712;
    public static final int OFFSET_YEAR = 0;
    public static final int OFFSET_MONTH = 1;
    public static final int OFFSET_DAY = 2;
    public static final int OFFSET_HOUR = 3;
    public static final int OFFSET_MINUTE = 4;
    public static final int OFFSET_SECOND = 5;
    public static final int OFFSET_NANOSECOND = 6;
    public static final int OFFSET_TIMEZONE = 7;
    public static final int DT_LEN = 8;
    public static final int INVALID_VALUE = Integer.MIN_VALUE;
    public static final int NANOSECOND_DIGITS = 9;
    public static final int NANOSECOND_POW = 1000000000;
    public int[] dt = new int[8];
    public int dtype = 16;
    public int scale = 6;
    private static ThreadLocal<Calendar> calendars = new ThreadLocal();

    private static Calendar getCalendar() {
        Calendar calendar = calendars.get();
        if (calendar == null) {
            calendar = Calendar.getInstance(TimeZone.getDefault());
            calendars.set(calendar);
        }
        return calendar;
    }

    private DmdbTimestamp() {
        super(0L);
    }

    private DmdbTimestamp init() {
        super.setTime(this.getTime());
        super.setNanos(this.getNanos());
        return this;
    }

    public static DmdbTimestamp valueOf(byte[] bytes, Column column, IDmdbConnection connection) {
        DmdbTimestamp ts = new DmdbTimestamp();
        ts.decode(bytes, column, connection.getLocalTimezone(), connection.getDBTimezone());
        return ts.init();
    }

    public static DmdbTimestamp valueOf(long time, Column column) {
        DmdbTimestamp ts = new DmdbTimestamp();
        ts.setTime(time);
        ts.dtype = column.type;
        ts.scale = column.scale;
        return ts.init();
    }

    public static DmdbTimestamp valueOf(String str) {
        DmdbTimestamp ts = new DmdbTimestamp();
        ts.parseString(str);
        return ts.init();
    }

    public static DmdbTimestamp valueOf(String str, Column column, IDmdbConnection connection) {
        DmdbTimestamp ts = new DmdbTimestamp();
        String format = connection.getFormat(column);
        if (StringUtil.isNotEmpty(format)) {
            ts.dt = DateFormatOracle.parse(str, format, connection.getDateLanguage());
            ts.dtype = column.type;
            ts.scale = column.scale;
            return ts.init();
        }
        ts.parseString(str);
        return ts.init();
    }

    public static DmdbTimestamp valueOf(java.util.Date x2) {
        return DmdbTimestamp.valueOf(x2, null);
    }

    public static DmdbTimestamp valueOf(java.util.Date x2, Calendar calendar) {
        DmdbTimestamp ts = new DmdbTimestamp();
        ts.setTime(x2.getTime(), calendar);
        if (x2 instanceof Timestamp) {
            ts.setNanos(((Timestamp)x2).getNanos());
        }
        ts.dtype = 16;
        ts.scale = 6;
        return ts.init();
    }

    public static DmdbTimestamp valueOf(LocalDate x2) {
        DmdbTimestamp ts = new DmdbTimestamp();
        ts.dt[0] = x2.getYear();
        ts.dt[1] = x2.getMonthValue();
        ts.dt[2] = x2.getDayOfMonth();
        ts.dt[7] = Integer.MIN_VALUE;
        ts.dtype = 14;
        ts.scale = 0;
        return ts.init();
    }

    public static DmdbTimestamp valueOf(LocalTime x2) {
        DmdbTimestamp ts = new DmdbTimestamp();
        ts.dt[0] = 1900;
        ts.dt[1] = 1;
        ts.dt[2] = 1;
        ts.dt[3] = x2.getHour();
        ts.dt[4] = x2.getMinute();
        ts.dt[5] = x2.getSecond();
        ts.dt[6] = x2.getNano();
        ts.dt[7] = Integer.MIN_VALUE;
        ts.dtype = 15;
        ts.scale = 6;
        return ts.init();
    }

    public static DmdbTimestamp valueOf(LocalDateTime x2) {
        DmdbTimestamp ts = new DmdbTimestamp();
        ts.dt[0] = x2.getYear();
        ts.dt[1] = x2.getMonthValue();
        ts.dt[2] = x2.getDayOfMonth();
        ts.dt[3] = x2.getHour();
        ts.dt[4] = x2.getMinute();
        ts.dt[5] = x2.getSecond();
        ts.dt[6] = x2.getNano();
        ts.dt[7] = Integer.MIN_VALUE;
        ts.dtype = 16;
        ts.scale = 6;
        return ts.init();
    }

    public static DmdbTimestamp valueOf(ZonedDateTime x2) {
        DmdbTimestamp ts = new DmdbTimestamp();
        ts.dt[0] = x2.getYear();
        ts.dt[1] = x2.getMonthValue();
        ts.dt[2] = x2.getDayOfMonth();
        ts.dt[3] = x2.getHour();
        ts.dt[4] = x2.getMinute();
        ts.dt[5] = x2.getSecond();
        ts.dt[6] = x2.getNano();
        ts.dt[7] = x2.getOffset().getTotalSeconds() / 60;
        ts.dtype = 23;
        ts.scale = 6;
        return ts.init();
    }

    public static DmdbTimestamp valueOf(OffsetDateTime x2) {
        DmdbTimestamp ts = new DmdbTimestamp();
        ts.dt[0] = x2.getYear();
        ts.dt[1] = x2.getMonthValue();
        ts.dt[2] = x2.getDayOfMonth();
        ts.dt[3] = x2.getHour();
        ts.dt[4] = x2.getMinute();
        ts.dt[5] = x2.getSecond();
        ts.dt[6] = x2.getNano();
        ts.dt[7] = x2.getOffset().getTotalSeconds() / 60;
        ts.dtype = 23;
        ts.scale = 6;
        return ts.init();
    }

    public static DmdbTimestamp valueOf(OffsetTime x2) {
        DmdbTimestamp ts = new DmdbTimestamp();
        ts.dt[0] = 1900;
        ts.dt[1] = 1;
        ts.dt[2] = 1;
        ts.dt[3] = x2.getHour();
        ts.dt[4] = x2.getMinute();
        ts.dt[5] = x2.getSecond();
        ts.dt[6] = x2.getNano();
        ts.dt[7] = x2.getOffset().getTotalSeconds() / 60;
        ts.dtype = 22;
        ts.scale = 6;
        return ts.init();
    }

    @Override
    public String toString() {
        return this.toString(this.dtype, this.scale);
    }

    private String toString(int dtype, int scale) {
        switch (dtype) {
            case 14: {
                return String.valueOf(DateUtil.formatYear(this.dt[0])) + "-" + DateUtil.format2(this.dt[1]) + "-" + DateUtil.format2(this.dt[2]);
            }
            case 15: {
                if (scale > 0) {
                    return String.valueOf(DateUtil.format2(this.dt[3])) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]) + "." + DateUtil.formatMilliSecond(this.dt[6], scale);
                }
                return String.valueOf(DateUtil.format2(this.dt[3])) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]);
            }
            case 22: {
                if (scale > 0) {
                    return String.valueOf(DateUtil.format2(this.dt[3])) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]) + "." + DateUtil.formatMilliSecond(this.dt[6], scale) + " " + DateUtil.formatTZ(this.dt[7]);
                }
                return String.valueOf(DateUtil.format2(this.dt[3])) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]) + " " + DateUtil.formatTZ(this.dt[7]);
            }
            case 16: 
            case 26: {
                if (scale > 0) {
                    return String.valueOf(DateUtil.formatYear(this.dt[0])) + "-" + DateUtil.format2(this.dt[1]) + "-" + DateUtil.format2(this.dt[2]) + " " + DateUtil.format2(this.dt[3]) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]) + "." + DateUtil.formatMilliSecond(this.dt[6], scale);
                }
                return String.valueOf(DateUtil.formatYear(this.dt[0])) + "-" + DateUtil.format2(this.dt[1]) + "-" + DateUtil.format2(this.dt[2]) + " " + DateUtil.format2(this.dt[3]) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]);
            }
            case 23: 
            case 27: {
                if (scale > 0) {
                    return String.valueOf(DateUtil.formatYear(this.dt[0])) + "-" + DateUtil.format2(this.dt[1]) + "-" + DateUtil.format2(this.dt[2]) + " " + DateUtil.format2(this.dt[3]) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]) + "." + DateUtil.formatMilliSecond(this.dt[6], scale) + " " + DateUtil.formatTZ(this.dt[7]);
                }
                return String.valueOf(DateUtil.formatYear(this.dt[0])) + "-" + DateUtil.format2(this.dt[1]) + "-" + DateUtil.format2(this.dt[2]) + " " + DateUtil.format2(this.dt[3]) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]) + " " + DateUtil.formatTZ(this.dt[7]);
            }
        }
        return "";
    }

    public String toString(Column column, IDmdbConnection connection) {
        String format = connection.getFormat(column);
        if (StringUtil.isNotEmpty(format)) {
            return DateFormatOracle.format(this.dt, format, column.scale, connection.getDateLanguage());
        }
        int dtype = column.mask == 1 ? 14 : column.type;
        return this.toString(dtype, column.scale);
    }

    public Date toDate() {
        return this.toDate(null);
    }

    public Date toDate(Calendar cal) {
        return new Date(this.getTime(cal));
    }

    public Time toTime() {
        return this.toTime(null);
    }

    public Time toTime(Calendar cal) {
        return new Time(this.getTime(cal));
    }

    public Timestamp toTimestamp() {
        return this.toTimestamp(null);
    }

    public Timestamp toTimestamp(Calendar cal) {
        Timestamp val = new Timestamp(this.getTime(cal));
        val.setNanos(this.dt[6]);
        return val;
    }

    public int[] decode(byte[] value, Column column, int ltz, int dbtz) {
        this.dt = column.isBdta ? DmdbTimestamp.dmdtDecodeBdta(value) : DmdbTimestamp.dmdtDecodeFast(value);
        if (column.mask == 4) {
            this.dt = DmdbTimestamp.transformTZ(this.dt, dbtz, ltz);
        }
        this.dtype = column.type;
        this.scale = column.scale;
        return this.dt;
    }

    private static int[] dmdtDecodeFast(byte[] value) {
        int[] dt = new int[8];
        dt[7] = Integer.MIN_VALUE;
        int dtype = 0;
        if (value.length == 3) {
            dtype = 14;
        } else if (value.length == 5) {
            dtype = 15;
        } else if (value.length == 7) {
            dtype = 22;
        } else if (value.length == 8) {
            dtype = 16;
        } else if (value.length == 9) {
            dtype = 26;
        } else if (value.length == 10) {
            dtype = 23;
        } else if (value.length == 11) {
            dtype = 27;
        }
        if (dtype == 14) {
            dt[0] = ByteUtil.getShort(value, 0) & Short.MAX_VALUE;
            if (dt[0] > 9999) {
                dt[0] = (short)((short)dt[0] | 0x8000);
            }
            dt[1] = (value[1] >> 7 & 1) + ((value[2] & 7) << 1);
            dt[2] = (value[2] & 0xF8) >> 3 & 0x1F;
        } else if (dtype == 15) {
            dt[3] = (short)(value[0] & 0x1F);
            dt[4] = (short)((value[0] >> 5 & 7) + ((value[1] & 7) << 3));
            dt[5] = (short)((value[1] >> 3 & 0x1F) + ((value[2] & 1) << 5));
            dt[6] = (value[2] >> 1 & 0x7F) + ((value[3] & 0xFF) << 7) + ((value[4] & 0x1F) << 15);
            dt[6] = dt[6] * 1000;
        } else if (dtype == 22) {
            dt[3] = (short)(value[0] & 0x1F);
            dt[4] = (short)((value[0] >> 5 & 7) + ((value[1] & 7) << 3));
            dt[5] = (short)((value[1] >> 3 & 0x1F) + ((value[2] & 1) << 5));
            dt[6] = (value[2] >> 1 & 0x7F) + ((value[3] & 0xFF) << 7) + ((value[4] & 0x1F) << 15);
            dt[6] = dt[6] * 1000;
            dt[7] = ByteUtil.getShort(value, 5);
        } else if (dtype == 16) {
            dt[0] = ByteUtil.getShort(value, 0) & Short.MAX_VALUE;
            if (dt[0] > 9999) {
                dt[0] = (short)((short)dt[0] | 0x8000);
            }
            dt[1] = (value[1] >> 7 & 1) + ((value[2] & 7) << 1);
            dt[2] = (value[2] & 0xF8) >> 3 & 0x1F;
            dt[3] = value[3] & 0x1F;
            dt[4] = (value[3] >> 5 & 7) + ((value[4] & 7) << 3);
            dt[5] = (value[4] >> 3 & 0x1F) + ((value[5] & 1) << 5);
            dt[6] = (value[5] >> 1 & 0x7F) + ((value[6] & 0xFF) << 7) + ((value[7] & 0x1F) << 15);
            dt[6] = dt[6] * 1000;
        } else if (dtype == 23) {
            dt[0] = ByteUtil.getShort(value, 0) & Short.MAX_VALUE;
            if (dt[0] > 9999) {
                dt[0] = (short)((short)dt[0] | 0x8000);
            }
            dt[1] = (value[1] >> 7 & 1) + ((value[2] & 7) << 1);
            dt[2] = (value[2] & 0xF8) >> 3 & 0x1F;
            dt[3] = value[3] & 0x1F;
            dt[4] = (value[3] >> 5 & 7) + ((value[4] & 7) << 3);
            dt[5] = (value[4] >> 3 & 0x1F) + ((value[5] & 1) << 5);
            dt[6] = (value[5] >> 1 & 0x7F) + ((value[6] & 0xFF) << 7) + ((value[7] & 0x1F) << 15);
            dt[6] = dt[6] * 1000;
            dt[7] = ByteUtil.getShort(value, value.length - 2);
        } else if (dtype == 26) {
            dt[0] = ByteUtil.getShort(value, 0) & Short.MAX_VALUE;
            if (dt[0] > 9999) {
                dt[0] = (short)((short)dt[0] | 0x8000);
            }
            dt[1] = (value[1] >> 7 & 1) + ((value[2] & 7) << 1);
            dt[2] = (value[2] & 0xF8) >> 3 & 0x1F;
            dt[3] = value[3] & 0x1F;
            dt[4] = (value[3] >> 5 & 7) + ((value[4] & 7) << 3);
            dt[5] = (value[4] >> 3 & 0x1F) + ((value[5] & 1) << 5);
            dt[6] = (value[5] >> 1 & 0x7F) + ((value[6] & 0xFF) << 7) + ((value[7] & 0xFF) << 15) + ((value[8] & 0x7F) << 23);
        } else if (dtype == 27) {
            dt[0] = ByteUtil.getShort(value, 0) & Short.MAX_VALUE;
            if (dt[0] > 9999) {
                dt[0] = (short)((short)dt[0] | 0x8000);
            }
            dt[1] = (value[1] >> 7 & 1) + ((value[2] & 7) << 1);
            dt[2] = (value[2] & 0xF8) >> 3 & 0x1F;
            dt[3] = value[3] & 0x1F;
            dt[4] = (value[3] >> 5 & 7) + ((value[4] & 7) << 3);
            dt[5] = (value[4] >> 3 & 0x1F) + ((value[5] & 1) << 5);
            dt[6] = (value[5] >> 1 & 0x7F) + ((value[6] & 0xFF) << 7) + ((value[7] & 0xFF) << 15) + ((value[8] & 0x7F) << 23);
            dt[7] = ByteUtil.getShort(value, value.length - 2);
        }
        return dt;
    }

    private static int[] dmdtDecodeBdta(byte[] value) {
        int[] dt = new int[]{ByteUtil.getShort(value, 0), (short)(value[2] & 0xFF), (short)(value[3] & 0xFF), (short)(value[4] & 0xFF), (short)(value[5] & 0xFF), (short)(value[6] & 0xFF), (value[7] & 0xFF) + (value[8] << 8) + (value[9] << 16), ByteUtil.getShort(value, 10)};
        if (value.length > 12) {
            dt[6] = dt[6] + (value[12] << 24);
        }
        return dt;
    }

    public byte[] encode() throws SQLException {
        return this.encode(null, null);
    }

    public byte[] encode(Column column, IDmdbConnection connection) throws SQLException {
        int rscale;
        int[] dt = this.dt;
        int rtype = column != null ? column.type : this.dtype;
        int n2 = rscale = column != null ? column.scale : this.scale;
        if (column != null && column.mask == 4) {
            dt = DmdbTimestamp.transformTZ(dt, connection.getLocalTimezone(), connection.getDBTimezone());
        }
        if ((dt = DmdbTimestamp.roundHalfup(dt, rtype, rscale))[0] < -4712 || dt[0] > 9999) {
            DBError.EC_DATETIME_OVERFLOW.throwz(new Object[0]);
        }
        int year = dt[0];
        int month = dt[1];
        int day = dt[2];
        int hour = dt[3];
        int min = dt[4];
        int sec = dt[5];
        int msec = dt[6];
        int tz = dt[7] == Integer.MIN_VALUE && connection != null ? (int)connection.getLocalTimezone() : dt[7];
        byte[] ret = null;
        if (rtype == 14) {
            ret = new byte[]{(byte)(year & 0xFF), year >= 0 ? (byte)(year >> 8 | (month & 1) << 7) : (byte)(year >> 8 & ((month & 1) << 7 | 0x7F)), (byte)((month & 0xE) >> 1 | day << 3)};
        } else if (rtype == 16) {
            ret = new byte[]{(byte)(year & 0xFF), year >= 0 ? (byte)(year >> 8 | (month & 1) << 7) : (byte)(year >> 8 & ((month & 1) << 7 | 0x7F)), (byte)((month & 0xE) >> 1 | day << 3), (byte)(hour | (min & 7) << 5), (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3), (byte)((sec & 0x20) >> 5 | ((msec /= 1000) & 0x7F) << 1), (byte)(msec >> 7 & 0xFF), (byte)(msec >> 15 & 0xFF)};
        } else if (rtype == 26) {
            ret = new byte[]{(byte)(year & 0xFF), year >= 0 ? (byte)(year >> 8 | (month & 1) << 7) : (byte)(year >> 8 & ((month & 1) << 7 | 0x7F)), (byte)((month & 0xE) >> 1 | day << 3), (byte)(hour | (min & 7) << 5), (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3), (byte)((sec & 0x20) >> 5 | (msec & 0x7F) << 1), (byte)(msec >> 7 & 0xFF), (byte)(msec >> 15 & 0xFF), (byte)(msec >> 23 & 0xFF)};
        } else if (rtype == 23) {
            msec /= 1000;
            ret = new byte[10];
            ret[0] = (byte)(year & 0xFF);
            ret[1] = year >= 0 ? (byte)(year >> 8 | (month & 1) << 7) : (byte)(year >> 8 & ((month & 1) << 7 | 0x7F));
            ret[2] = (byte)((month & 0xE) >> 1 | day << 3);
            ret[3] = (byte)(hour | (min & 7) << 5);
            ret[4] = (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3);
            ret[5] = (byte)((sec & 0x20) >> 5 | (msec & 0x7F) << 1);
            ret[6] = (byte)(msec >> 7 & 0xFF);
            ret[7] = (byte)(msec >> 15 & 0xFF);
            ByteUtil.setShort(ret, 8, (short)tz);
        } else if (rtype == 27) {
            ret = new byte[11];
            ret[0] = (byte)(year & 0xFF);
            ret[1] = year >= 0 ? (byte)(year >> 8 | (month & 1) << 7) : (byte)(year >> 8 & ((month & 1) << 7 | 0x7F));
            ret[2] = (byte)((month & 0xE) >> 1 | day << 3);
            ret[3] = (byte)(hour | (min & 7) << 5);
            ret[4] = (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3);
            ret[5] = (byte)((sec & 0x20) >> 5 | (msec & 0x7F) << 1);
            ret[6] = (byte)(msec >> 7 & 0xFF);
            ret[7] = (byte)(msec >> 15 & 0xFF);
            ret[8] = (byte)(msec >> 23 & 0xFF);
            ByteUtil.setShort(ret, 9, (short)tz);
        } else if (rtype == 15) {
            ret = new byte[]{(byte)(hour | (min & 7) << 5), (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3), (byte)((sec & 0x20) >> 5 | ((msec /= 1000) & 0x7F) << 1), (byte)(msec >> 7 & 0xFF), (byte)(msec >> 15 & 0xFF)};
        } else if (rtype == 22) {
            ret = new byte[7];
            ret[0] = (byte)(hour | (min & 7) << 5);
            ret[1] = (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3);
            ret[2] = (byte)((sec & 0x20) >> 5 | ((msec /= 1000) & 0x7F) << 1);
            ret[3] = (byte)(msec >> 7 & 0xFF);
            ret[4] = (byte)(msec >> 15 & 0xFF);
            ByteUtil.setShort(ret, 5, (short)tz);
        }
        return ret;
    }

    @Override
    public long getTime() {
        return this.getTime(null);
    }

    public long getTime(Calendar calendar) {
        if (calendar == null) {
            calendar = DmdbTimestamp.getCalendar();
        }
        int year = this.dt[0];
        int month = this.dt[1] - 1;
        int day = this.dt[2];
        if (year == 0 && month == -1 && day == 0) {
            year = 1970;
            month = 0;
            day = 1;
        }
        calendar.set(Math.abs(year), month, day, this.dt[3], this.dt[4], this.dt[5]);
        calendar.set(14, this.dt[6] / 1000000);
        calendar.set(0, this.dt[0] >= 0 ? 1 : 0);
        long ret = calendar.getTimeInMillis();
        return ret;
    }

    @Override
    public void setTime(long time) {
        this.setTime(time, null);
    }

    public void setTime(long time, Calendar calendar) {
        super.setTime(time);
        long timeInMillis = time / 1000L * 1000L;
        int nanos = (int)(time % 1000L * 1000000L);
        if (nanos < 0) {
            nanos += 1000000000;
            timeInMillis = (time / 1000L - 1L) * 1000L;
        }
        if (calendar == null) {
            calendar = DmdbTimestamp.getCalendar();
        }
        calendar.setTimeInMillis(timeInMillis);
        this.dt[0] = calendar.get(0) == 1 ? calendar.get(1) : -calendar.get(1);
        this.dt[1] = calendar.get(2) + 1;
        this.dt[2] = calendar.get(5);
        this.dt[3] = calendar.get(11);
        this.dt[4] = calendar.get(12);
        this.dt[5] = calendar.get(13);
        this.dt[6] = nanos;
        this.dt[7] = Integer.MIN_VALUE;
    }

    @Override
    public int getNanos() {
        return this.dt[6];
    }

    @Override
    public void setNanos(int nano) {
        super.setNanos(nano);
        this.dt[6] = nano;
    }

    public int[] getDt() {
        return this.dt;
    }

    public int getTimezone() {
        return this.dt[7];
    }

    public void setTimezone(int tz) throws SQLException {
        if (tz <= -780 || tz > 840) {
            DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwz(new Object[0]);
        }
        this.dt[7] = tz;
    }

    public int parseString(String s2) {
        String orgStr = s2;
        try {
            String date_s = null;
            String time_s = null;
            String nanos_s = null;
            String tz_s = null;
            int year = 0;
            int month = 0;
            int day = 0;
            int hour = 0;
            int minute = 0;
            int second = 0;
            int nanos = 0;
            int firstColon = 0;
            int secondColon = 0;
            int period = 0;
            boolean sign = false;
            int ownTz = Integer.MIN_VALUE;
            String zeros = "000000000";
            if (s2 == null) {
                DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwzRuntimeException(orgStr);
            }
            if ((s2 = s2.trim()).startsWith("-", 0)) {
                s2 = s2.substring(1).trim();
                sign = true;
            }
            String[] comps = s2.split(" ");
            switch (comps.length) {
                case 3: {
                    date_s = comps[0];
                    time_s = comps[1];
                    tz_s = comps[2];
                    this.dtype = 23;
                    break;
                }
                case 2: {
                    if (comps[0].indexOf(":") > 0) {
                        time_s = comps[0];
                        tz_s = comps[1];
                        this.dtype = 22;
                        break;
                    }
                    date_s = comps[0];
                    time_s = comps[1];
                    this.dtype = 16;
                    break;
                }
                case 1: {
                    if (comps[0].indexOf(":") > 0) {
                        time_s = comps[0];
                        this.dtype = 15;
                        break;
                    }
                    date_s = comps[0];
                    this.dtype = 14;
                    break;
                }
                default: {
                    DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwzRuntimeException(orgStr);
                }
            }
            if (date_s != null) {
                int firstDash = date_s.indexOf(45);
                int secondDash = date_s.indexOf(45, firstDash + 1);
                if (firstDash < 0 || secondDash < 0) {
                    firstDash = s2.indexOf(46);
                    secondDash = s2.indexOf(46, firstDash + 1);
                }
                if (firstDash < 0 || secondDash < 0) {
                    firstDash = s2.indexOf(47);
                    secondDash = s2.indexOf(47, firstDash + 1);
                }
                if (firstDash > 0 & secondDash > 0 & secondDash < date_s.length() - 1) {
                    year = sign ? 0 - Integer.parseInt(date_s.substring(0, firstDash)) - 1900 : Integer.parseInt(date_s.substring(0, firstDash)) - 1900;
                    if (!DateUtil.checkDate(year + 1900, (month = Integer.parseInt(date_s.substring(firstDash + 1, secondDash)) - 1) + 1, day = Integer.parseInt(date_s.substring(secondDash + 1)))) {
                        DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwzRuntimeException(orgStr);
                    }
                } else {
                    DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwzRuntimeException(orgStr);
                }
            }
            if (time_s != null) {
                firstColon = time_s.indexOf(58);
                secondColon = time_s.indexOf(58, firstColon + 1);
                period = time_s.indexOf(46, secondColon + 1);
                if (firstColon > 0 & secondColon > 0 & secondColon < time_s.length() - 1) {
                    hour = Integer.parseInt(time_s.substring(0, firstColon));
                    minute = Integer.parseInt(time_s.substring(firstColon + 1, secondColon));
                    if (period > 0 & period < time_s.length() - 1) {
                        second = Integer.parseInt(time_s.substring(secondColon + 1, period));
                        nanos_s = time_s.substring(period + 1);
                        if (nanos_s.length() > 9) {
                            DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwzRuntimeException(orgStr);
                        }
                        if (!Character.isDigit(nanos_s.charAt(0))) {
                            DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwzRuntimeException(orgStr);
                        }
                        nanos_s = String.valueOf(nanos_s) + zeros.substring(0, 9 - nanos_s.length());
                        nanos = Integer.valueOf(nanos_s);
                    } else if (period > 0) {
                        DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwzRuntimeException(orgStr);
                    } else {
                        second = Integer.parseInt(time_s.substring(secondColon + 1));
                    }
                    if (hour >= 24 || hour < 0 || minute >= 60 || minute < 0 || second >= 60 || second < 0) {
                        DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwzRuntimeException(orgStr);
                    }
                } else {
                    DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwzRuntimeException(orgStr);
                }
            }
            if (tz_s != null) {
                boolean neg = false;
                if (tz_s.startsWith("-")) {
                    neg = true;
                }
                if (tz_s.startsWith("-") || tz_s.startsWith("+")) {
                    tz_s = tz_s.substring(1).trim();
                }
                String[] hm = tz_s.split(":");
                short tzh = 0;
                short tzm = 0;
                switch (hm.length) {
                    case 2: {
                        tzh = Short.parseShort(hm[0].trim());
                        tzm = Short.parseShort(hm[1].trim());
                        break;
                    }
                    case 1: {
                        tzh = Short.parseShort(hm[0].trim());
                        break;
                    }
                    default: {
                        DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwzRuntimeException(orgStr);
                    }
                }
                ownTz = (short)(tzh * 60 + tzm);
                if (ownTz < 0) {
                    DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwzRuntimeException(orgStr);
                }
                if (neg) {
                    ownTz *= -1;
                }
                if (ownTz <= -780 || ownTz > 840) {
                    DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwzRuntimeException(orgStr);
                }
            }
            this.dt[0] = year + 1900;
            this.dt[1] = month + 1;
            this.dt[2] = day == 0 ? 1 : day;
            this.dt[3] = hour;
            this.dt[4] = minute;
            this.dt[5] = second;
            this.dt[6] = nanos;
            this.dt[7] = ownTz;
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwzRuntimeException(orgStr);
        }
        this.scale = this.dtype == 14 ? 0 : 6;
        return this.dtype;
    }

    public static int[] transformTZ(int[] dt, int defaultSrcTz, int destTz) {
        int srcTz = defaultSrcTz;
        if (dt[7] != Integer.MIN_VALUE) {
            srcTz = dt[7];
        }
        if (destTz == srcTz) {
            return dt;
        }
        int[] newDt = Arrays.copyOf(dt, dt.length);
        if ((newDt = DmdbTimestamp.addMinute(newDt, destTz - srcTz))[7] != Integer.MIN_VALUE) {
            newDt[7] = destTz;
        }
        return newDt;
    }

    private static int[] roundHalfup(int[] dt, int dtype, int scale) {
        switch (dtype) {
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                if (scale >= 9) break;
                int[] newDt = Arrays.copyOf(dt, dt.length);
                int ms = dt[6];
                int pow = (int)Math.pow(10.0, 9 - scale);
                int carryDigit = ms / (int)Math.pow(10.0, 9 - scale - 1) % 10;
                newDt[6] = ms / pow * pow;
                if (carryDigit > 4) {
                    DmdbTimestamp.addNanoSecond(newDt, pow);
                }
                return newDt;
            }
        }
        return dt;
    }

    public static int[] addNanoSecond(int[] dt, int n2) {
        int ms = dt[6] + n2;
        int addSecond = ms / 1000000000;
        if ((ms %= 1000000000) < 0) {
            ms += 1000000000;
            --addSecond;
        }
        dt[6] = ms;
        DmdbTimestamp.addSecond(dt, addSecond);
        return dt;
    }

    public static int[] addSecond(int[] dt, int n2) {
        int second = dt[5] + n2;
        int addMinute = second / 60;
        if ((second %= 60) < 0) {
            second += 60;
            --addMinute;
        }
        dt[5] = second;
        DmdbTimestamp.addMinute(dt, addMinute);
        return dt;
    }

    public static int[] addMinute(int[] dt, int n2) {
        int minute = dt[4] + n2;
        int addHour = minute / 60;
        if ((minute %= 60) < 0) {
            minute += 60;
            --addHour;
        }
        dt[4] = minute;
        DmdbTimestamp.addHour(dt, addHour);
        return dt;
    }

    private static int[] addHour(int[] dt, int n2) {
        int hour = dt[3] + n2;
        int addDay = hour / 24;
        if ((hour %= 24) < 0) {
            hour += 24;
            --addDay;
        }
        dt[3] = hour;
        DmdbTimestamp.addDay(dt, addDay);
        return dt;
    }

    private static int[] addDay(int[] dt, int n2) {
        int tmp = dt[2] + n2;
        int monthDays = 0;
        while (tmp > (monthDays = DateUtil.getDaysOfMonth(dt[0], dt[1])) || tmp <= 0) {
            DmdbTimestamp.addMonth(dt, tmp > monthDays ? 1 : -1);
            int n3 = tmp = tmp > monthDays ? tmp - monthDays : tmp + monthDays;
        }
        dt[2] = tmp;
        return dt;
    }

    private static int[] addMonth(int[] dt, int n2) {
        int daysOfMonth;
        int month = dt[1] + n2;
        int addYear = month / 12;
        if ((month %= 12) < 1) {
            month += 12;
            --addYear;
        }
        if (dt[2] > (daysOfMonth = DateUtil.getDaysOfMonth(dt[0], month))) {
            dt[2] = daysOfMonth;
        }
        dt[1] = month;
        DmdbTimestamp.addYear(dt, addYear);
        return dt;
    }

    private static int[] addYear(int[] dt, int n2) {
        dt[0] = dt[0] + n2;
        return dt;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DmdbTimestamp)) {
            return false;
        }
        DmdbTimestamp objTs = (DmdbTimestamp)obj;
        return objTs.dtype == this.dtype && objTs.scale == this.scale && Arrays.equals(this.dt, objTs.dt);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.dtype;
        result = 31 * result + this.scale;
        result = 31 * result + Arrays.hashCode(this.dt);
        return result;
    }

    public static void main(String[] args) throws SQLException {
        DmdbTimestamp t2;
        DmdbTimestamp ts = t2 = DmdbTimestamp.valueOf("2018-09-07 16:09:13.123456");
        System.out.println(ts);
    }
}

