/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.util.ByteUtil;
import java.io.Writer;
import java.sql.SQLException;

public class DmdbWriter
extends Writer {
    public static final int IS_BLOB = 1;
    public static final int IS_CLOB = 2;
    private int typeFlag;
    private Object obj;
    private long objPos;
    private char[] buf;
    private int bufPos;

    public DmdbWriter(Object object, long l2) {
        this.obj = object;
        this.objPos = l2;
        this.buf = new char[32640];
        this.bufPos = 0;
        if (object instanceof DmdbBlob) {
            this.typeFlag = 1;
        } else if (object instanceof DmdbClob) {
            this.typeFlag = 2;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        }
    }

    @Override
    public void write(int n2) {
        char[] cArray = new char[]{(char)n2};
        this.write(cArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n2, int n3) {
        Object object = this.lock;
        synchronized (object) {
            if (n2 < 0) {
                DBError.throwIOException("off IndexOutOfBounds :" + n2);
            }
            if (n3 < 0) {
                DBError.throwIOException("len IndexOutOfBounds :" + n3);
            }
            if (n2 + n3 > cArray.length) {
                DBError.throwIOException("off + len IndexOutOfBounds :" + n2 + n3);
            }
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.bufLeaveLen();
                if (n5 == 0) {
                    this.flush();
                    n5 = this.bufLeaveLen();
                }
                int n6 = Math.min(n5, n3 - n4);
                System.arraycopy(cArray, n2, this.buf, this.bufPos, n6);
                n4 += n6;
                this.bufPos += n6;
                n2 += n6;
            }
        }
    }

    @Override
    public void write(char[] cArray) {
        super.write(cArray);
    }

    @Override
    public Writer append(char c2) {
        return super.append(c2);
    }

    @Override
    public Writer append(CharSequence charSequence) {
        return super.append(charSequence);
    }

    @Override
    public Writer append(CharSequence charSequence, int n2, int n3) {
        return super.append(charSequence, n2, n3);
    }

    @Override
    public void write(String string) {
        super.write(string);
    }

    @Override
    public void write(String string, int n2, int n3) {
        super.write(string, n2, n3);
    }

    @Override
    public void flush() {
        if (this.bufPos <= 0) {
            return;
        }
        try {
            switch (this.typeFlag) {
                case 1: {
                    this.writeToBlob();
                    break;
                }
                case 2: {
                    this.writeToClob();
                    break;
                }
                default: {
                    DBError.throwIOException("Fatal error occured in DmdbWriter ");
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    private int bufLeaveLen() {
        return this.buf == null ? 0 : this.buf.length - this.bufPos;
    }

    private void writeToBlob() {
        if (this.bufPos <= 0) {
            return;
        }
        DmdbBlob dmdbBlob = (DmdbBlob)this.obj;
        byte[] byArray = ByteUtil.fromString(String.valueOf(this.buf, 0, this.bufPos), dmdbBlob.connection.getServerEncoding());
        int n2 = byArray == null ? 0 : dmdbBlob.do_setBytes(this.objPos, byArray, 0, byArray.length);
        this.objPos += (long)n2;
        this.bufPos = 0;
    }

    private void writeToClob() {
        if (this.bufPos <= 0) {
            return;
        }
        DmdbClob dmdbClob = (DmdbClob)this.obj;
        String string = String.valueOf(this.buf, 0, this.bufPos);
        int n2 = dmdbClob.do_setString(this.objPos, string);
        this.objPos += (long)n2;
        this.bufPos = 0;
    }
}

