/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.util.Buffer$Node;
import dm.jdbc.util.ByteUtil;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;

public class Buffer {
    private boolean adaptive;
    private boolean direct;
    private int count;
    private Buffer$Node current;
    private Buffer$Node first;
    private Buffer$Node last;

    public static final Buffer allocate(int n2, boolean bl, boolean bl2) {
        return new Buffer(n2, bl, bl2);
    }

    public static final Buffer wrap(byte[] byArray, boolean bl, boolean bl2) {
        return Buffer.wrap(byArray, 0, byArray.length, bl, bl2);
    }

    public static final Buffer wrap(byte[] byArray, int n2, int n3, boolean bl, boolean bl2) {
        return new Buffer(byArray, n2, n3, bl, bl2);
    }

    Buffer(int n2, boolean bl, boolean bl2) {
        this.adaptive = bl;
        this.direct = bl2;
        this.count = 1;
        this.first = this.last = new Buffer$Node(this, n2, bl2);
        this.current = this.last;
    }

    Buffer(byte[] byArray, int n2, int n3, boolean bl, boolean bl2) {
        this.adaptive = bl;
        this.direct = bl2;
        this.count = 1;
        this.first = this.last = new Buffer$Node(this, byArray, n2, n3);
        this.current = this.last;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[" + this.count + "]: ");
        Buffer$Node buffer$Node = this.first;
        while (buffer$Node != null) {
            if (buffer$Node != this.first) {
                stringBuilder.append(" <-> ");
            }
            if (buffer$Node == this.current) {
                stringBuilder.append("*");
            }
            stringBuilder.append("{");
            stringBuilder.append(buffer$Node);
            stringBuilder.append("}");
            buffer$Node = buffer$Node.next;
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        String string = "utf-8";
        Buffer buffer = Buffer.allocate(4, true, false);
        byte[] byArray = new byte[5];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byte[] byArray2 = byArray;
        buffer.writeBytes(byArray2);
        System.out.println(buffer);
        buffer.writeInt(123);
        System.out.println(buffer);
        buffer.writeStringWithNTS("just for test", string);
        buffer.rewind(0);
        System.out.println(buffer);
        System.out.println(Arrays.toString(buffer.readBytes(byArray2.length)));
        System.out.println(buffer.readInt());
        System.out.println(buffer.readStringWithNTS(string));
        System.out.println(buffer);
        System.out.println(buffer.length());
        buffer.clear(5);
        System.out.println(buffer);
        System.out.println(buffer.length());
        System.out.println(buffer.offset(true));
        System.out.println(buffer.offset(false));
        buffer.clear(0);
        System.out.println(buffer);
        buffer.writeStringWithNTS("JUST FOR TEST...", string);
        System.out.println(buffer);
        buffer.rewind(0);
        System.out.println(buffer.readStringWithNTS(string));
        buffer.replace(0, 4, "jut".getBytes());
        System.out.println(buffer);
        buffer.rewind(0);
        System.out.println(buffer.readStringWithNTS(string));
    }

    public int capacity() {
        if (this.adaptive) {
            return Integer.MAX_VALUE;
        }
        int n2 = 0;
        Buffer$Node buffer$Node = this.first;
        while (buffer$Node != null) {
            n2 += Buffer$Node.access$0(buffer$Node);
            buffer$Node = buffer$Node.next;
        }
        return n2;
    }

    public int length() {
        int n2 = 0;
        Buffer$Node buffer$Node = this.first;
        while (buffer$Node != null) {
            n2 += Buffer$Node.access$1(buffer$Node, true);
            buffer$Node = buffer$Node.next;
        }
        return n2;
    }

    public Buffer clear(int n2) {
        Buffer$Node buffer$Node = this.locate(n2);
        Buffer$Node.access$2(buffer$Node, buffer$Node.extra);
        this.current = buffer$Node;
        buffer$Node = buffer$Node.next;
        while (buffer$Node != null) {
            Buffer$Node.access$2(buffer$Node, 0);
            buffer$Node = buffer$Node.next;
        }
        return this;
    }

    public Buffer rewind(int n2) {
        Buffer$Node buffer$Node = this.locate(n2);
        Buffer$Node.access$3(buffer$Node, buffer$Node.extra);
        this.current = buffer$Node;
        buffer$Node = this.first;
        while (buffer$Node != this.current) {
            Buffer$Node.access$3(buffer$Node, buffer$Node.write);
            buffer$Node = buffer$Node.next;
        }
        buffer$Node = this.current.next;
        while (buffer$Node != null) {
            Buffer$Node.access$3(buffer$Node, 0);
            buffer$Node = buffer$Node.next;
        }
        return this;
    }

    public int offset(boolean bl) {
        int n2 = bl ? this.current.write : this.current.read;
        Buffer$Node buffer$Node = this.first;
        while (buffer$Node != this.current) {
            n2 += Buffer$Node.access$0(buffer$Node);
            buffer$Node = buffer$Node.next;
        }
        return n2;
    }

    public int available(boolean bl) {
        if (!bl) {
            int n2 = 0;
            Buffer$Node buffer$Node = this.current;
            while (buffer$Node != null) {
                n2 += Buffer$Node.access$4(buffer$Node, false);
                buffer$Node = buffer$Node.next;
            }
            return n2;
        }
        return this.adaptive ? Integer.MAX_VALUE : Buffer$Node.access$4(this.current, true);
    }

    public Buffer skip(int n2, boolean bl, boolean bl2) {
        while (n2 > 0) {
            if ((n2 -= Buffer$Node.access$5(this.current, n2, bl, bl2)) == 0) break;
            Buffer$Node buffer$Node = this.current = bl2 ? this.current.next : this.current.prev;
            if (this.current != null) continue;
            throw new RuntimeException("index out of range");
        }
        return this;
    }

    public Buffer insert(int n2, byte[] byArray) {
        return this.replace(n2, 0, byArray);
    }

    public Buffer replace(int n2, int n3, byte[] byArray) {
        int n4 = this.length();
        this.rewind(n2 + n3);
        byte[] byArray2 = this.readBytes(n4 - n2 - n3);
        this.clear(n2);
        this.writeBytes(byArray);
        this.writeBytes(byArray2);
        return this;
    }

    public int load(ReadableByteChannel readableByteChannel, int n2, boolean bl) {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = Buffer$Node.access$6(this.current, readableByteChannel, n2, bl);
            n3 += n4;
            if ((n2 -= n4) == 0) break;
            this.current = this.current.next;
            if (this.current != null) continue;
            if (this.adaptive) {
                this.extend(n2);
                continue;
            }
            throw new RuntimeException("index out of range");
        }
        return n3;
    }

    public int flush(WritableByteChannel writableByteChannel, boolean bl) {
        int n2 = 0;
        Buffer$Node buffer$Node = this.first;
        do {
            n2 += Buffer$Node.access$7(buffer$Node, writableByteChannel, bl);
        } while ((buffer$Node = buffer$Node.next) != null);
        return n2;
    }

    private void extend(int n2) {
        int n3 = 2 * Buffer$Node.access$0(this.last);
        n2 = n2 > n3 ? n2 : n3;
        this.current = new Buffer$Node(this, n2, this.direct);
        this.current.prev = this.last;
        this.last.next = this.current;
        this.last = this.current;
        ++this.count;
    }

    private Buffer$Node locate(int n2) {
        Buffer$Node buffer$Node = this.first;
        while (buffer$Node != null) {
            int n3 = Buffer$Node.access$0(buffer$Node);
            if (n2 < n3) break;
            n2 -= n3;
            buffer$Node = buffer$Node.next;
        }
        if (buffer$Node == null) {
            throw new RuntimeException("index out of range");
        }
        buffer$Node.extra = n2;
        return buffer$Node;
    }

    public int writeBoolean(boolean bl) {
        return this.writeBytes(new byte[]{bl ? (byte)1 : 0});
    }

    public int writeByte(byte by) {
        return this.writeBytes(ByteUtil.fromByte(by));
    }

    public int writeShort(short s2) {
        return this.writeBytes(ByteUtil.fromShort(s2));
    }

    public int writeInt(int n2) {
        return this.writeBytes(ByteUtil.fromInt(n2));
    }

    public int writeUB1(int n2) {
        return this.writeBytes(ByteUtil.fromUB1(n2));
    }

    public int writeUB2(int n2) {
        return this.writeBytes(ByteUtil.fromUB2(n2));
    }

    public int writeUB3(int n2) {
        return this.writeBytes(ByteUtil.fromUB3(n2));
    }

    public int writeUB4(long l2) {
        return this.writeBytes(ByteUtil.fromUB4(l2));
    }

    public int writeLong(long l2) {
        return this.writeBytes(ByteUtil.fromLong(l2));
    }

    public int writeFloat(float f2) {
        return this.writeBytes(ByteUtil.fromInt(Float.floatToIntBits(f2)));
    }

    public int writeDouble(double d2) {
        return this.writeBytes(ByteUtil.fromLong(Double.doubleToLongBits(d2)));
    }

    public int writeBytes(byte[] byArray) {
        return this.writeBytes(byArray, 0, byArray.length);
    }

    public int writeBytes(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        while (n4 < n2 + n3) {
            if (Buffer$Node.access$4(this.current, true) > 0) {
                this.current.buffer.put(this.current.write++, byArray[n4]);
            } else {
                this.current = this.current.next;
                if (this.current != null) {
                    --n4;
                } else {
                    if (!this.adaptive) {
                        throw new RuntimeException("index out of range");
                    }
                    this.extend(n3 - n4);
                    --n4;
                }
            }
            ++n4;
        }
        return n3;
    }

    public int writeBytesWithLength(byte[] byArray) {
        return this.writeBytesWithLength(byArray, 0, byArray.length);
    }

    public int writeBytesWithLength(byte[] byArray, int n2, int n3) {
        return this.writeInt(n3) + this.writeBytes(byArray, n2, n3);
    }

    public int writeBytesWithLength1(byte[] byArray) {
        return this.writeBytesWithLength1(byArray, 0, byArray.length);
    }

    public int writeBytesWithLength1(byte[] byArray, int n2, int n3) {
        return this.writeUB1(n3) + this.writeBytes(byArray, n2, n3);
    }

    public int writeBytesWithLength2(byte[] byArray) {
        return this.writeBytesWithLength2(byArray, 0, byArray.length);
    }

    public int writeBytesWithLength2(byte[] byArray, int n2, int n3) {
        return this.writeUB2(n3) + this.writeBytes(byArray, n2, n3);
    }

    public int writeBytesWithLength3(byte[] byArray) {
        return this.writeBytesWithLength3(byArray, 0, byArray.length);
    }

    public int writeBytesWithLength3(byte[] byArray, int n2, int n3) {
        return this.writeUB3(n3) + this.writeBytes(byArray, n2, n3);
    }

    public int writeBytesWithNTS(byte[] byArray, int n2, int n3) {
        return this.writeBytes(byArray) + this.writeByte((byte)0);
    }

    public int writeStringWithLength(String string, String string2) {
        byte[] byArray = ByteUtil.fromString(string, string2);
        return this.writeBytesWithLength(byArray, 0, byArray.length);
    }

    public int writeStringWithLength1(String string, String string2) {
        byte[] byArray = ByteUtil.fromString(string, string2);
        return this.writeBytesWithLength1(byArray, 0, byArray.length);
    }

    public int writeStringWithLength2(String string, String string2) {
        byte[] byArray = ByteUtil.fromString(string, string2);
        return this.writeBytesWithLength2(byArray, 0, byArray.length);
    }

    public int writeStringWithLength3(String string, String string2) {
        byte[] byArray = ByteUtil.fromString(string, string2);
        return this.writeBytesWithLength3(byArray, 0, byArray.length);
    }

    public int writeStringWithNTS(String string, String string2) {
        byte[] byArray = ByteUtil.fromString(string, string2);
        return this.writeBytesWithNTS(byArray, 0, byArray.length);
    }

    public byte readByte() {
        return ByteUtil.toByte(this.readBytes(1));
    }

    public short readShort() {
        return ByteUtil.toShort(this.readBytes(2));
    }

    public int readInt() {
        return ByteUtil.toInt(this.readBytes(4));
    }

    public long readLong() {
        return ByteUtil.toLong(this.readBytes(8));
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public int readUB1() {
        return ByteUtil.toUB1(this.readBytes(1));
    }

    public int readUB2() {
        return ByteUtil.toUB2(this.readBytes(2));
    }

    public int readUB3() {
        return ByteUtil.toUB3(this.readBytes(3));
    }

    public long readUB4() {
        return ByteUtil.toUB4(this.readBytes(4));
    }

    public byte[] readBytes(int n2) {
        return this.readBytes(new byte[n2], 0, n2);
    }

    public byte[] readBytes(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        while (n4 < n2 + n3) {
            if (Buffer$Node.access$4(this.current, false) > 0) {
                byArray[n4] = this.current.buffer.get(this.current.read++);
            } else {
                this.current = this.current.next;
                if (this.current == null) {
                    throw new RuntimeException("index out of range");
                }
                --n4;
            }
            ++n4;
        }
        return byArray;
    }

    public byte[] readBytesWithLength() {
        return this.readBytes(this.readInt());
    }

    public byte[] readBytesWithLength1() {
        return this.readBytes(this.readUB1());
    }

    public byte[] readBytesWithLength2() {
        return this.readBytes(this.readUB2());
    }

    public byte[] readBytesWithLength3() {
        return this.readBytes(this.readUB3());
    }

    public byte[] readBytesWithNTS() {
        int n2 = 0;
        do {
            ++n2;
        } while (this.readByte() != 0);
        this.skip(n2, false, false);
        return this.readBytes(n2 - 1);
    }

    public String readString(int n2, String string) {
        return ByteUtil.toString(this.readBytes(n2), string);
    }

    public String readStringWithLength(String string) {
        return ByteUtil.toString(this.readBytesWithLength(), string);
    }

    public String readStringWithLength1(String string) {
        return ByteUtil.toString(this.readBytesWithLength1(), string);
    }

    public String readStringWithLength2(String string) {
        return ByteUtil.toString(this.readBytesWithLength2(), string);
    }

    public String readStringWithLength3(String string) {
        return ByteUtil.toString(this.readBytesWithLength3(), string);
    }

    public String readStringWithNTS(String string) {
        return ByteUtil.toString(this.readBytesWithNTS(), string);
    }

    public int setByte(int n2, byte by) {
        return this.setBytes(n2, ByteUtil.fromByte(by));
    }

    public int setShort(int n2, short s2) {
        return this.setBytes(n2, ByteUtil.fromShort(s2));
    }

    public int setInt(int n2, int n3) {
        return this.setBytes(n2, ByteUtil.fromInt(n3));
    }

    public int setLong(int n2, long l2) {
        return this.setBytes(n2, ByteUtil.fromLong(l2));
    }

    public int setFloat(int n2, float f2) {
        return this.setInt(n2, Float.floatToIntBits(f2));
    }

    public int setDouble(int n2, double d2) {
        return this.setLong(n2, Double.doubleToLongBits(d2));
    }

    public int setUB1(int n2, int n3) {
        return this.setBytes(n2, ByteUtil.fromUB1(n3));
    }

    public int setUB2(int n2, int n3) {
        return this.setBytes(n2, ByteUtil.fromUB2(n3));
    }

    public int setUB3(int n2, int n3) {
        return this.setBytes(n2, ByteUtil.fromUB3(n3));
    }

    public int setUB4(int n2, long l2) {
        return this.setBytes(n2, ByteUtil.fromUB4(l2));
    }

    public int setBytes(int n2, byte[] byArray) {
        return this.setBytes(n2, byArray, 0, byArray.length);
    }

    public int setBytes(int n2, byte[] byArray, int n3, int n4) {
        Buffer$Node buffer$Node = this.locate(n2);
        n2 = buffer$Node.extra;
        int n5 = n3;
        while (n5 < n3 + n4) {
            if (n2 < Buffer$Node.access$0(buffer$Node)) {
                buffer$Node.buffer.put(n2++, byArray[n5]);
            } else {
                buffer$Node = buffer$Node.next;
                if (buffer$Node == null) {
                    throw new RuntimeException("index out of range");
                }
                --n5;
                n2 = 0;
            }
            ++n5;
        }
        return n4;
    }

    public int setBytesWithLength(int n2, byte[] byArray) {
        return this.setBytesWithLength(n2, byArray, 0, byArray.length);
    }

    public int setBytesWithLength(int n2, byte[] byArray, int n3, int n4) {
        return this.setInt(n2, n4) + this.setBytes(n2 + 4, byArray, n3, n4);
    }

    public int setBytesWithLength1(int n2, byte[] byArray) {
        return this.setBytesWithLength1(n2, byArray, 0, byArray.length);
    }

    public int setBytesWithLength1(int n2, byte[] byArray, int n3, int n4) {
        return this.setUB1(n2, n4) + this.setBytes(n2 + 1, byArray, n3, n4);
    }

    public int setBytesWithLength2(int n2, byte[] byArray) {
        return this.setBytesWithLength2(n2, byArray, 0, byArray.length);
    }

    public int setBytesWithLength2(int n2, byte[] byArray, int n3, int n4) {
        return this.setUB2(n2, n4) + this.setBytes(n2 + 2, byArray, n3, n4);
    }

    public int setBytesWithLength3(int n2, byte[] byArray) {
        return this.setBytesWithLength3(n2, byArray, 0, byArray.length);
    }

    public int setBytesWithLength3(int n2, byte[] byArray, int n3, int n4) {
        return this.setUB3(n2, n4) + this.setBytes(n2 + 3, byArray, n3, n4);
    }

    public int setBytesWithNTS(int n2, byte[] byArray) {
        return this.setBytes(n2, byArray, 0, byArray.length) + this.setByte(n2 + byArray.length, (byte)0);
    }

    public int setStringWithLength(int n2, String string, String string2) {
        byte[] byArray = ByteUtil.fromString(string, string2);
        return this.setBytesWithLength(n2, byArray, 0, byArray.length);
    }

    public int setStringWithLength1(int n2, String string, String string2) {
        byte[] byArray = ByteUtil.fromString(string, string2);
        return this.setBytesWithLength1(n2, byArray, 0, byArray.length);
    }

    public int setStringWithLength2(int n2, String string, String string2) {
        byte[] byArray = ByteUtil.fromString(string, string2);
        return this.setBytesWithLength2(n2, byArray, 0, byArray.length);
    }

    public int setStringWithLength3(int n2, String string, String string2) {
        byte[] byArray = ByteUtil.fromString(string, string2);
        return this.setBytesWithLength3(n2, byArray, 0, byArray.length);
    }

    public int setStringWithNTS(int n2, String string, String string2) {
        byte[] byArray = ByteUtil.fromString(string, string2);
        return this.setBytesWithNTS(n2, byArray);
    }

    public byte getByte(int n2) {
        return ByteUtil.toByte(this.getBytes(n2, 1));
    }

    public short getShort(int n2) {
        return ByteUtil.toShort(this.getBytes(n2, 2));
    }

    public int getInt(int n2) {
        return ByteUtil.toInt(this.getBytes(n2, 4));
    }

    public long getLong(int n2) {
        return ByteUtil.toLong(this.getBytes(n2, 8));
    }

    public float getFloat(int n2) {
        return ByteUtil.toFloat(this.getBytes(n2, 4));
    }

    public double getDouble(int n2) {
        return ByteUtil.toLong(this.getBytes(n2, 8));
    }

    public int getUB1(int n2) {
        return ByteUtil.toUB1(this.getBytes(n2, 1));
    }

    public int getUB2(int n2) {
        return ByteUtil.toUB2(this.getBytes(n2, 2));
    }

    public int getUB3(int n2) {
        return ByteUtil.toUB3(this.getBytes(n2, 3));
    }

    public long getUB4(int n2) {
        return ByteUtil.toUB4(this.getBytes(n2, 4));
    }

    public byte[] getBytes(int n2, int n3) {
        return this.getBytes(n2, new byte[n3], 0, n3);
    }

    public byte[] getBytes(int n2, byte[] byArray) {
        return this.getBytes(n2, byArray, 0, byArray.length);
    }

    public byte[] getBytes(int n2, byte[] byArray, int n3, int n4) {
        Buffer$Node buffer$Node = this.locate(n2);
        n2 = buffer$Node.extra;
        int n5 = n3;
        while (n5 < n3 + n4) {
            if (n2 < Buffer$Node.access$0(buffer$Node)) {
                byArray[n5] = buffer$Node.buffer.get(n2++);
            } else {
                buffer$Node = buffer$Node.next;
                if (buffer$Node == null) {
                    throw new RuntimeException("index out of range");
                }
                --n5;
                n2 = 0;
            }
            ++n5;
        }
        return byArray;
    }

    public byte[] getBytesWithLength(int n2) {
        return this.getBytes(n2 + 4, this.getInt(n2));
    }

    public byte[] getBytesWithLength1(int n2) {
        return this.getBytes(n2 + 1, this.getUB1(n2));
    }

    public byte[] getBytesWithLength2(int n2) {
        return this.getBytes(n2 + 2, this.getUB2(n2));
    }

    public byte[] getBytesWithLength3(int n2) {
        return this.getBytes(n2 + 3, this.getUB3(n2));
    }

    public byte[] getBytesWithNTS(int n2) {
        int n3 = 0;
        int n4 = n2;
        while (this.getByte(n2++) != 0) {
            ++n3;
        }
        return this.getBytes(n4, n3);
    }

    public String getStringWithLength(int n2, String string) {
        byte[] byArray = this.getBytesWithLength(n2);
        return ByteUtil.toString(byArray, string);
    }

    public String getStringWithLength1(int n2, String string) {
        byte[] byArray = this.getBytesWithLength1(n2);
        return ByteUtil.toString(byArray, string);
    }

    public String getStringWithLength2(int n2, String string) {
        byte[] byArray = this.getBytesWithLength2(n2);
        return ByteUtil.toString(byArray, string);
    }

    public String getStringWithLength3(int n2, String string) {
        byte[] byArray = this.getBytesWithLength3(n2);
        return ByteUtil.toString(byArray, string);
    }

    public String getStringWithNTS(int n2, String string) {
        byte[] byArray = this.getBytesWithNTS(n2);
        return ByteUtil.toString(byArray, string);
    }
}

