/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.xa;

import dm.jdbc.dbaccess.DmdbCSI;
import dm.jdbc.driver.DmdbConnection_bs;
import java.sql.Connection;
import java.util.ArrayList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class DmdbXAResource
implements XAResource {
    public boolean recoverd = false;
    Connection conn;
    int m_timeout;
    Xid m_xid;

    public DmdbXAResource() {
        this.conn = null;
        this.m_timeout = 60;
    }

    public DmdbXAResource(Connection connection) {
        this.conn = connection;
        this.m_timeout = 60;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void setRecoverd(boolean recoverd) {
        this.recoverd = recoverd;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        int k = onePhase ? 0x40000000 : 0;
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            DmdbCSI.xa_process((DmdbConnection_bs)this.conn, 1, xid, k);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {}
    }

    public void end(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        if (flags != 0x4000000 && flags != 0x20000000 && flags != 0x2000000) {
            throw new XAException(-5);
        }
        try {
            DmdbCSI.xa_process((DmdbConnection_bs)this.conn, 2, xid, flags);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {}
    }

    public void forget(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            DmdbCSI.xa_process((DmdbConnection_bs)this.conn, 3, xid, 0);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {}
    }

    public int getTransactionTimeout() throws XAException {
        return this.m_timeout;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        Connection connection = null;
        if (!(xares instanceof DmdbXAResource)) {
            return false;
        }
        connection = ((DmdbXAResource)xares).getConnection();
        if (connection == null) {
            return false;
        }
        String url = ((DmdbConnection_bs)connection).getUrl();
        return connection.equals(this.conn) || url.equals(((DmdbConnection_bs)this.conn).getUrl());
    }

    public int prepare(Xid xid) throws XAException {
        int retcode = 0;
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            retcode = DmdbCSI.xa_process((DmdbConnection_bs)this.conn, 4, xid, 0);
            if (retcode != 0 && retcode != 3) {
                throw new XAException();
            }
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {}
        return retcode;
    }

    public Xid[] recover(int flag) throws XAException {
        ArrayList<Xid> rec_xids = new ArrayList<Xid>();
        Xid[] xids = null;
        Xid[] tmp = null;
        if (flag != 0x1000000 && flag != 0x800000 && flag != 0 && flag != 0x1800000) {
            throw new XAException(-5);
        }
        try {
            this.recoverd = false;
            tmp = DmdbCSI.xa_recover(this, 0x1000000);
            if (this.recoverd) {
                return tmp;
            }
            int i = 0;
            while (i < tmp.length) {
                rec_xids.add(tmp[i]);
                ++i;
            }
            do {
                tmp = DmdbCSI.xa_recover(this, 0);
                i = 0;
                while (i < tmp.length) {
                    rec_xids.add(tmp[i]);
                    ++i;
                }
            } while (!this.recoverd);
            xids = new Xid[rec_xids.size()];
            xids = (Xid[])rec_xids.toArray();
            return xids;
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {
            return xids;
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            DmdbCSI.xa_process((DmdbConnection_bs)this.conn, 6, xid, 0);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {}
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (seconds < 0) {
            throw new XAException(-5);
        }
        this.m_timeout = seconds;
        return true;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        if (flags != 0 && flags != 0x200000 && flags != 0x8000000) {
            throw new XAException(-5);
        }
        try {
            DmdbCSI.xa_process((DmdbConnection_bs)this.conn, 7, xid, flags);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {}
    }

    public void heurCommit(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            DmdbCSI.xa_process((DmdbConnection_bs)this.conn, 8, xid, 0);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {}
    }

    public void heurRollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            DmdbCSI.xa_process((DmdbConnection_bs)this.conn, 9, xid, 0);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {}
    }
}

