/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.pool;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.pool.DmdbConnectionEventListener_bs;
import dm.jdbc.pool.DmdbConnectionPoolDataSource_bs;
import dm.jdbc.pool.DmdbDataSource_bs;
import dm.jdbc.pool.DmdbPooledConnection_bs;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class DmdbConnectionCache_bs
extends DmdbDataSource_bs
implements Serializable,
Referenceable {
    private static final long serialVersionUID = -7503863927581289230L;
    private ConnectionPoolDataSource connectionPoolDataSource;
    private static final int DEFAULT_MIN_LIMIT = 0;
    private static final int DEFAULT_MAX_LIMIT = 10;
    private int MIN_LIMIT = 0;
    private int MAX_LIMIT = 10;
    private Stack<PooledConnection> cache = new Stack();
    private Hashtable<DmdbPooledConnection_bs, DmdbPooledConnection_bs> activeCache = new Hashtable();
    private int cacheSize = 0;
    private int activeSize = 0;
    private int cacheScheme = 1;
    public static final int DYNAMIC_SCHEME = 1;
    public static final int FIXED_WAIT_SCHEME = 2;
    public static final int FIXED_RETURN_NULL_SCHEME = 3;
    private DmdbConnectionEventListener_bs connectionEventListener;

    public DmdbConnectionCache_bs() throws SQLException {
        this(null);
    }

    public DmdbConnectionCache_bs(ConnectionPoolDataSource connectionpooldatasource) throws SQLException {
        this.connectionPoolDataSource = connectionpooldatasource;
        this.connectionEventListener = new DmdbConnectionEventListener_bs(this);
    }

    private void checkCredentials(String user, String password) throws SQLException {
        String l_user = null;
        String l_password = null;
        if (this.connectionPoolDataSource != null) {
            l_user = ((DmdbConnectionPoolDataSource_bs)this.connectionPoolDataSource).getUser();
            l_password = ((DmdbConnectionPoolDataSource_bs)this.connectionPoolDataSource).getPassword();
        }
        if (user != null && !user.equals(l_user) || password != null && !password.equals(l_password)) {
            throw new SQLException("Cannot create a connection with user as " + user + " as it is doesnt match the existing user " + this.user + " Or the Password");
        }
    }

    public synchronized void close() throws SQLException {
        Enumeration<DmdbPooledConnection_bs> enumeration = this.activeCache.keys();
        while (enumeration.hasMoreElements()) {
            DmdbPooledConnection_bs dmpooledconnection1 = enumeration.nextElement();
            DmdbPooledConnection_bs dmpooledconnection = this.activeCache.get(dmpooledconnection1);
            this.reusePooledConnection(dmpooledconnection);
        }
        while (!this.cache.empty()) {
            this.closeSingleConnection((DmdbPooledConnection_bs)this.cache.pop());
        }
        this.cache = null;
        this.activeCache = null;
    }

    public synchronized void closePooledConnection(PooledConnection pooledconnection) throws SQLException {
        this.detachSingleConnection(pooledconnection);
        this.closeSingleConnection(pooledconnection);
    }

    private void closeSingleConnection(PooledConnection pooledconnection) throws SQLException {
        --this.cacheSize;
        pooledconnection.close();
        pooledconnection = null;
    }

    private void detachSingleConnection(PooledConnection pooledconnection) {
        --this.activeSize;
        pooledconnection.removeConnectionEventListener(this.connectionEventListener);
        this.activeCache.remove(pooledconnection);
    }

    public int getActiveSize() {
        return this.activeSize;
    }

    public synchronized int getCacheScheme() {
        return this.cacheScheme;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Connection getConnection(String user, String password) throws SQLException {
        DmdbPooledConnection_bs dmpooledconnection;
        if (!this.cache.empty()) {
            this.checkCredentials(user, password);
            dmpooledconnection = (DmdbPooledConnection_bs)this.cache.pop();
        } else if (this.cacheSize < this.MAX_LIMIT || this.cacheScheme == 1) {
            String l_user = null;
            String l_password = null;
            if (this.connectionPoolDataSource != null) {
                l_user = ((DmdbConnectionPoolDataSource_bs)this.connectionPoolDataSource).getUser();
                l_password = ((DmdbConnectionPoolDataSource_bs)this.connectionPoolDataSource).getPassword();
            }
            if (this.cacheSize > 0 && user != null && !user.equals(l_user)) {
                DBError.throwSQLException(DmSvcConf.res.getString("error.username.differ"));
            } else if (user != null) {
                this.user = user;
                if (this.connectionPoolDataSource != null) {
                    ((DmdbConnectionPoolDataSource_bs)this.connectionPoolDataSource).setUser(user);
                }
            }
            if (this.cacheSize > 0 && password != null && !password.equals(l_password)) {
                DBError.throwSQLException(DmSvcConf.res.getString("error.password.differ"));
            } else if (password != null) {
                this.password = password;
                if (this.connectionPoolDataSource != null) {
                    ((DmdbConnectionPoolDataSource_bs)this.connectionPoolDataSource).setPassword(password);
                }
            }
            dmpooledconnection = this.getNewPoolConnection();
            ++this.cacheSize;
        } else {
            if (this.cacheScheme == 3) {
                return null;
            }
            this.checkCredentials(user, password);
            while (this.cache.empty()) {
                Stack<PooledConnection> stack = this.cache;
                synchronized (stack) {
                    try {
                        this.cache.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            dmpooledconnection = (DmdbPooledConnection_bs)this.cache.pop();
        }
        if (dmpooledconnection != null) {
            dmpooledconnection.addConnectionEventListener(this.connectionEventListener);
            this.activeCache.put(dmpooledconnection, dmpooledconnection);
            ++this.activeSize;
            return dmpooledconnection.getConnection();
        }
        return null;
    }

    public synchronized int getMaxLimit() {
        return this.MAX_LIMIT;
    }

    public synchronized int getMinLimit() {
        return this.MIN_LIMIT;
    }

    private synchronized DmdbPooledConnection_bs getNewPoolConnection() throws SQLException {
        if (this.connectionPoolDataSource == null) {
            if (this.user == null || this.password == null) {
                DBError.throwSQLException(DmSvcConf.res.getString("error.UserOrPwd.null"));
            }
            this.connectionPoolDataSource = new DmdbConnectionPoolDataSource_bs();
            ((DmdbConnectionPoolDataSource_bs)this.connectionPoolDataSource).setUser(this.user);
            ((DmdbConnectionPoolDataSource_bs)this.connectionPoolDataSource).setPassword(this.password);
            ((DmdbConnectionPoolDataSource_bs)this.connectionPoolDataSource).setURL(super.getURL());
        }
        return (DmdbPooledConnection_bs)this.connectionPoolDataSource.getPooledConnection();
    }

    public Reference getReference() throws NamingException {
        String factoryName = "dm.jdbc.pool.DmdbDataSourceFactory_bs";
        Reference ref = new Reference(this.getClass().getName(), factoryName, null);
        ref.add(new StringRefAddr("url", this.getURL()));
        ref.add(new StringRefAddr("server", this.getServer()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("database", this.getDatabase()));
        ref.add(new StringRefAddr("minLimit", Integer.toString(this.MIN_LIMIT)));
        ref.add(new StringRefAddr("maxLimit", Integer.toString(this.MAX_LIMIT)));
        ref.add(new StringRefAddr("cacheScheme", Integer.toString(this.cacheScheme)));
        return ref;
    }

    public void reusePooledConnection(PooledConnection pooledconnection) throws SQLException {
        this.detachSingleConnection(pooledconnection);
        if (this.cacheSize > this.MAX_LIMIT && this.cacheScheme == 1) {
            this.closeSingleConnection(pooledconnection);
        } else {
            this.cache.push(pooledconnection);
        }
    }

    public synchronized void setCacheScheme(int i) throws SQLException {
        if (i == 1 || i == 3 || i == 2) {
            this.cacheScheme = i;
        } else {
            DBError.throwSQLException(DmSvcConf.res.getString("error.pooled.inexistence"));
        }
    }

    public synchronized void setConnectionPoolDataSource(ConnectionPoolDataSource connectionpooldatasource) throws SQLException {
        if (this.cacheSize > 0) {
            DBError.throwSQLException(DmSvcConf.res.getString("error.cachesize.overload"));
        }
        this.connectionPoolDataSource = connectionpooldatasource;
    }

    public synchronized void setMaxLimit(int i) throws SQLException {
        if (i < 0 || i < this.MIN_LIMIT) {
            DBError.throwSQLException(DmSvcConf.res.getString("error.pooled.limit"));
        }
        this.MAX_LIMIT = i;
        if (this.cacheSize > this.MAX_LIMIT && this.cacheScheme != 1) {
            int j = this.MAX_LIMIT;
            while (j < this.cacheSize) {
                if (this.cache.empty()) {
                    DBError.throwSQLException(DmSvcConf.res.getString("error.pooled.overflow"));
                } else {
                    ((DmdbPooledConnection_bs)this.cache.pop()).close();
                }
                ++j;
            }
            this.cacheSize = this.MAX_LIMIT;
        }
    }

    public synchronized void setMinLimit(int i) throws SQLException {
        if (i < 0 || i > this.MAX_LIMIT) {
            DBError.throwSQLException(DmSvcConf.res.getString("error.pooled.minOverflow"));
        }
        this.MIN_LIMIT = i;
        if (this.cacheSize < this.MIN_LIMIT) {
            int j = this.cacheSize;
            while (j < this.MIN_LIMIT) {
                DmdbPooledConnection_bs dmpooledconnection = this.getNewPoolConnection();
                this.cache.push(dmpooledconnection);
                ++j;
            }
            this.cacheSize = this.MIN_LIMIT;
        }
    }
}

