/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.DmdbConnGroup;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbConnection_bs;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class DmdbDelayConnection
extends DmdbConnection {
    private DmdbConnGroup connGroup;
    private boolean closed = false;
    private boolean autoCommit;
    private boolean readOnly;
    private int transIsolLevel;
    private Map<String, Class<?>> typeMap;
    private int holdability;

    public DmdbDelayConnection(DmdbConnGroup connGroup) {
        super(null);
        this.connGroup = connGroup;
    }

    @Override
    public DmdbConnection_bs getBaseObject() {
        return this.getRealConn();
    }

    @Override
    public DmdbConnection_bs getRealConn() {
        if (this.rConn == null) {
            this.rConn = this.connGroup.getConnection();
            this.resetProperties();
        }
        return this.rConn;
    }

    private void resetProperties() {
        try {
            if (this.autoCommit != this.rConn.getAutoCommit()) {
                this.rConn.setAutoCommit(this.autoCommit);
            }
            if (this.readOnly != this.rConn.isReadOnly()) {
                this.rConn.setReadOnly(this.readOnly);
            }
            if (this.transIsolLevel != this.rConn.getTransactionIsolation()) {
                this.rConn.setTransactionIsolation(this.transIsolLevel);
            }
            if (this.holdability != this.rConn.getHoldability()) {
                this.rConn.setHoldability(this.holdability);
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void do_close() throws SQLException {
        this.closed = true;
        this.connGroup.close(this.rConn);
        this.rConn = null;
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            DBError.throwSQLException(6060);
        }
    }

    @Override
    public Statement do_createStatement() throws SQLException {
        this.checkClosed();
        return this.getRealConn().createStatement();
    }

    @Override
    public PreparedStatement do_prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        return this.getRealConn().prepareStatement(sql);
    }

    @Override
    public CallableStatement do_prepareCall(String sql) throws SQLException {
        this.checkClosed();
        return this.getRealConn().prepareCall(sql);
    }

    @Override
    public String do_nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return this.connGroup.nativeSQL(sql);
    }

    @Override
    public void do_setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean do_getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    @Override
    public void do_commit() throws SQLException {
        this.checkClosed();
        this.getRealConn().commit();
    }

    @Override
    public void do_rollback() throws SQLException {
        this.checkClosed();
        this.getRealConn().rollback();
    }

    @Override
    public boolean do_isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData do_getMetaData() throws SQLException {
        this.checkClosed();
        return this.getRealConn().getMetaData();
    }

    @Override
    public void do_setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.readOnly = readOnly;
    }

    @Override
    public boolean do_isReadOnly() throws SQLException {
        this.checkClosed();
        return this.readOnly;
    }

    @Override
    public void do_setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        this.connGroup.setCatalog(catalog);
    }

    @Override
    public String do_getCatalog() throws SQLException {
        this.checkClosed();
        return this.connGroup.getCatalog();
    }

    @Override
    public void do_setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 8: {
                this.transIsolLevel = level;
                break;
            }
            default: {
                DBError.throwSQLException(6038);
            }
        }
    }

    @Override
    public int do_getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return this.transIsolLevel;
    }

    @Override
    public SQLWarning do_getWarnings() throws SQLException {
        this.checkClosed();
        return this.getRealConn().getWarnings();
    }

    @Override
    public void do_clearWarnings() throws SQLException {
        this.checkClosed();
        this.getRealConn().clearWarnings();
    }

    @Override
    public Statement do_createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.getRealConn().createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement do_prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.getRealConn().prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement do_prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.getRealConn().prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> do_getTypeMap() throws SQLException {
        this.checkClosed();
        return this.typeMap;
    }

    @Override
    public void do_setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        this.typeMap = map;
    }

    @Override
    public void do_setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        if (holdability == 1 || holdability == 2) {
            this.holdability = holdability;
        } else {
            DBError.throwSQLException(6055);
        }
    }

    @Override
    public int do_getHoldability() throws SQLException {
        this.checkClosed();
        return this.holdability;
    }

    @Override
    public Savepoint do_setSavepoint() throws SQLException {
        this.checkClosed();
        return this.getRealConn().setSavepoint();
    }

    @Override
    public Savepoint do_setSavepoint(String name) throws SQLException {
        this.checkClosed();
        return this.getRealConn().setSavepoint(name);
    }

    @Override
    public void do_rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        this.getRealConn().rollback(savepoint);
    }

    @Override
    public void do_releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        this.getRealConn().releaseSavepoint(savepoint);
    }

    @Override
    public Statement do_createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return this.getRealConn().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement do_prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return this.getRealConn().prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement do_prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return this.getRealConn().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement do_prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        return this.getRealConn().prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement do_prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        return this.getRealConn().prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement do_prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        return this.getRealConn().prepareStatement(sql, columnNames);
    }
}

