/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.desc.DmdbConnGroup;
import dm.jdbc.driver.DmDriver_bs;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDelayConnection;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.filter.FilterChain;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class DmDriver
extends DmDriver_bs
implements Driver {
    private final ResourceBundle res = DmSvcConf.res;
    private FilterChain chain;

    static {
        try {
            DmdbType.JDBC_VERSION = 4;
            DriverManager.registerDriver(new DmDriver());
        }
        catch (Exception exception) {
            throw new RuntimeException("Can not load Driver class dm.jdbc.driver.DmDriver");
        }
    }

    public FilterChain createChain() {
        if (this.chain == null) {
            this.chain = new FilterChain();
        }
        return this.chain.reset();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Properties props = this.parseUrlBeforeConnect(url, info);
        if (props != null) {
            return this.createChain().Connection_connect(this, url, props);
        }
        return null;
    }

    public Connection do_connect(String url, Properties props) throws SQLException {
        int connGroupSize = DmSvcConf.parseInt(props.getProperty("connCompressRatio"), 0, 0, null);
        if (connGroupSize > 1) {
            return new DmdbDelayConnection(DmdbConnGroup.getInstance(url, props, connGroupSize));
        }
        return new DmdbConnection(DmDriver.createConnection(url, props));
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return DmDriver_bs.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return super.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return super.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return super.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public static void main(String[] args) {
        System.out.println("V7.6.0.165-Build(2019.06.04-44632)");
    }
}

