/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.dbaccess.DmdbSwitch;
import dm.jdbc.desc.DmServerInfo;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerGroup {
    private String name;
    private List<DmServerInfo> svrList = null;
    private DmSvcConf dmSvcConf;
    private long connSuccRefreshTs = 0L;
    private String userName;
    private String password;
    private ReentrantLock lock = new ReentrantLock(true);
    public static final int SC_OFFLINE = Integer.MAX_VALUE;
    private int[] sessCounts;
    private long plbTs = 0L;

    public ServerGroup(String name, List<DmServerInfo> svrList) {
        this.name = name;
        this.svrList = svrList;
        this.sessCounts = new int[svrList.size()];
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<DmServerInfo> getSvrList() {
        return this.svrList;
    }

    public void setConnSuccRefreshTs(long time) {
        this.connSuccRefreshTs = time;
    }

    public long getConnSuccRefreshTs() {
        return this.connSuccRefreshTs;
    }

    public void setDmSvcConf(DmSvcConf dmSvcConf) {
        this.dmSvcConf = dmSvcConf;
    }

    public DmSvcConf getDmSvcConf() {
        return this.dmSvcConf;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LBResult checkLoadBalance(DmdbConnection_bs conn, boolean connExist) {
        LBResult result = new LBResult();
        try {
            this.lock();
            result.setBalance(true);
            result.setPlbTs(this.plbTs);
            if (connExist) {
                int totalSessCount = 0;
                int aliveSvrCount = 0;
                int i = 0;
                while (i < this.sessCounts.length) {
                    if (this.sessCounts[i] != Integer.MAX_VALUE) {
                        totalSessCount += this.sessCounts[i];
                        ++aliveSvrCount;
                    }
                    ++i;
                }
                result.setScInfo(Arrays.toString(this.sessCounts));
                boolean balance = true;
                int i2 = 0;
                while (i2 < this.sessCounts.length) {
                    if (this.sessCounts[i2] != Integer.MAX_VALUE && Math.abs(this.sessCounts[i2] - totalSessCount / aliveSvrCount) > Math.round((float)(totalSessCount / aliveSvrCount) * ((float)conn.getLoadBalancePercent() / 100.0f))) {
                        balance = false;
                        break;
                    }
                    ++i2;
                }
                if (balance && this.sessCounts[conn.getServPos()] != Integer.MAX_VALUE) {
                    LBResult lBResult = result;
                    return lBResult;
                }
                for (Statement obj : conn.getStmtsVec()) {
                    DmdbStatement_bs stmt = (DmdbStatement_bs)obj;
                    if (stmt.isClosed()) continue;
                    if (stmt.getCurrentRs() != null && !stmt.getCurrentRs().isClosed()) {
                        LBResult lBResult = result;
                        return lBResult;
                    }
                    if (stmt.getResultsList() == null) continue;
                    for (DmdbResultSet_bs rs : stmt.getResultsList()) {
                        if (rs.isClosed()) continue;
                        LBResult lBResult = result;
                        return lBResult;
                    }
                }
                List<Integer> svrArr = DmdbSwitch.serverOrderBySessCount(conn.getHosts(), this.sessCounts, conn.getLoginMode());
                int lastIndex = svrArr.indexOf(conn.getServPos());
                if (lastIndex != -1) {
                    svrArr = svrArr.subList(0, lastIndex);
                }
                if (svrArr != null && svrArr.size() > 0) {
                    int n = svrArr.get(0);
                    this.sessCounts[n] = this.sessCounts[n] + 1;
                }
                result.setSvrArr(svrArr);
                result.setBalance(false);
                LBResult lBResult = result;
                return lBResult;
            }
            List<Integer> svrArr = DmdbSwitch.serverOrderBySessCount(conn.getHosts(), this.sessCounts, conn.getLoginMode());
            if (svrArr != null && svrArr.size() > 0) {
                int n = svrArr.get(0);
                this.sessCounts[n] = this.sessCounts[n] + 1;
            }
            result.setSvrArr(svrArr);
            result.setBalance(false);
            LBResult lBResult = result;
            return lBResult;
        }
        finally {
            this.unLock();
        }
    }

    public void addSession(int index, long ts) {
        try {
            this.lock();
            if (ts == this.plbTs) {
                int n = index;
                this.sessCounts[n] = this.sessCounts[n] + 1;
            }
        }
        finally {
            this.unLock();
        }
    }

    public void removeSession(int index) {
        try {
            this.lock();
            if (this.sessCounts[index] != Integer.MAX_VALUE && this.sessCounts[index] > 0) {
                int n = index;
                this.sessCounts[n] = this.sessCounts[n] - 1;
            }
        }
        finally {
            this.unLock();
        }
    }

    public void removeSession(int index, long ts) {
        try {
            this.lock();
            if (ts == this.plbTs && this.sessCounts[index] != Integer.MAX_VALUE && this.sessCounts[index] > 0) {
                int n = index;
                this.sessCounts[n] = this.sessCounts[n] - 1;
            }
        }
        finally {
            this.unLock();
        }
    }

    public void switchSession(int fromIndex, int toIndex, long ts) {
        try {
            this.lock();
            if (ts == this.plbTs) {
                int n = fromIndex;
                this.sessCounts[n] = this.sessCounts[n] - 1;
                int n2 = toIndex;
                this.sessCounts[n2] = this.sessCounts[n2] + 1;
            }
        }
        finally {
            this.unLock();
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unLock() {
        this.lock.unlock();
    }

    public void setSessCounts(int[] sessCounts) {
        this.sessCounts = sessCounts;
    }

    public int[] getSessCounts() {
        return this.sessCounts;
    }

    public long getPlbTs() {
        return this.plbTs;
    }

    public void setPlbTs(long plbTs) {
        this.plbTs = plbTs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LBResult {
        private long plbTs = 0L;
        private List<Integer> svrArr;
        private boolean balance = true;
        private String scInfo;

        public long getPlbTs() {
            return this.plbTs;
        }

        public List<Integer> getSvrArr() {
            return this.svrArr;
        }

        public void setPlbTs(long plbTs) {
            this.plbTs = plbTs;
        }

        public void setSvrArr(List<Integer> svrArr) {
            this.svrArr = svrArr;
        }

        public boolean isBalance() {
            return this.balance;
        }

        public void setBalance(boolean balance) {
            this.balance = balance;
        }

        public String getScInfo() {
            return this.scInfo;
        }

        public void setScInfo(String scInfo) {
            this.scInfo = scInfo;
        }
    }
}

