/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.DmdbIntervalYM;
import dm.sql.TypeDescriptor;
import java.sql.SQLException;

public class DmIntvYMBinder
extends DmBinder {
    private boolean exactType;

    public DmIntvYMBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 20;
        this.recPrec = 0;
        this.recScale = 0;
    }

    void checkType(int irow, int icol, boolean forBatch) throws SQLException {
        if (this.m_checkType) {
            return;
        }
        this.m_checkType = true;
        if (this.paramsDesc == null) {
            this.paramsDesc = this.pstmt.getParamsDesc();
        }
        byte typeFlag = this.paramsDesc[icol].getTypeFlag();
        int dType = this.paramsDesc[icol].getDType();
        int prec = this.paramsDesc[icol].getPrec();
        int scale = this.paramsDesc[icol].getScale();
        byte ioType = this.paramsDesc[icol].getIOType();
        if (ioType != 1 && typeFlag != 1) {
            this.destDType = this.recDType;
            this.destPrec = this.recPrec;
            this.destScale = scale;
            this.exactType = false;
        } else {
            this.destDType = dType;
            this.destPrec = prec;
            this.destScale = scale;
            this.exactType = true;
        }
        this.destIoType = ioType;
        this.srcScale = scale;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Object obj = this.pstmt.getParamObject(irow, icol);
        String serverEncoding = this.pstmt.getConnection_bs().getServerEncoding();
        short dbTz = this.pstmt.getConnection_bs().getDbTz();
        short ltz = this.pstmt.getConnection_bs().getClientTz();
        TypeDescriptor typeDesc = this.paramsDesc[icol].getTypeDescriptor();
        byte[] ret = null;
        if (this.isDiffParamObjectType() && !(obj instanceof DmdbIntervalYM)) {
            ret = this.castToDestType(obj, this.destDType, this.destPrec, this.destScale, serverEncoding, ltz, dbTz, typeDesc);
        } else {
            DmdbIntervalYM ym = (DmdbIntervalYM)obj;
            int scale = this.destScale;
            if (!this.exactType) {
                scale = ym.getPrecForSvr();
            }
            ret = DmIntvYMBinder.toDbBytes(ym, this.destDType, this.destPrec, scale, serverEncoding);
        }
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(DmdbIntervalYM ym, int destDType, int destPrec, int scale, String serverEncoding) throws SQLException {
        byte[] ret = null;
        if (DmdbType.isBFileType(destDType, destPrec, scale)) {
            DBError.throwSQLException(6007);
        } else {
            switch (destDType) {
                case 20: {
                    ret = Convertion.IntvYMToByteArray(ym, scale);
                    break;
                }
                case 0: 
                case 1: {
                    ret = Convertion.String_char_2CType(String.valueOf(ym), destPrec, destDType, serverEncoding);
                    break;
                }
                case 2: 
                case 19: {
                    ret = Convertion.String_varchar_2CType(String.valueOf(ym), destPrec, destDType, serverEncoding);
                    break;
                }
                default: {
                    DBError.throwSQLException(6007);
                }
            }
        }
        return DmIntvYMBinder.checkParamData(ret, destDType, destPrec, serverEncoding);
    }
}

