/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.DmdbTimestamp;
import java.sql.SQLException;
import java.util.Calendar;

public class DmIntBinder
extends DmBinder {
    public DmIntBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 7;
        this.recPrec = 4;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Object obj = this.pstmt.getParamObject(irow, icol);
        byte[] ret = null;
        ret = this.diffParamObjectType && !(obj instanceof Integer) ? this.castToDestType(obj, this.destDType, this.destPrec, this.destScale, this.serverEncoding, this.ltz, this.dbTz, this.paramsDesc[icol].getTypeDescriptor()) : DmIntBinder.toDbBytes((Integer)obj, this.destDType, this.destPrec, this.destScale, this.serverEncoding, this.ltz, this.dbTz, this.defaultCalendar);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(int x, int destDType, int destPrec, int destScale, String serverEncoding, short ltz, short dbTz, Calendar defaultCalendar) throws SQLException {
        byte[] ret = null;
        switch (destDType) {
            case 7: {
                ret = Convertion.intToByteArray(x);
                break;
            }
            case 3: 
            case 13: {
                ret = Convertion.booleanToByteArray(x != 0);
                break;
            }
            case 5: {
                if (x > 127 || x < -128) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.byteToByteArray((byte)x);
                break;
            }
            case 6: {
                if (x > Short.MAX_VALUE || x < Short.MIN_VALUE) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.shortToByteArray(x);
                break;
            }
            case 8: {
                ret = Convertion.longToByteArray(x);
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray(x);
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(x);
                break;
            }
            case 9: {
                ret = Convertion.BigDecimalToByteArray(String.valueOf(x), destPrec, destScale);
                break;
            }
            case 0: 
            case 1: {
                ret = Convertion.String_char_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            case 2: 
            case 19: {
                if (DmdbType.isBFileType(destDType, destPrec, destScale)) {
                    DBError.throwSQLException(6007);
                }
                ret = Convertion.String_varchar_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            case 17: {
                ret = Convertion.intToBinary(x, destPrec);
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                ret = DmdbTimestamp.encodeByDateNumber(x, destDType, destScale, defaultCalendar, ltz, dbTz);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return DmIntBinder.checkParamData(ret, destDType, destPrec, serverEncoding);
    }
}

