/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.sql.TypeData;
import dm.sql.TypeDescriptor;
import java.sql.Blob;
import java.sql.SQLException;

public class DmBlobBinder
extends DmBinder {
    boolean new_lob_flag = false;

    public DmBlobBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
        this.new_lob_flag = pstmt.getConnection_bs().getNewLobFlag();
    }

    void init() {
        this.recDType = 12;
        this.recPrec = Integer.MAX_VALUE;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Object obj = this.pstmt.getParamObject(irow, icol);
        String serverEncoding = this.pstmt.getConnection_bs().getServerEncoding();
        short dbTz = this.pstmt.getConnection_bs().getDbTz();
        short ltz = this.pstmt.getConnection_bs().getClientTz();
        TypeDescriptor typeDesc = this.paramsDesc[icol].getTypeDescriptor();
        byte[] ret = null;
        if (this.isDiffParamObjectType() && !(obj instanceof Blob)) {
            ret = this.castToDestType(obj, this.destDType, this.destPrec, this.destScale, serverEncoding, ltz, dbTz, typeDesc);
        } else {
            Blob blob = (Blob)obj;
            if (this.destDType == 12 && blob.length() > 2048L) {
                return -1;
            }
            ret = DmBlobBinder.toDbBytes(blob, this.destDType, this.destPrec, this.destScale, typeDesc, serverEncoding);
        }
        if (ret.length == 0 && this.pstmt.getConnection_bs().isLobEmptyCompOrcl()) {
            return msg.appendLen2(-6);
        }
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(Blob blob, int destDType, int destPrec, int destScale, TypeDescriptor typeDesc, String serverEncoding) throws SQLException {
        byte[] ret = null;
        long length = blob.length();
        switch (destDType) {
            case 12: {
                ret = blob.getBytes(1L, (int)length);
                if (ret != null) break;
                ret = new byte[]{};
                break;
            }
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                if (typeDesc != null) {
                    byte[] lobBuf = blob.getBytes(1L, (int)length);
                    ret = TypeData.objBlobToBytes(lobBuf, typeDesc);
                    break;
                }
                DBError.throwSQLException(6007);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return DmBlobBinder.checkParamData(ret, destDType, destPrec, serverEncoding);
    }

    public int bindLobCyc(DmMsgSend lobMsg, int irow, int icol) throws SQLException {
        Blob lob = (Blob)this.pstmt.getParamObject(irow, icol);
        int maxLen = 16000;
        long lobLen = lob.length();
        if ((long)this.offset_var > lobLen) {
            this.clearVars();
            return 0;
        }
        if (this.offset_var == -1) {
            this.offset_var = 1;
        }
        int readLen = (int)(lobLen - (long)this.offset_var + 1L > (long)maxLen ? (long)maxLen : lobLen - (long)this.offset_var + 1L);
        byte[] ret = lob.getBytes(this.offset_var, readLen);
        this.offset_var += ret.length;
        return lobMsg.appendOffRowBytes(ret, 0, ret.length, this.new_lob_flag, -1);
    }
}

