/*
 * Decompiled with CFR 0.152.
 */
package com.daimajia.swipe.implments;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.BaseAdapter;
import com.daimajia.swipe.SimpleSwipeListener;
import com.daimajia.swipe.SwipeLayout;
import com.daimajia.swipe.interfaces.SwipeAdapterInterface;
import com.daimajia.swipe.interfaces.SwipeItemMangerInterface;
import com.daimajia.swipe.util.Attributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class SwipeItemMangerImpl
implements SwipeItemMangerInterface {
    private Attributes.Mode mode = Attributes.Mode.Single;
    public final int INVALID_POSITION = -1;
    protected int mOpenPosition = -1;
    protected Set<Integer> mOpenPositions = new HashSet<Integer>();
    protected Set<SwipeLayout> mShownLayouts = new HashSet<SwipeLayout>();
    protected BaseAdapter mBaseAdapter;
    protected RecyclerView.Adapter mRecyclerAdapter;

    public SwipeItemMangerImpl(BaseAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Adapter can not be null");
        }
        if (!(adapter instanceof SwipeItemMangerInterface)) {
            throw new IllegalArgumentException("adapter should implement the SwipeAdapterInterface");
        }
        this.mBaseAdapter = adapter;
    }

    public SwipeItemMangerImpl(RecyclerView.Adapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Adapter can not be null");
        }
        if (!(adapter instanceof SwipeItemMangerInterface)) {
            throw new IllegalArgumentException("adapter should implement the SwipeAdapterInterface");
        }
        this.mRecyclerAdapter = adapter;
    }

    @Override
    public Attributes.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(Attributes.Mode mode) {
        this.mode = mode;
        this.mOpenPositions.clear();
        this.mShownLayouts.clear();
        this.mOpenPosition = -1;
    }

    public abstract void initialize(View var1, int var2);

    public abstract void updateConvertView(View var1, int var2);

    public abstract void bindView(View var1, int var2);

    public int getSwipeLayoutId(int position) {
        if (this.mBaseAdapter != null) {
            return ((SwipeAdapterInterface)this.mBaseAdapter).getSwipeLayoutResourceId(position);
        }
        if (this.mRecyclerAdapter != null) {
            return ((SwipeAdapterInterface)this.mRecyclerAdapter).getSwipeLayoutResourceId(position);
        }
        return -1;
    }

    @Override
    public void openItem(int position) {
        if (this.mode == Attributes.Mode.Multiple) {
            if (!this.mOpenPositions.contains(position)) {
                this.mOpenPositions.add(position);
            }
        } else {
            this.mOpenPosition = position;
        }
        if (this.mBaseAdapter != null) {
            this.mBaseAdapter.notifyDataSetChanged();
        } else if (this.mRecyclerAdapter != null) {
            this.mRecyclerAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public void closeItem(int position) {
        if (this.mode == Attributes.Mode.Multiple) {
            this.mOpenPositions.remove(position);
        } else if (this.mOpenPosition == position) {
            this.mOpenPosition = -1;
        }
        if (this.mBaseAdapter != null) {
            this.mBaseAdapter.notifyDataSetChanged();
        } else if (this.mRecyclerAdapter != null) {
            this.mRecyclerAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public void closeAllExcept(SwipeLayout layout) {
        for (SwipeLayout s : this.mShownLayouts) {
            if (s == layout) continue;
            s.close();
        }
    }

    @Override
    public void closeAllItems() {
        if (this.mode == Attributes.Mode.Multiple) {
            this.mOpenPositions.clear();
        } else {
            this.mOpenPosition = -1;
        }
        for (SwipeLayout s : this.mShownLayouts) {
            s.close();
        }
    }

    @Override
    public void removeShownLayouts(SwipeLayout layout) {
        this.mShownLayouts.remove((Object)layout);
    }

    @Override
    public List<Integer> getOpenItems() {
        if (this.mode == Attributes.Mode.Multiple) {
            return new ArrayList<Integer>(this.mOpenPositions);
        }
        return Arrays.asList(this.mOpenPosition);
    }

    @Override
    public List<SwipeLayout> getOpenLayouts() {
        return new ArrayList<SwipeLayout>(this.mShownLayouts);
    }

    @Override
    public boolean isOpen(int position) {
        if (this.mode == Attributes.Mode.Multiple) {
            return this.mOpenPositions.contains(position);
        }
        return this.mOpenPosition == position;
    }

    class SwipeMemory
    extends SimpleSwipeListener {
        private int position;

        SwipeMemory(int position) {
            this.position = position;
        }

        @Override
        public void onClose(SwipeLayout layout) {
            if (SwipeItemMangerImpl.this.mode == Attributes.Mode.Multiple) {
                SwipeItemMangerImpl.this.mOpenPositions.remove(this.position);
            } else {
                SwipeItemMangerImpl.this.mOpenPosition = -1;
            }
        }

        @Override
        public void onStartOpen(SwipeLayout layout) {
            if (SwipeItemMangerImpl.this.mode == Attributes.Mode.Single) {
                SwipeItemMangerImpl.this.closeAllExcept(layout);
            }
        }

        @Override
        public void onOpen(SwipeLayout layout) {
            if (SwipeItemMangerImpl.this.mode == Attributes.Mode.Multiple) {
                SwipeItemMangerImpl.this.mOpenPositions.add(this.position);
            } else {
                SwipeItemMangerImpl.this.closeAllExcept(layout);
                SwipeItemMangerImpl.this.mOpenPosition = this.position;
            }
        }

        public void setPosition(int position) {
            this.position = position;
        }
    }

    class OnLayoutListener
    implements SwipeLayout.OnLayout {
        private int position;

        OnLayoutListener(int position) {
            this.position = position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        @Override
        public void onLayout(SwipeLayout v) {
            if (SwipeItemMangerImpl.this.isOpen(this.position)) {
                v.open(false, false);
            } else {
                v.close(false, false);
            }
        }
    }

    class ValueBox {
        OnLayoutListener onLayoutListener;
        SwipeMemory swipeMemory;
        int position;

        ValueBox(int position, SwipeMemory swipeMemory, OnLayoutListener onLayoutListener) {
            this.swipeMemory = swipeMemory;
            this.onLayoutListener = onLayoutListener;
            this.position = position;
        }
    }
}

