/*
 * Decompiled with CFR 0.152.
 */
package com.daimajia.swipe;

import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.daimajia.swipe.SwipeLayout;
import java.util.HashSet;
import java.util.Set;

public abstract class SwipeAdapter
extends BaseAdapter {
    private Mode mode = Mode.Single;
    public final int INVALID_POSITION = -1;
    private Set<Integer> mOpenPositions = new HashSet<Integer>();
    private int mOpenPosition = -1;
    private SwipeLayout mPrevious;

    public abstract int getSwipeLayoutResourceId(int var1);

    public abstract View generateView(int var1, ViewGroup var2);

    public abstract void fillValues(int var1, View var2);

    public final View getView(int position, View convertView, ViewGroup parent) {
        View v = convertView;
        int swipeResourceId = this.getSwipeLayoutResourceId(position);
        if (v == null) {
            v = this.generateView(position, parent);
            SwipeLayout swipeLayout = (SwipeLayout)v.findViewById(swipeResourceId);
            if (swipeLayout != null) {
                OnLayoutListener onLayoutListener = new OnLayoutListener(position);
                SwipeMemory swipeMemory = new SwipeMemory(position);
                swipeLayout.addSwipeListener(swipeMemory);
                swipeLayout.addOnLayoutListener(onLayoutListener);
                swipeLayout.setTag(swipeResourceId, new ValueBox(position, swipeMemory, onLayoutListener));
            }
        } else {
            SwipeLayout swipeLayout = (SwipeLayout)v.findViewById(swipeResourceId);
            if (swipeLayout != null) {
                ValueBox valueBox = (ValueBox)swipeLayout.getTag(swipeResourceId);
                valueBox.swipeMemory.setPosition(position);
                valueBox.onLayoutListener.setPosition(position);
                valueBox.position = position;
            }
        }
        this.fillValues(position, v);
        return v;
    }

    public void setMode(Mode mode) {
        this.mOpenPositions.clear();
        this.mOpenPosition = -1;
        this.mode = mode;
        this.notifyDataSetChanged();
    }

    public Mode getMode() {
        return this.mode;
    }

    public void openItem(int position) {
        if (this.mode == Mode.Multiple) {
            if (!this.mOpenPositions.contains(position)) {
                this.mOpenPositions.add(position);
            }
        } else {
            this.mOpenPosition = position;
        }
        this.notifyDataSetChanged();
    }

    public void closeItem(int position) {
        if (this.mode == Mode.Multiple) {
            this.mOpenPositions.remove(position);
        } else if (this.mOpenPosition == position) {
            this.mOpenPosition = -1;
        }
        this.notifyDataSetChanged();
    }

    class SwipeMemory
    implements SwipeLayout.SwipeListener {
        private int position;

        SwipeMemory(int position) {
            this.position = position;
        }

        @Override
        public void onClose(SwipeLayout layout) {
            if (SwipeAdapter.this.mode == Mode.Multiple) {
                SwipeAdapter.this.mOpenPositions.remove(this.position);
            } else if (this.position == SwipeAdapter.this.mOpenPosition) {
                SwipeAdapter.this.mOpenPosition = -1;
                SwipeAdapter.this.mPrevious = null;
            }
        }

        @Override
        public void onUpdate(SwipeLayout layout, int leftOffset, int topOffset) {
        }

        @Override
        public void onOpen(SwipeLayout layout) {
            if (SwipeAdapter.this.mode == Mode.Multiple) {
                SwipeAdapter.this.mOpenPositions.add(this.position);
            } else {
                if (SwipeAdapter.this.mOpenPosition != this.position && SwipeAdapter.this.mPrevious != null) {
                    SwipeAdapter.this.mPrevious.close();
                }
                SwipeAdapter.this.mOpenPosition = this.position;
                SwipeAdapter.this.mPrevious = layout;
            }
        }

        @Override
        public void onHandRelease(SwipeLayout layout, float xvel, float yvel) {
        }

        public void setPosition(int position) {
            this.position = position;
        }
    }

    class OnLayoutListener
    implements SwipeLayout.OnLayout {
        private int position;

        OnLayoutListener(int position) {
            this.position = position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        @Override
        public void onLayout(SwipeLayout v) {
            if (SwipeAdapter.this.mode == Mode.Multiple) {
                if (SwipeAdapter.this.mOpenPositions.contains(this.position)) {
                    v.open(false);
                } else {
                    v.close(false);
                }
            } else if (SwipeAdapter.this.mOpenPosition == this.position) {
                v.open(false);
            } else {
                v.close(false);
            }
        }
    }

    class ValueBox {
        OnLayoutListener onLayoutListener;
        SwipeMemory swipeMemory;
        int position;

        ValueBox(int position, SwipeMemory swipeMemory, OnLayoutListener onLayoutListener) {
            this.swipeMemory = swipeMemory;
            this.onLayoutListener = onLayoutListener;
            this.position = position;
        }
    }

    public static enum Mode {
        Single,
        Multiple;

    }
}

