/*
 * Decompiled with CFR 0.152.
 */
package com.daimajia.swipe;

import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.daimajia.swipe.SwipeLayout;
import java.util.HashSet;
import java.util.Set;

public abstract class SwipeAdapter
extends BaseAdapter {
    private Set<Integer> mOpenPositions = new HashSet<Integer>();

    public abstract int getSwipeLayoutResourceId(int var1);

    public abstract View generateView(int var1, ViewGroup var2);

    public abstract void fillValues(int var1, View var2);

    public final View getView(int position, View convertView, ViewGroup parent) {
        View v = convertView;
        int swipeResourceId = this.getSwipeLayoutResourceId(position);
        if (v == null) {
            v = this.generateView(position, parent);
            SwipeLayout swipeLayout = (SwipeLayout)v.findViewById(swipeResourceId);
            if (swipeLayout != null) {
                OnLayoutListener onLayoutListener = new OnLayoutListener(position);
                SwipeMemory swipeMemory = new SwipeMemory(position);
                swipeLayout.addSwipeListener(swipeMemory);
                swipeLayout.addOnLayoutListener(onLayoutListener);
                swipeLayout.setTag(swipeResourceId, new ValueBox(position, swipeMemory, onLayoutListener));
            }
        } else {
            SwipeLayout swipeLayout = (SwipeLayout)v.findViewById(swipeResourceId);
            if (swipeLayout != null) {
                ValueBox valueBox = (ValueBox)swipeLayout.getTag(swipeResourceId);
                valueBox.swipeMemory.setPosition(position);
                valueBox.onLayoutListener.setPosition(position);
                valueBox.position = position;
            }
        }
        this.fillValues(position, v);
        return v;
    }

    class SwipeMemory
    implements SwipeLayout.SwipeListener {
        private int position;

        SwipeMemory(int position) {
            this.position = position;
        }

        @Override
        public void onClose(SwipeLayout layout) {
            SwipeAdapter.this.mOpenPositions.remove(this.position);
        }

        @Override
        public void onUpdate(SwipeLayout layout, int leftOffset, int topOffset) {
        }

        @Override
        public void onOpen(SwipeLayout layout) {
            SwipeAdapter.this.mOpenPositions.add(this.position);
        }

        @Override
        public void onHandRelease(SwipeLayout layout, float xvel, float yvel) {
        }

        public void setPosition(int position) {
            this.position = position;
        }
    }

    class OnLayoutListener
    implements SwipeLayout.OnLayout {
        private int position;

        OnLayoutListener(int position) {
            this.position = position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        @Override
        public void onLayout(SwipeLayout v) {
            if (SwipeAdapter.this.mOpenPositions.contains(this.position)) {
                v.open(false);
            } else {
                v.close(false);
            }
        }
    }

    class ValueBox {
        OnLayoutListener onLayoutListener;
        SwipeMemory swipeMemory;
        int position;

        ValueBox(int position, SwipeMemory swipeMemory, OnLayoutListener onLayoutListener) {
            this.swipeMemory = swipeMemory;
            this.onLayoutListener = onLayoutListener;
            this.position = position;
        }
    }
}

