/*
 * Decompiled with CFR 0.152.
 */
package com.daimajia.slider.library.Transformers;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.view.View;
import com.daimajia.slider.library.Transformers.BaseTransformer;
import com.nineoldandroids.view.ViewHelper;

public class TabletTransformer
extends BaseTransformer {
    private static final Matrix OFFSET_MATRIX = new Matrix();
    private static final Camera OFFSET_CAMERA = new Camera();
    private static final float[] OFFSET_TEMP_FLOAT = new float[2];

    @Override
    protected void onTransform(View view, float position) {
        float rotation = (position < 0.0f ? 30.0f : -30.0f) * Math.abs(position);
        ViewHelper.setTranslationX((View)view, (float)TabletTransformer.getOffsetXForRotation(rotation, view.getWidth(), view.getHeight()));
        ViewHelper.setPivotX((View)view, (float)((float)view.getWidth() * 0.5f));
        ViewHelper.setPivotY((View)view, (float)0.0f);
        ViewHelper.setRotationY((View)view, (float)rotation);
    }

    protected static final float getOffsetXForRotation(float degrees, int width, int height) {
        OFFSET_MATRIX.reset();
        OFFSET_CAMERA.save();
        OFFSET_CAMERA.rotateY(Math.abs(degrees));
        OFFSET_CAMERA.getMatrix(OFFSET_MATRIX);
        OFFSET_CAMERA.restore();
        OFFSET_MATRIX.preTranslate((float)(-width) * 0.5f, (float)(-height) * 0.5f);
        OFFSET_MATRIX.postTranslate((float)width * 0.5f, (float)height * 0.5f);
        TabletTransformer.OFFSET_TEMP_FLOAT[0] = width;
        TabletTransformer.OFFSET_TEMP_FLOAT[1] = height;
        OFFSET_MATRIX.mapPoints(OFFSET_TEMP_FLOAT);
        return ((float)width - OFFSET_TEMP_FLOAT[0]) * (degrees > 0.0f ? 1.0f : -1.0f);
    }
}

