/*
 * Decompiled with CFR 0.152.
 */
package com.daimajia.slider.library.Transformers;

import android.os.Build;
import android.view.View;
import com.daimajia.slider.library.Transformers.BaseTransformer;
import com.daimajia.slider.library.Tricks.ViewPagerEx;
import com.nineoldandroids.view.ViewHelper;

public class FlipPageViewTransformer
extends BaseTransformer {
    @Override
    protected void onTransform(View view, float position) {
        float percentage = 1.0f - Math.abs(position);
        if (Build.VERSION.SDK_INT >= 13) {
            view.setCameraDistance(12000.0f);
        }
        this.setVisibility(view, position);
        this.setTranslation(view);
        this.setSize(view, position, percentage);
        this.setRotation(view, position, percentage);
    }

    private void setVisibility(View page, float position) {
        if ((double)position < 0.5 && (double)position > -0.5) {
            page.setVisibility(0);
        } else {
            page.setVisibility(4);
        }
    }

    private void setTranslation(View view) {
        ViewPagerEx viewPager = (ViewPagerEx)view.getParent();
        int scroll = viewPager.getScrollX() - view.getLeft();
        ViewHelper.setTranslationX((View)view, (float)scroll);
    }

    private void setSize(View view, float position, float percentage) {
        ViewHelper.setScaleX((View)view, (float)(position != 0.0f && position != 1.0f ? percentage : 1.0f));
        ViewHelper.setScaleY((View)view, (float)(position != 0.0f && position != 1.0f ? percentage : 1.0f));
    }

    private void setRotation(View view, float position, float percentage) {
        if (position > 0.0f) {
            ViewHelper.setRotationY((View)view, (float)(-180.0f * (percentage + 1.0f)));
        } else {
            ViewHelper.setRotationY((View)view, (float)(180.0f * (percentage + 1.0f)));
        }
    }
}

