/*
 * Decompiled with CFR 0.152.
 */
package com.daimajia.slider.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.PagerAdapter;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import com.daimajia.slider.library.Animations.BaseAnimationInterface;
import com.daimajia.slider.library.Indicators.PagerIndicator;
import com.daimajia.slider.library.R;
import com.daimajia.slider.library.SliderAdapter;
import com.daimajia.slider.library.SliderTypes.BaseSliderView;
import com.daimajia.slider.library.Transformers.AccordionTransformer;
import com.daimajia.slider.library.Transformers.BackgroundToForegroundTransformer;
import com.daimajia.slider.library.Transformers.BaseTransformer;
import com.daimajia.slider.library.Transformers.CubeInTransformer;
import com.daimajia.slider.library.Transformers.DefaultTransformer;
import com.daimajia.slider.library.Transformers.DepthPageTransformer;
import com.daimajia.slider.library.Transformers.FadeTransformer;
import com.daimajia.slider.library.Transformers.FlipHorizontalTransformer;
import com.daimajia.slider.library.Transformers.FlipPageViewTransformer;
import com.daimajia.slider.library.Transformers.ForegroundToBackgroundTransformer;
import com.daimajia.slider.library.Transformers.RotateDownTransformer;
import com.daimajia.slider.library.Transformers.RotateUpTransformer;
import com.daimajia.slider.library.Transformers.StackTransformer;
import com.daimajia.slider.library.Transformers.TabletTransformer;
import com.daimajia.slider.library.Transformers.ZoomInTransformer;
import com.daimajia.slider.library.Transformers.ZoomOutSlideTransformer;
import com.daimajia.slider.library.Transformers.ZoomOutTransformer;
import com.daimajia.slider.library.Tricks.FixedSpeedScroller;
import com.daimajia.slider.library.Tricks.InfinitePagerAdapter;
import com.daimajia.slider.library.Tricks.InfiniteViewPager;
import com.daimajia.slider.library.Tricks.ViewPagerEx;
import java.lang.reflect.Field;
import java.util.Timer;
import java.util.TimerTask;

public class SliderLayout
extends RelativeLayout {
    private Context mContext;
    private InfiniteViewPager mViewPager;
    private SliderAdapter mSliderAdapter;
    private PagerIndicator mIndicator;
    private Timer mCycleTimer;
    private TimerTask mCycleTask;
    private Timer mResumingTimer;
    private TimerTask mResumingTask;
    private boolean mCycling;
    private boolean mAutoRecover = true;
    private int mTransformerId;
    private int mTransformerSpan = 1100;
    private boolean mAutoCycle;
    private long mSliderDuration = 4000L;
    private PagerIndicator.IndicatorVisibility mIndicatorVisibility = PagerIndicator.IndicatorVisibility.Visible;
    private BaseTransformer mViewPagerTransformer;
    private BaseAnimationInterface mCustomAnimation;
    private Handler mh = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            SliderLayout.this.moveNextPosition(true);
        }
    };

    public SliderLayout(Context context) {
        this(context, null);
    }

    public SliderLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.SliderStyle);
    }

    public SliderLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
        LayoutInflater.from((Context)context).inflate(R.layout.slider_layout, (ViewGroup)this, true);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SliderLayout, defStyle, 0);
        this.mTransformerSpan = attributes.getInteger(R.styleable.SliderLayout_pager_animation_span, 1100);
        this.mTransformerId = attributes.getInt(R.styleable.SliderLayout_pager_animation, Transformer.Default.ordinal());
        this.mAutoCycle = attributes.getBoolean(R.styleable.SliderLayout_auto_cycle, true);
        int visibility = attributes.getInt(R.styleable.SliderLayout_indicator_visibility, 0);
        for (PagerIndicator.IndicatorVisibility v : PagerIndicator.IndicatorVisibility.values()) {
            if (v.ordinal() != visibility) continue;
            this.mIndicatorVisibility = v;
            break;
        }
        this.mSliderAdapter = new SliderAdapter(this.mContext);
        InfinitePagerAdapter wrappedAdapter = new InfinitePagerAdapter(this.mSliderAdapter);
        this.mViewPager = (InfiniteViewPager)this.findViewById(R.id.daimajia_slider_viewpager);
        this.mViewPager.setAdapter(wrappedAdapter);
        this.mViewPager.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                int action = event.getAction();
                switch (action) {
                    case 1: {
                        SliderLayout.this.recoverCycle();
                    }
                }
                return false;
            }
        });
        attributes.recycle();
        this.setPresetIndicator(PresetIndicators.Center_Bottom);
        this.setPresetTransformer(this.mTransformerId);
        this.setSliderTransformDuration(this.mTransformerSpan, null);
        this.setIndicatorVisibility(this.mIndicatorVisibility);
        if (this.mAutoCycle) {
            this.startAutoCycle();
        }
    }

    public void addOnPageChangeListener(ViewPagerEx.OnPageChangeListener onPageChangeListener) {
        if (onPageChangeListener != null) {
            this.mViewPager.addOnPageChangeListener(onPageChangeListener);
        }
    }

    public void removeOnPageChangeListener(ViewPagerEx.OnPageChangeListener onPageChangeListener) {
        this.mViewPager.removeOnPageChangeListener(onPageChangeListener);
    }

    public void setCustomIndicator(PagerIndicator indicator) {
        if (this.mIndicator != null) {
            this.mIndicator.destroySelf();
        }
        this.mIndicator = indicator;
        this.mIndicator.setIndicatorVisibility(this.mIndicatorVisibility);
        this.mIndicator.setViewPager(this.mViewPager);
        this.mIndicator.redraw();
    }

    public <T extends BaseSliderView> void addSlider(T imageContent) {
        this.mSliderAdapter.addSlider(imageContent);
    }

    public void startAutoCycle() {
        this.startAutoCycle(1000L, this.mSliderDuration, this.mAutoRecover);
    }

    public void startAutoCycle(long delay, long duration, boolean autoRecover) {
        if (this.mCycleTimer != null) {
            this.mCycleTimer.cancel();
        }
        if (this.mCycleTask != null) {
            this.mCycleTask.cancel();
        }
        if (this.mResumingTask != null) {
            this.mResumingTask.cancel();
        }
        if (this.mResumingTimer != null) {
            this.mResumingTimer.cancel();
        }
        this.mSliderDuration = duration;
        this.mCycleTimer = new Timer();
        this.mAutoRecover = autoRecover;
        this.mCycleTask = new TimerTask(){

            @Override
            public void run() {
                SliderLayout.this.mh.sendEmptyMessage(0);
            }
        };
        this.mCycleTimer.schedule(this.mCycleTask, delay, this.mSliderDuration);
        this.mCycling = true;
        this.mAutoCycle = true;
    }

    private void pauseAutoCycle() {
        if (this.mCycling) {
            this.mCycleTimer.cancel();
            this.mCycleTask.cancel();
            this.mCycling = false;
        } else if (this.mResumingTimer != null && this.mResumingTask != null) {
            this.recoverCycle();
        }
    }

    public void setDuration(long duration) {
        if (duration >= 500L) {
            this.mSliderDuration = duration;
            if (this.mAutoCycle && this.mCycling) {
                this.startAutoCycle();
            }
        }
    }

    public void stopAutoCycle() {
        if (this.mCycleTask != null) {
            this.mCycleTask.cancel();
        }
        if (this.mCycleTimer != null) {
            this.mCycleTimer.cancel();
        }
        if (this.mResumingTimer != null) {
            this.mResumingTimer.cancel();
        }
        if (this.mResumingTask != null) {
            this.mResumingTask.cancel();
        }
        this.mAutoCycle = false;
        this.mCycling = false;
    }

    private void recoverCycle() {
        if (!this.mAutoRecover || !this.mAutoCycle) {
            return;
        }
        if (!this.mCycling) {
            if (this.mResumingTask != null && this.mResumingTimer != null) {
                this.mResumingTimer.cancel();
                this.mResumingTask.cancel();
            }
            this.mResumingTimer = new Timer();
            this.mResumingTask = new TimerTask(){

                @Override
                public void run() {
                    SliderLayout.this.startAutoCycle();
                }
            };
            this.mResumingTimer.schedule(this.mResumingTask, 6000L);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.pauseAutoCycle();
            }
        }
        return false;
    }

    public void setPagerTransformer(boolean reverseDrawingOrder, BaseTransformer transformer) {
        this.mViewPagerTransformer = transformer;
        this.mViewPagerTransformer.setCustomAnimationInterface(this.mCustomAnimation);
        this.mViewPager.setPageTransformer(reverseDrawingOrder, this.mViewPagerTransformer);
    }

    public void setSliderTransformDuration(int period, Interpolator interpolator) {
        try {
            Field mScroller = ViewPagerEx.class.getDeclaredField("mScroller");
            mScroller.setAccessible(true);
            FixedSpeedScroller scroller = new FixedSpeedScroller(this.mViewPager.getContext(), interpolator, period);
            mScroller.set((Object)this.mViewPager, (Object)scroller);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPresetTransformer(int transformerId) {
        for (Transformer t : Transformer.values()) {
            if (t.ordinal() != transformerId) continue;
            this.setPresetTransformer(t);
            break;
        }
    }

    public void setPresetTransformer(String transformerName) {
        for (Transformer t : Transformer.values()) {
            if (!t.equals(transformerName)) continue;
            this.setPresetTransformer(t);
            return;
        }
    }

    public void setCustomAnimation(BaseAnimationInterface animation) {
        this.mCustomAnimation = animation;
        if (this.mViewPagerTransformer != null) {
            this.mViewPagerTransformer.setCustomAnimationInterface(this.mCustomAnimation);
        }
    }

    public void setPresetTransformer(Transformer ts) {
        BaseTransformer t = null;
        switch (ts) {
            case Default: {
                t = new DefaultTransformer();
                break;
            }
            case Accordion: {
                t = new AccordionTransformer();
                break;
            }
            case Background2Foreground: {
                t = new BackgroundToForegroundTransformer();
                break;
            }
            case CubeIn: {
                t = new CubeInTransformer();
                break;
            }
            case DepthPage: {
                t = new DepthPageTransformer();
                break;
            }
            case Fade: {
                t = new FadeTransformer();
                break;
            }
            case FlipHorizontal: {
                t = new FlipHorizontalTransformer();
                break;
            }
            case FlipPage: {
                t = new FlipPageViewTransformer();
                break;
            }
            case Foreground2Background: {
                t = new ForegroundToBackgroundTransformer();
                break;
            }
            case RotateDown: {
                t = new RotateDownTransformer();
                break;
            }
            case RotateUp: {
                t = new RotateUpTransformer();
                break;
            }
            case Stack: {
                t = new StackTransformer();
                break;
            }
            case Tablet: {
                t = new TabletTransformer();
                break;
            }
            case ZoomIn: {
                t = new ZoomInTransformer();
                break;
            }
            case ZoomOutSlide: {
                t = new ZoomOutSlideTransformer();
                break;
            }
            case ZoomOut: {
                t = new ZoomOutTransformer();
            }
        }
        this.setPagerTransformer(true, t);
    }

    public void setIndicatorVisibility(PagerIndicator.IndicatorVisibility visibility) {
        if (this.mIndicator == null) {
            return;
        }
        this.mIndicator.setIndicatorVisibility(visibility);
    }

    public PagerIndicator.IndicatorVisibility getIndicatorVisibility() {
        if (this.mIndicator == null) {
            return this.mIndicator.getIndicatorVisibility();
        }
        return PagerIndicator.IndicatorVisibility.Invisible;
    }

    public PagerIndicator getPagerIndicator() {
        return this.mIndicator;
    }

    public void setPresetIndicator(PresetIndicators presetIndicator) {
        PagerIndicator pagerIndicator = (PagerIndicator)this.findViewById(presetIndicator.getResourceId());
        this.setCustomIndicator(pagerIndicator);
    }

    private InfinitePagerAdapter getWrapperAdapter() {
        PagerAdapter adapter = this.mViewPager.getAdapter();
        if (adapter != null) {
            return (InfinitePagerAdapter)adapter;
        }
        return null;
    }

    private SliderAdapter getRealAdapter() {
        PagerAdapter adapter = this.mViewPager.getAdapter();
        if (adapter != null) {
            return ((InfinitePagerAdapter)adapter).getRealAdapter();
        }
        return null;
    }

    public int getCurrentPosition() {
        if (this.getRealAdapter() == null) {
            throw new IllegalStateException("You did not set a slider adapter");
        }
        return this.mViewPager.getCurrentItem() % this.getRealAdapter().getCount();
    }

    public BaseSliderView getCurrentSlider() {
        if (this.getRealAdapter() == null) {
            throw new IllegalStateException("You did not set a slider adapter");
        }
        int count = this.getRealAdapter().getCount();
        int realCount = this.mViewPager.getCurrentItem() % count;
        return this.getRealAdapter().getSliderView(realCount);
    }

    public void removeSliderAt(int position) {
        if (this.getRealAdapter() != null) {
            this.getRealAdapter().removeSliderAt(position);
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem(), false);
        }
    }

    public void removeAllSliders() {
        if (this.getRealAdapter() != null) {
            int count = this.getRealAdapter().getCount();
            this.getRealAdapter().removeAllSliders();
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() + count, false);
        }
    }

    public void setCurrentPosition(int position, boolean smooth) {
        if (this.getRealAdapter() == null) {
            throw new IllegalStateException("You did not set a slider adapter");
        }
        if (position >= this.getRealAdapter().getCount()) {
            throw new IllegalStateException("Item position is not exist");
        }
        int p = this.mViewPager.getCurrentItem() % this.getRealAdapter().getCount();
        int n = position - p + this.mViewPager.getCurrentItem();
        this.mViewPager.setCurrentItem(n, smooth);
    }

    public void setCurrentPosition(int position) {
        this.setCurrentPosition(position, true);
    }

    public void movePrevPosition(boolean smooth) {
        if (this.getRealAdapter() == null) {
            throw new IllegalStateException("You did not set a slider adapter");
        }
        this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() - 1, smooth);
    }

    public void movePrevPosition() {
        this.movePrevPosition(true);
    }

    public void moveNextPosition(boolean smooth) {
        if (this.getRealAdapter() == null) {
            throw new IllegalStateException("You did not set a slider adapter");
        }
        this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() + 1, smooth);
    }

    public void moveNextPosition() {
        this.moveNextPosition(true);
    }

    public static enum PresetIndicators {
        Center_Bottom("Center_Bottom", R.id.default_center_bottom_indicator),
        Right_Bottom("Right_Bottom", R.id.default_bottom_right_indicator),
        Left_Bottom("Left_Bottom", R.id.default_bottom_left_indicator),
        Center_Top("Center_Top", R.id.default_center_top_indicator),
        Right_Top("Right_Top", R.id.default_center_top_right_indicator),
        Left_Top("Left_Top", R.id.default_center_top_left_indicator);

        private final String name;
        private final int id;

        private PresetIndicators(String name, int id2) {
            this.name = name;
            this.id = id2;
        }

        public String toString() {
            return this.name;
        }

        public int getResourceId() {
            return this.id;
        }
    }

    public static enum Transformer {
        Default("Default"),
        Accordion("Accordion"),
        Background2Foreground("Background2Foreground"),
        CubeIn("CubeIn"),
        DepthPage("DepthPage"),
        Fade("Fade"),
        FlipHorizontal("FlipHorizontal"),
        FlipPage("FlipPage"),
        Foreground2Background("Foreground2Background"),
        RotateDown("RotateDown"),
        RotateUp("RotateUp"),
        Stack("Stack"),
        Tablet("Tablet"),
        ZoomIn("ZoomIn"),
        ZoomOutSlide("ZoomOutSlide"),
        ZoomOut("ZoomOut");

        private final String name;

        private Transformer(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(String other) {
            return other == null ? false : this.name.equals(other);
        }
    }
}

