/*
 * Decompiled with CFR 0.152.
 */
package com.daimajia.slider.library.Indicators;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.support.v4.view.PagerAdapter;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.daimajia.slider.library.R;
import com.daimajia.slider.library.SliderAdapter;
import com.daimajia.slider.library.Tricks.InfinitePagerAdapter;
import com.daimajia.slider.library.Tricks.ViewPagerEx;
import java.util.ArrayList;

public class PagerIndicator
extends LinearLayout
implements ViewPagerEx.OnPageChangeListener {
    private Context mContext;
    private ViewPagerEx mPager;
    private ImageView mPreviousSelectedIndicator;
    private int mPreviousSelectedPosition;
    private int mUserSetUnSelectedIndicatorResId;
    private int mUserSetSelectedIndicatorResId;
    private Drawable mSelectedDrawable;
    private Drawable mUnselectedDrawable;
    private int mItemCount = 0;
    private Shape mIndicatorShape = Shape.Oval;
    private IndicatorVisibility mVisibility = IndicatorVisibility.Visible;
    private int mDefaultSelectedColor;
    private int mDefaultUnSelectedColor;
    private float mDefaultSelectedWidth;
    private float mDefaultSelectedHeight;
    private float mDefaultUnSelectedWidth;
    private float mDefaultUnSelectedHeight;
    private GradientDrawable mUnSelectedGradientDrawable;
    private GradientDrawable mSelectedGradientDrawable;
    private LayerDrawable mSelectedLayerDrawable;
    private LayerDrawable mUnSelectedLayerDrawable;
    private float mPadding_left;
    private float mPadding_right;
    private float mPadding_top;
    private float mPadding_bottom;
    private float mSelectedPadding_Left;
    private float mSelectedPadding_Right;
    private float mSelectedPadding_Top;
    private float mSelectedPadding_Bottom;
    private float mUnSelectedPadding_Left;
    private float mUnSelectedPadding_Right;
    private float mUnSelectedPadding_Top;
    private float mUnSelectedPadding_Bottom;
    private ArrayList<ImageView> mIndicators = new ArrayList();
    private DataSetObserver dataChangeObserver = new DataSetObserver(){

        public void onChanged() {
            PagerAdapter adapter = PagerIndicator.this.mPager.getAdapter();
            int count = 0;
            count = adapter instanceof InfinitePagerAdapter ? ((InfinitePagerAdapter)adapter).getRealCount() : adapter.getCount();
            if (count > PagerIndicator.this.mItemCount) {
                for (int i = 0; i < count - PagerIndicator.this.mItemCount; ++i) {
                    ImageView indicator = new ImageView(PagerIndicator.this.mContext);
                    indicator.setImageDrawable(PagerIndicator.this.mUnselectedDrawable);
                    indicator.setPadding((int)PagerIndicator.this.mUnSelectedPadding_Left, (int)PagerIndicator.this.mUnSelectedPadding_Top, (int)PagerIndicator.this.mUnSelectedPadding_Right, (int)PagerIndicator.this.mUnSelectedPadding_Bottom);
                    PagerIndicator.this.addView((View)indicator);
                    PagerIndicator.this.mIndicators.add(indicator);
                }
            } else if (count < PagerIndicator.this.mItemCount) {
                for (int i = 0; i < PagerIndicator.this.mItemCount - count; ++i) {
                    PagerIndicator.this.removeView((View)PagerIndicator.this.mIndicators.get(0));
                    PagerIndicator.this.mIndicators.remove(0);
                }
            }
            PagerIndicator.this.mItemCount = count;
            PagerIndicator.this.mPager.setCurrentItem(PagerIndicator.this.mItemCount * 20 + PagerIndicator.this.mPager.getCurrentItem());
        }

        public void onInvalidated() {
            super.onInvalidated();
            PagerIndicator.this.redraw();
        }
    };

    public PagerIndicator(Context context) {
        this(context, null);
    }

    public PagerIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.PagerIndicator, 0, 0);
        int visibility = attributes.getInt(R.styleable.PagerIndicator_visibility, IndicatorVisibility.Visible.ordinal());
        for (IndicatorVisibility v : IndicatorVisibility.values()) {
            if (v.ordinal() != visibility) continue;
            this.mVisibility = v;
            break;
        }
        int shape = attributes.getInt(R.styleable.PagerIndicator_shape, Shape.Oval.ordinal());
        for (Shape s : Shape.values()) {
            if (s.ordinal() != shape) continue;
            this.mIndicatorShape = s;
            break;
        }
        this.mUserSetSelectedIndicatorResId = attributes.getResourceId(R.styleable.PagerIndicator_selected_drawable, 0);
        this.mUserSetUnSelectedIndicatorResId = attributes.getResourceId(R.styleable.PagerIndicator_unselected_drawable, 0);
        this.mDefaultSelectedColor = attributes.getColor(R.styleable.PagerIndicator_selected_color, Color.rgb((int)255, (int)255, (int)255));
        this.mDefaultUnSelectedColor = attributes.getColor(R.styleable.PagerIndicator_unselected_color, Color.argb((int)33, (int)255, (int)255, (int)255));
        this.mDefaultSelectedWidth = attributes.getDimension(R.styleable.PagerIndicator_selected_width, (float)((int)this.pxFromDp(6.0f)));
        this.mDefaultSelectedHeight = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_selected_height, (int)this.pxFromDp(6.0f));
        this.mDefaultUnSelectedWidth = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_unselected_width, (int)this.pxFromDp(6.0f));
        this.mDefaultUnSelectedHeight = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_unselected_height, (int)this.pxFromDp(6.0f));
        this.mSelectedGradientDrawable = new GradientDrawable();
        this.mUnSelectedGradientDrawable = new GradientDrawable();
        this.mPadding_left = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_padding_left, (int)this.pxFromDp(3.0f));
        this.mPadding_right = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_padding_right, (int)this.pxFromDp(3.0f));
        this.mPadding_top = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_padding_top, (int)this.pxFromDp(0.0f));
        this.mPadding_bottom = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_padding_bottom, (int)this.pxFromDp(0.0f));
        this.mSelectedPadding_Left = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_selected_padding_left, (int)this.mPadding_left);
        this.mSelectedPadding_Right = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_selected_padding_right, (int)this.mPadding_right);
        this.mSelectedPadding_Top = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_selected_padding_top, (int)this.mPadding_top);
        this.mSelectedPadding_Bottom = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_selected_padding_bottom, (int)this.mPadding_bottom);
        this.mUnSelectedPadding_Left = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_unselected_padding_left, (int)this.mPadding_left);
        this.mUnSelectedPadding_Right = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_unselected_padding_right, (int)this.mPadding_right);
        this.mUnSelectedPadding_Top = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_unselected_padding_top, (int)this.mPadding_top);
        this.mUnSelectedPadding_Bottom = attributes.getDimensionPixelSize(R.styleable.PagerIndicator_unselected_padding_bottom, (int)this.mPadding_bottom);
        this.mSelectedLayerDrawable = new LayerDrawable(new Drawable[]{this.mSelectedGradientDrawable});
        this.mUnSelectedLayerDrawable = new LayerDrawable(new Drawable[]{this.mUnSelectedGradientDrawable});
        this.setIndicatorStyleResource(this.mUserSetSelectedIndicatorResId, this.mUserSetUnSelectedIndicatorResId);
        this.setDefaultIndicatorShape(this.mIndicatorShape);
        this.setDefaultSelectedIndicatorSize(this.mDefaultSelectedWidth, this.mDefaultSelectedHeight, Unit.Px);
        this.setDefaultUnselectedIndicatorSize(this.mDefaultUnSelectedWidth, this.mDefaultUnSelectedHeight, Unit.Px);
        this.setDefaultIndicatorColor(this.mDefaultSelectedColor, this.mDefaultUnSelectedColor);
        this.setIndicatorVisibility(this.mVisibility);
        attributes.recycle();
    }

    public void setDefaultIndicatorShape(Shape shape) {
        if (this.mUserSetSelectedIndicatorResId == 0) {
            if (shape == Shape.Oval) {
                this.mSelectedGradientDrawable.setShape(1);
            } else {
                this.mSelectedGradientDrawable.setShape(0);
            }
        }
        if (this.mUserSetUnSelectedIndicatorResId == 0) {
            if (shape == Shape.Oval) {
                this.mUnSelectedGradientDrawable.setShape(1);
            } else {
                this.mUnSelectedGradientDrawable.setShape(0);
            }
        }
        this.resetDrawable();
    }

    public void setIndicatorStyleResource(int selected, int unselected) {
        this.mUserSetSelectedIndicatorResId = selected;
        this.mUserSetUnSelectedIndicatorResId = unselected;
        this.mSelectedDrawable = selected == 0 ? this.mSelectedLayerDrawable : this.mContext.getResources().getDrawable(this.mUserSetSelectedIndicatorResId);
        this.mUnselectedDrawable = unselected == 0 ? this.mUnSelectedLayerDrawable : this.mContext.getResources().getDrawable(this.mUserSetUnSelectedIndicatorResId);
        this.resetDrawable();
    }

    public void setDefaultIndicatorColor(int selectedColor, int unselectedColor) {
        if (this.mUserSetSelectedIndicatorResId == 0) {
            this.mSelectedGradientDrawable.setColor(selectedColor);
        }
        if (this.mUserSetUnSelectedIndicatorResId == 0) {
            this.mUnSelectedGradientDrawable.setColor(unselectedColor);
        }
        this.resetDrawable();
    }

    public void setDefaultSelectedIndicatorSize(float width, float height, Unit unit) {
        if (this.mUserSetSelectedIndicatorResId == 0) {
            float w = width;
            float h = height;
            if (unit == Unit.DP) {
                w = this.pxFromDp(width);
                h = this.pxFromDp(height);
            }
            this.mSelectedGradientDrawable.setSize((int)w, (int)h);
            this.resetDrawable();
        }
    }

    public void setDefaultUnselectedIndicatorSize(float width, float height, Unit unit) {
        if (this.mUserSetUnSelectedIndicatorResId == 0) {
            float w = width;
            float h = height;
            if (unit == Unit.DP) {
                w = this.pxFromDp(width);
                h = this.pxFromDp(height);
            }
            this.mUnSelectedGradientDrawable.setSize((int)w, (int)h);
            this.resetDrawable();
        }
    }

    public void setDefaultIndicatorSize(float width, float height, Unit unit) {
        this.setDefaultSelectedIndicatorSize(width, height, unit);
        this.setDefaultUnselectedIndicatorSize(width, height, unit);
    }

    private float dpFromPx(float px) {
        return px / this.getContext().getResources().getDisplayMetrics().density;
    }

    private float pxFromDp(float dp) {
        return dp * this.getContext().getResources().getDisplayMetrics().density;
    }

    public void setIndicatorVisibility(IndicatorVisibility visibility) {
        if (visibility == IndicatorVisibility.Visible) {
            this.setVisibility(0);
        } else {
            this.setVisibility(4);
        }
        this.resetDrawable();
    }

    public void destroySelf() {
        if (this.mPager == null || this.mPager.getAdapter() == null) {
            return;
        }
        InfinitePagerAdapter wrapper = (InfinitePagerAdapter)this.mPager.getAdapter();
        SliderAdapter adapter = wrapper.getRealAdapter();
        if (adapter != null) {
            adapter.unregisterDataSetObserver(this.dataChangeObserver);
        }
        this.removeAllViews();
    }

    public void setViewPager(ViewPagerEx pager) {
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("Viewpager does not have adapter instance");
        }
        this.mPager = pager;
        this.mPager.addOnPageChangeListener(this);
        ((InfinitePagerAdapter)this.mPager.getAdapter()).getRealAdapter().registerDataSetObserver(this.dataChangeObserver);
    }

    private void resetDrawable() {
        for (View view : this.mIndicators) {
            if (this.mPreviousSelectedIndicator != null && this.mPreviousSelectedIndicator.equals(view)) {
                ((ImageView)view).setImageDrawable(this.mSelectedDrawable);
                continue;
            }
            ((ImageView)view).setImageDrawable(this.mUnselectedDrawable);
        }
    }

    public void redraw() {
        this.mItemCount = this.getShouldDrawCount();
        this.mPreviousSelectedIndicator = null;
        for (View view : this.mIndicators) {
            this.removeView(view);
        }
        for (int i = 0; i < this.mItemCount; ++i) {
            ImageView imageView = new ImageView(this.mContext);
            imageView.setImageDrawable(this.mUnselectedDrawable);
            imageView.setPadding((int)this.mUnSelectedPadding_Left, (int)this.mUnSelectedPadding_Top, (int)this.mUnSelectedPadding_Right, (int)this.mUnSelectedPadding_Bottom);
            this.addView((View)imageView);
            this.mIndicators.add(imageView);
        }
        this.setItemAsSelected(this.mPreviousSelectedPosition);
    }

    private int getShouldDrawCount() {
        if (this.mPager.getAdapter() instanceof InfinitePagerAdapter) {
            return ((InfinitePagerAdapter)this.mPager.getAdapter()).getRealCount();
        }
        return this.mPager.getAdapter().getCount();
    }

    private void setItemAsSelected(int position) {
        ImageView currentSelected;
        if (this.mPreviousSelectedIndicator != null) {
            this.mPreviousSelectedIndicator.setImageDrawable(this.mUnselectedDrawable);
            this.mPreviousSelectedIndicator.setPadding((int)this.mUnSelectedPadding_Left, (int)this.mUnSelectedPadding_Top, (int)this.mUnSelectedPadding_Right, (int)this.mUnSelectedPadding_Bottom);
        }
        if ((currentSelected = (ImageView)this.getChildAt(position + 1)) != null) {
            currentSelected.setImageDrawable(this.mSelectedDrawable);
            currentSelected.setPadding((int)this.mSelectedPadding_Left, (int)this.mSelectedPadding_Top, (int)this.mSelectedPadding_Right, (int)this.mSelectedPadding_Bottom);
            this.mPreviousSelectedIndicator = currentSelected;
        }
        this.mPreviousSelectedPosition = position;
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public IndicatorVisibility getIndicatorVisibility() {
        return this.mVisibility;
    }

    @Override
    public void onPageSelected(int position) {
        if (this.mItemCount == 0) {
            return;
        }
        this.setItemAsSelected(position - 1);
    }

    @Override
    public void onPageScrollStateChanged(int state) {
    }

    public int getSelectedIndicatorResId() {
        return this.mUserSetSelectedIndicatorResId;
    }

    public int getUnSelectedIndicatorResId() {
        return this.mUserSetUnSelectedIndicatorResId;
    }

    public static enum Unit {
        DP,
        Px;

    }

    public static enum Shape {
        Oval,
        Rectangle;

    }

    public static enum IndicatorVisibility {
        Visible,
        Invisible;

    }
}

