/*
 * Decompiled with CFR 0.152.
 */
package com.daimajia.androidanimations.library;

import android.animation.Animator;
import android.view.View;
import android.view.animation.Interpolator;
import com.daimajia.androidanimations.library.BaseViewAnimator;
import com.daimajia.androidanimations.library.Techniques;
import java.util.ArrayList;
import java.util.List;

public class YoYo {
    private static final long DURATION = 1000L;
    private static final long NO_DELAY = 0L;
    public static final int INFINITE = -1;
    private BaseViewAnimator animator;
    private long duration;
    private long delay;
    private boolean repeat;
    private long repeatTimes;
    private Interpolator interpolator;
    private List<Animator.AnimatorListener> callbacks;
    private View target;

    private YoYo(AnimationComposer animationComposer) {
        this.animator = animationComposer.animator;
        this.duration = animationComposer.duration;
        this.delay = animationComposer.delay;
        this.repeat = animationComposer.repeat;
        this.repeatTimes = animationComposer.repeatTimes;
        this.interpolator = animationComposer.interpolator;
        this.callbacks = animationComposer.callbacks;
        this.target = animationComposer.target;
    }

    public static AnimationComposer with(Techniques techniques) {
        return new AnimationComposer(techniques);
    }

    public static AnimationComposer with(BaseViewAnimator animator) {
        return new AnimationComposer(animator);
    }

    private BaseViewAnimator play() {
        this.animator.setTarget(this.target);
        this.animator.setDuration(this.duration).setInterpolator(this.interpolator).setStartDelay(this.delay);
        if (this.callbacks.size() > 0) {
            for (Animator.AnimatorListener callback : this.callbacks) {
                this.animator.addAnimatorListener(callback);
            }
        }
        if (this.repeat) {
            this.animator.addAnimatorListener(new Animator.AnimatorListener(){
                private long currentTimes = 0L;

                public void onAnimationStart(Animator animation) {
                    ++this.currentTimes;
                }

                public void onAnimationEnd(Animator animation) {
                    if (!YoYo.this.repeat) {
                        return;
                    }
                    if (YoYo.this.repeatTimes == -1L || this.currentTimes < YoYo.this.repeatTimes) {
                        YoYo.this.animator.restart();
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    YoYo.this.repeatTimes = 0L;
                    YoYo.this.repeat = false;
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
        this.animator.animate();
        return this.animator;
    }

    public static final class YoYoString {
        private BaseViewAnimator animator;
        private View target;

        private YoYoString(BaseViewAnimator animator, View target) {
            this.target = target;
            this.animator = animator;
        }

        public boolean isStarted() {
            return this.animator.isStarted();
        }

        public boolean isRunning() {
            return this.animator.isRunning();
        }

        public void stop(boolean reset) {
            this.animator.cancel();
            if (reset) {
                this.animator.reset(this.target);
            }
        }
    }

    public static final class AnimationComposer {
        private List<Animator.AnimatorListener> callbacks = new ArrayList<Animator.AnimatorListener>();
        private BaseViewAnimator animator;
        private long duration = 1000L;
        private long delay = 0L;
        private boolean repeat = false;
        private long repeatTimes = 0L;
        private Interpolator interpolator;
        private View target;

        private AnimationComposer(Techniques techniques) {
            this.animator = techniques.getAnimator();
        }

        private AnimationComposer(BaseViewAnimator animator) {
            this.animator = animator;
        }

        public AnimationComposer duration(long duration) {
            this.duration = duration;
            return this;
        }

        public AnimationComposer delay(long delay) {
            this.delay = delay;
            return this;
        }

        public AnimationComposer interpolate(Interpolator interpolator) {
            this.interpolator = interpolator;
            return this;
        }

        public AnimationComposer repeat(int times) {
            if (times < -1) {
                throw new RuntimeException("Can not be less than -1, -1 is infinite loop");
            }
            this.repeat = times != 0;
            this.repeatTimes = times;
            return this;
        }

        public AnimationComposer withListener(Animator.AnimatorListener listener) {
            this.callbacks.add(listener);
            return this;
        }

        public AnimationComposer onStart(final AnimatorCallback callback) {
            this.callbacks.add(new EmptyAnimatorListener(){

                @Override
                public void onAnimationStart(Animator animation) {
                    callback.call(animation);
                }
            });
            return this;
        }

        public AnimationComposer onEnd(final AnimatorCallback callback) {
            this.callbacks.add(new EmptyAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    callback.call(animation);
                }
            });
            return this;
        }

        public AnimationComposer onCancel(final AnimatorCallback callback) {
            this.callbacks.add(new EmptyAnimatorListener(){

                @Override
                public void onAnimationCancel(Animator animation) {
                    callback.call(animation);
                }
            });
            return this;
        }

        public AnimationComposer onRepeat(final AnimatorCallback callback) {
            this.callbacks.add(new EmptyAnimatorListener(){

                @Override
                public void onAnimationRepeat(Animator animation) {
                    callback.call(animation);
                }
            });
            return this;
        }

        public YoYoString playOn(View target) {
            this.target = target;
            return new YoYoString(new YoYo(this).play(), this.target);
        }
    }

    private static class EmptyAnimatorListener
    implements Animator.AnimatorListener {
        private EmptyAnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    public static interface AnimatorCallback {
        public void call(Animator var1);
    }
}

